/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.impl;

import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jConfiguration;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jDatabaseIdentifier;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.exceptions.ClientException;

public class BoltNeo4jClient {
    private static final Log log = LoggerFactory.getLogger();
    private final Driver driver;
    private final String databaseUri;

    public BoltNeo4jClient(RemoteNeo4jDatabaseIdentifier identifier, RemoteNeo4jConfiguration configuration) {
        this.databaseUri = identifier.getDatabaseUri();
        this.driver = this.createNeo4jDriver(identifier, configuration);
    }

    private Driver createNeo4jDriver(RemoteNeo4jDatabaseIdentifier identifier, RemoteNeo4jConfiguration configuration) {
        String uri = identifier.getDatabaseUri();
        if (configuration.isAuthenticationRequired()) {
            AuthToken authToken = AuthTokens.basic((String)configuration.getUsername(), (String)configuration.getPassword());
            return GraphDatabase.driver((String)uri, (AuthToken)authToken);
        }
        return GraphDatabase.driver((String)uri);
    }

    public void validateConnection() {
        try {
            this.driver.session().close();
        }
        catch (ClientException e) {
            throw log.connectionFailed(this.databaseUri, e.neo4jErrorCode(), e.getMessage());
        }
    }

    public void close() {
        if (this.driver != null) {
            this.driver.close();
        }
    }

    public Driver getDriver() {
        return this.driver;
    }
}

