/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.neo4j.EmbeddedNeo4jDialect;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.util.impl.EmbeddedHelper;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public final class EmbeddedNeo4jTupleSnapshot
implements TupleSnapshot {
    private Node node;
    private final EntityKeyMetadata entityKeyMetadata;
    private final Map<String, AssociatedEntityKeyMetadata> associatedEntityKeyMetadata;
    private final Map<String, String> rolesByColumn;

    private EmbeddedNeo4jTupleSnapshot(Node node, Map<String, AssociatedEntityKeyMetadata> associatedEntityKeyMetadata, Map<String, String> rolesByColumn, EntityKeyMetadata entityKeyMetadata) {
        this.node = node;
        this.associatedEntityKeyMetadata = associatedEntityKeyMetadata;
        this.rolesByColumn = rolesByColumn;
        this.entityKeyMetadata = entityKeyMetadata;
    }

    public static EmbeddedNeo4jTupleSnapshot emptySnapshot(EntityKeyMetadata entityKeyMetadata) {
        return new EmbeddedNeo4jTupleSnapshot(null, Collections.emptyMap(), Collections.emptyMap(), entityKeyMetadata);
    }

    public static EmbeddedNeo4jTupleSnapshot fromNode(Node node, Map<String, AssociatedEntityKeyMetadata> associatedEntityKeyMetadata, Map<String, String> rolesByColumn, EntityKeyMetadata entityKeyMetadata) {
        return new EmbeddedNeo4jTupleSnapshot(node, associatedEntityKeyMetadata, rolesByColumn, entityKeyMetadata);
    }

    public Object get(String column) {
        if (this.isNew()) {
            return null;
        }
        if (this.associatedEntityKeyMetadata.containsKey(column)) {
            return this.readPropertyOnOtherNode(column);
        }
        if (EmbeddedNeo4jDialect.isPartOfRegularEmbedded(this.entityKeyMetadata.getColumnNames(), column)) {
            return this.readEmbeddedProperty(column);
        }
        return this.readProperty(this.node, column);
    }

    private Object readPropertyOnOtherNode(String column) {
        Iterator relationships = this.node.getRelationships(Direction.OUTGOING, new RelationshipType[]{DynamicRelationshipType.withName((String)this.rolesByColumn.get(column))}).iterator();
        if (relationships.hasNext()) {
            Node otherNode = ((Relationship)relationships.next()).getEndNode();
            return this.readProperty(otherNode, this.associatedEntityKeyMetadata.get(column).getCorrespondingEntityKeyColumn(column));
        }
        return null;
    }

    private Object readEmbeddedProperty(String column) {
        String[] split = EmbeddedHelper.split((String)column);
        Node embeddedNode = this.node;
        for (int i = 0; i < split.length - 1; ++i) {
            String relType = split[i];
            Iterator rels = embeddedNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{DynamicRelationshipType.withName((String)relType)}).iterator();
            if (!rels.hasNext()) {
                return null;
            }
            embeddedNode = ((Relationship)rels.next()).getEndNode();
        }
        return this.readProperty(embeddedNode, split[split.length - 1]);
    }

    private Object readProperty(Node otherNode, String targetColumnName) {
        Object value = null;
        if (otherNode.hasProperty(targetColumnName)) {
            value = otherNode.getProperty(targetColumnName);
        }
        return value;
    }

    public boolean isEmpty() {
        return this.isNew() ? true : !this.node.getPropertyKeys().iterator().hasNext();
    }

    public Set<String> getColumnNames() {
        if (this.isNew()) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        for (String string : this.node.getPropertyKeys()) {
            names.add(string);
        }
        return names;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public boolean isNew() {
        return this.node == null;
    }
}

