/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.tree.Tree;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jAliasResolver;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jPropertyHelper;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParameter;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParsingResult;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.OrderByClause;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.PropertyIdentifier;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.RelationshipAliasTree;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jPredicateFactory;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.type.Type;

public class Neo4jQueryRendererDelegate
extends SingleEntityQueryRendererDelegate<StringBuilder, Neo4jQueryParsingResult> {
    private static final Log LOG = LoggerFactory.getLogger();
    private final Neo4jPropertyHelper propertyHelper;
    private final SessionFactoryImplementor sessionFactory;
    private final Neo4jAliasResolver aliasResolver;
    private List<OrderByClause> orderByExpressions;
    private JoinType joinType;

    public Neo4jQueryRendererDelegate(SessionFactoryImplementor sessionFactory, Neo4jAliasResolver aliasResolver, EntityNamesResolver entityNames, Neo4jPropertyHelper propertyHelper, Map<String, Object> namedParameters) {
        super((PropertyHelper)propertyHelper, entityNames, Neo4jQueryRendererDelegate.singleEntityQueryBuilder(propertyHelper), namedParameters);
        this.sessionFactory = sessionFactory;
        this.aliasResolver = aliasResolver;
        this.propertyHelper = propertyHelper;
    }

    private static SingleEntityQueryBuilder<StringBuilder> singleEntityQueryBuilder(Neo4jPropertyHelper propertyHelper) {
        return SingleEntityQueryBuilder.getInstance((PredicateFactory)new Neo4jPredicateFactory(propertyHelper), (PropertyHelper)propertyHelper);
    }

    private EntityKeyMetadata getKeyMetaData(Class<?> entityType) {
        return this.getEntityPersister(entityType).getEntityKeyMetadata();
    }

    private OgmEntityPersister getEntityPersister(Class<?> entityType) {
        OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(entityType.getName());
        return persister;
    }

    public Neo4jQueryParsingResult getResult() {
        String targetAlias = this.aliasResolver.findAliasForType(this.targetTypeName);
        String label = this.getKeyMetaData(this.targetType).getTable();
        StringBuilder queryBuilder = new StringBuilder();
        this.match(queryBuilder, targetAlias, label);
        this.where(queryBuilder, targetAlias);
        this.optionalMatch(queryBuilder, targetAlias);
        this.returns(queryBuilder, targetAlias);
        this.orderBy(queryBuilder);
        return new Neo4jQueryParsingResult(this.targetType, this.projections, queryBuilder.toString());
    }

    private void match(StringBuilder queryBuilder, String targetAlias, String label) {
        queryBuilder.append("MATCH ");
        CypherDSL.node(queryBuilder, targetAlias, label);
        RelationshipAliasTree node = this.aliasResolver.getRelationshipAliasTree(targetAlias);
        boolean first = true;
        if (node != null) {
            for (RelationshipAliasTree child : node.getChildren()) {
                if (this.aliasResolver.isOptionalMatch(child.getAlias())) continue;
                StringBuilder relationshipMatch = new StringBuilder();
                if (first) {
                    first = false;
                } else {
                    relationshipMatch.append(", ");
                    CypherDSL.node(relationshipMatch, targetAlias, label);
                }
                CypherDSL.relationship(relationshipMatch, child.getRelationshipName());
                CypherDSL.node(relationshipMatch, child.getAlias(), child.getTargetEntityName());
                this.appendMatchRelationship(queryBuilder, relationshipMatch.toString(), child);
            }
        }
    }

    private void appendMatchRelationship(StringBuilder queryBuilder, String currentMatch, RelationshipAliasTree node) {
        if (node.getChildren().isEmpty()) {
            queryBuilder.append(currentMatch);
        } else {
            for (RelationshipAliasTree child : node.getChildren()) {
                boolean optional = this.aliasResolver.isOptionalMatch(child.getAlias());
                if (!optional) {
                    StringBuilder builder = new StringBuilder(currentMatch);
                    CypherDSL.relationship(builder, child.getRelationshipName());
                    CypherDSL.node(builder, child.getAlias(), child.getTargetEntityName());
                    this.appendMatchRelationship(queryBuilder, builder.toString(), child);
                    continue;
                }
                queryBuilder.append(currentMatch);
            }
        }
    }

    private void optionalMatch(StringBuilder queryBuilder, String targetAlias) {
        RelationshipAliasTree node = this.aliasResolver.getRelationshipAliasTree(targetAlias);
        if (node != null) {
            this.appendOptionalMatch(queryBuilder, targetAlias, node.getChildren());
        }
    }

    private void appendOptionalMatch(StringBuilder queryBuilder, String targetAlias, List<RelationshipAliasTree> children) {
        for (RelationshipAliasTree child : children) {
            if (this.aliasResolver.isOptionalMatch(child.getAlias())) {
                queryBuilder.append(" OPTIONAL MATCH ");
                CypherDSL.node(queryBuilder, targetAlias, new String[0]);
                CypherDSL.relationship(queryBuilder, child.getRelationshipName());
                CypherDSL.node(queryBuilder, child.getAlias(), child.getTargetEntityName());
            }
            this.appendOptionalMatch(queryBuilder, child.getAlias(), child.getChildren());
        }
    }

    private void where(StringBuilder queryBuilder, String targetAlias) {
        StringBuilder whereCondition = (StringBuilder)this.builder.build();
        if (whereCondition != null) {
            queryBuilder.append(" WHERE ");
            queryBuilder.append((CharSequence)whereCondition);
        }
        this.appendDiscriminatorClause(queryBuilder, targetAlias, whereCondition);
    }

    private void appendDiscriminatorClause(StringBuilder queryBuilder, String targetAlias, StringBuilder whereCondition) {
        OgmEntityPersister entityPersister = this.getEntityPersister(this.targetType);
        String discriminatorColumnName = entityPersister.getDiscriminatorColumnName();
        if (discriminatorColumnName != null) {
            this.addConditionOnDiscriminatorValue(queryBuilder, targetAlias, whereCondition, entityPersister, discriminatorColumnName);
        } else if (entityPersister.hasSubclasses()) {
            Set subclassEntityNames = entityPersister.getEntityMetamodel().getSubclassEntityNames();
            throw LOG.queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass("Neo4j", subclassEntityNames);
        }
    }

    private void addConditionOnDiscriminatorValue(StringBuilder queryBuilder, String targetAlias, StringBuilder whereCondition, OgmEntityPersister entityPersister, String discriminatorColumnName) {
        if (whereCondition != null) {
            queryBuilder.append(" AND ");
        } else {
            queryBuilder.append(" WHERE ");
        }
        Set subclassEntityNames = entityPersister.getEntityMetamodel().getSubclassEntityNames();
        CypherDSL.identifier(queryBuilder, targetAlias);
        queryBuilder.append(".");
        CypherDSL.identifier(queryBuilder, discriminatorColumnName);
        Type discriminatorType = entityPersister.getDiscriminatorType();
        if (subclassEntityNames.size() == 1) {
            queryBuilder.append(" = ");
            this.appendDiscriminatorValue(queryBuilder, discriminatorType, entityPersister.getDiscriminatorValue());
        } else {
            queryBuilder.append(" IN [");
            HashSet<Object> discrimiantorValues = new HashSet<Object>();
            discrimiantorValues.add(entityPersister.getDiscriminatorValue());
            String separator = "";
            for (String subclass : subclassEntityNames) {
                OgmEntityPersister subclassPersister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(subclass);
                Object discriminatorValue = subclassPersister.getDiscriminatorValue();
                queryBuilder.append(separator);
                this.appendDiscriminatorValue(queryBuilder, discriminatorType, discriminatorValue);
                separator = ", ";
            }
            queryBuilder.append("]");
        }
    }

    private void appendDiscriminatorValue(StringBuilder queryBuilder, Type discriminatorType, Object discriminatorValue) {
        Object value = this.convertToBackendType(discriminatorType, discriminatorValue);
        CypherDSL.literal(queryBuilder, value);
    }

    private Object convertToBackendType(Type discriminatorType, Object discriminatorValue) {
        GridType ogmType = ((TypeTranslator)this.sessionFactory.getServiceRegistry().getService(TypeTranslator.class)).getType(discriminatorType);
        return ogmType.convertToBackendType(discriminatorValue, this.sessionFactory);
    }

    private void orderBy(StringBuilder queryBuilder) {
        if (this.orderByExpressions != null && !this.orderByExpressions.isEmpty()) {
            queryBuilder.append(" ORDER BY ");
            int counter = 1;
            for (OrderByClause orderBy : this.orderByExpressions) {
                orderBy.asString(queryBuilder);
                if (counter++ >= this.orderByExpressions.size()) continue;
                queryBuilder.append(", ");
            }
        }
    }

    private void returns(StringBuilder builder, String targetAlias) {
        builder.append(" RETURN ");
        if (this.projections.isEmpty()) {
            CypherDSL.identifier(builder, targetAlias);
        } else {
            int counter = 1;
            for (String projection : this.projections) {
                builder.append(projection);
                if (counter++ >= this.projections.size()) continue;
                builder.append(", ");
            }
        }
    }

    public void setPropertyPath(PropertyPath path) {
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_SELECT) {
            this.defineSelect(path);
        } else {
            this.propertyPath = path;
        }
    }

    private void defineSelect(PropertyPath path) {
        List pathWithoutAlias = this.resolveAlias(path);
        if (!pathWithoutAlias.isEmpty()) {
            PropertyIdentifier identifier = this.propertyHelper.getPropertyIdentifier(this.targetTypeName, pathWithoutAlias, 0);
            String projection = CypherDSL.identifier(identifier.getAlias(), identifier.getPropertyName());
            this.projections.add(projection);
        }
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = new ArrayList<OrderByClause>();
        }
        List propertyPathWithoutAlias = this.resolveAlias(propertyPath);
        PropertyIdentifier identifier = this.propertyHelper.getPropertyIdentifier(this.targetTypeName, propertyPathWithoutAlias, 0);
        OrderByClause order = new OrderByClause(identifier.getAlias(), identifier.getPropertyName(), isAscending);
        this.orderByExpressions.add(order);
    }

    public void pushFromStrategy(JoinType joinType, Tree associationFetchTree, Tree propertyFetchTree, Tree alias) {
        super.pushFromStrategy(joinType, associationFetchTree, propertyFetchTree, alias);
        this.joinType = joinType;
    }

    public void popStrategy() {
        super.popStrategy();
        this.joinType = null;
    }

    public void registerJoinAlias(Tree alias, PropertyPath path) {
        int requiredDepth;
        super.registerJoinAlias(alias, path);
        List propertyPath = this.resolveAlias(path);
        if (JoinType.INNER.equals(this.joinType)) {
            requiredDepth = propertyPath.size();
        } else if (JoinType.LEFT.equals(this.joinType)) {
            requiredDepth = 0;
        } else {
            LOG.joinTypeNotFullySupported(this.joinType);
            requiredDepth = propertyPath.size();
        }
        this.propertyHelper.getPropertyIdentifier(this.targetTypeName, propertyPath, requiredDepth);
    }

    public void predicateLess(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS);
    }

    public void predicateLessOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS_OR_EQUAL);
    }

    public void predicateEquals(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
    }

    public void predicateNotEquals(String comparativePredicate) {
        this.builder.pushNotPredicate();
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
        this.builder.popBooleanPredicate();
    }

    public void predicateGreaterOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER_OR_EQUAL);
    }

    public void predicateGreater(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER);
    }

    private void addComparisonPredicate(String comparativePredicate, ComparisonPredicate.Type comparisonType) {
        Object comparisonValue = this.fromNamedQuery(comparativePredicate);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addComparisonPredicate(property, comparisonType, comparisonValue);
    }

    public void predicateIn(List<String> list) {
        List<Object> values = this.fromNamedQuery(list);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addInPredicate(property, values);
    }

    public void predicateBetween(String lower, String upper) {
        Object lowerComparisonValue = this.fromNamedQuery(lower);
        Object upperComparisonValue = this.fromNamedQuery(upper);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addRangePredicate(property, lowerComparisonValue, upperComparisonValue);
    }

    public void predicateLike(String patternValue, Character escapeCharacter) {
        Object pattern = this.fromNamedQuery(patternValue);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addLikePredicate(property, (String)pattern, escapeCharacter);
    }

    public void predicateIsNull() {
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addIsNullPredicate(property);
    }

    private Object fromNamedQuery(String comparativePredicate) {
        if (comparativePredicate.startsWith(":")) {
            return new Neo4jQueryParameter(comparativePredicate.substring(1));
        }
        ArrayList path = new ArrayList();
        path.addAll(this.propertyPath.getNodeNamesWithoutAlias());
        PropertyPath fullPath = this.propertyPath;
        while (fullPath.getFirstNode().isAlias() && this.aliasToPropertyPath.containsKey(fullPath.getFirstNode().getName())) {
            fullPath = (PropertyPath)this.aliasToPropertyPath.get(fullPath.getFirstNode().getName());
            path.addAll(0, fullPath.getNodeNamesWithoutAlias());
        }
        return this.propertyHelper.convertToPropertyType(this.targetTypeName, path, comparativePredicate);
    }

    private List<Object> fromNamedQuery(List<String> list) {
        ArrayList<Object> elements = new ArrayList<Object>(list.size());
        for (String string : list) {
            elements.add(this.fromNamedQuery(string));
        }
        return elements;
    }
}

