/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl;

import java.util.Collections;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.BaseNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;

public class EmbeddedNeo4jSequenceGenerator
extends BaseNeo4jSequenceGenerator {
    private static final Log logger = LoggerFactory.getLogger();
    private static final String SEQUENCE_CREATION_QUERY = "MERGE (n:" + NodeLabel.SEQUENCE.name() + " {" + "sequence_name" + ": {sequenceName}} ) ON CREATE SET n." + "next_val" + " = {initialValue} RETURN n";
    private static final String SEQUENCE_VALUE_QUERY = "MATCH (n:" + NodeLabel.SEQUENCE.name() + ") WHERE n." + "sequence_name" + " = {sequenceName} RETURN n";
    private final BoundedConcurrentHashMap<String, String> queryCache;
    private final GraphDatabaseService neo4jDb;

    public EmbeddedNeo4jSequenceGenerator(GraphDatabaseService neo4jDb, int sequenceCacheMaxSize) {
        this.neo4jDb = neo4jDb;
        this.queryCache = new BoundedConcurrentHashMap(sequenceCacheMaxSize, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    public void createSequences(Iterable<Sequence> sequences) {
        this.addUniqueConstraintForSequences();
        this.addSequences(sequences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUniqueConstraintsForTableSequences(Iterable<IdSourceKeyMetadata> tableIdGenerators) {
        try (Transaction tx = null;){
            tx = this.neo4jDb.beginTx();
            for (IdSourceKeyMetadata idSourceKeyMetadata : tableIdGenerators) {
                if (idSourceKeyMetadata.getType() != IdSourceKeyMetadata.IdSourceType.TABLE) continue;
                this.addUniqueConstraintForTableBasedSequence(idSourceKeyMetadata);
            }
            tx.success();
        }
    }

    private void addUniqueConstraintForSequences() {
        try (Transaction tx = null;){
            tx = this.neo4jDb.beginTx();
            if (this.isMissingUniqueConstraint(NodeLabel.SEQUENCE)) {
                this.neo4jDb.schema().constraintFor((Label)NodeLabel.SEQUENCE).assertPropertyIsUnique("sequence_name").create();
            }
            tx.success();
        }
    }

    private void addUniqueConstraintForTableBasedSequence(IdSourceKeyMetadata generatorKeyMetadata) {
        Label generatorKeyLabel = Label.label((String)generatorKeyMetadata.getName());
        if (this.isMissingUniqueConstraint(generatorKeyLabel)) {
            this.neo4jDb.schema().constraintFor(generatorKeyLabel).assertPropertyIsUnique(generatorKeyMetadata.getKeyColumnName()).create();
        }
    }

    private boolean isMissingUniqueConstraint(Label generatorKeyLabel) {
        Iterable constraints = this.neo4jDb.schema().getConstraints(generatorKeyLabel);
        for (ConstraintDefinition constraint : constraints) {
            if (!constraint.isConstraintType(ConstraintType.UNIQUENESS)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSequences(Iterable<Sequence> sequences) {
        try (Transaction tx = null;){
            tx = this.neo4jDb.beginTx();
            for (Sequence sequence : sequences) {
                this.addSequence(sequence);
            }
            tx.success();
        }
    }

    private void addTableSequence(NextValueRequest request) {
        IdSourceKeyMetadata idSourceKeyMetadata = request.getKey().getMetadata();
        String query = "MERGE (n" + this.labels(idSourceKeyMetadata.getName(), NodeLabel.TABLE_BASED_SEQUENCE.name()) + " { " + idSourceKeyMetadata.getKeyColumnName() + ": {" + "sequenceName" + "}} ) ON CREATE SET n." + idSourceKeyMetadata.getValueColumnName() + " = {" + "initialValue" + "} RETURN n";
        this.neo4jDb.execute(query, this.params(request));
    }

    private void addSequence(Sequence sequence) {
        this.neo4jDb.execute(SEQUENCE_CREATION_QUERY, this.params(sequence));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long nextValue(NextValueRequest request) {
        Lock lock = null;
        try (Transaction tx = this.neo4jDb.beginTx();){
            Node sequence = this.getSequence(request.getKey());
            if (sequence == null) {
                if (request.getKey().getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.SEQUENCE) {
                    throw logger.sequenceNotFound(this.sequenceName(request.getKey()));
                }
                this.addTableSequence(request);
                sequence = this.getSequence(request.getKey());
            }
            lock = tx.acquireWriteLock((PropertyContainer)sequence);
            long nextValue = this.updateSequenceValue(request.getKey(), sequence, request.getIncrement());
            tx.success();
            lock.release();
            Long l = nextValue;
            return l;
        }
    }

    private Node getSequence(IdSourceKey idSourceKey) {
        String updateSequenceQuery = this.getQuery(idSourceKey);
        Result result = this.neo4jDb.execute(updateSequenceQuery, Collections.singletonMap("sequenceName", this.sequenceName(idSourceKey)));
        ResourceIterator column = result.columnAs("n");
        Node node = null;
        if (column.hasNext()) {
            node = (Node)column.next();
        }
        column.close();
        return node;
    }

    private String getQuery(IdSourceKey idSourceKey) {
        return idSourceKey.getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.TABLE ? this.getTableQuery(idSourceKey) : SEQUENCE_VALUE_QUERY;
    }

    private String getTableQuery(IdSourceKey idSourceKey) {
        String query = (String)this.queryCache.get((Object)idSourceKey.getTable());
        if (query == null) {
            query = "MATCH (n" + this.labels(idSourceKey.getTable(), NodeLabel.TABLE_BASED_SEQUENCE.name()) + ") WHERE n." + idSourceKey.getMetadata().getKeyColumnName() + " = {" + "sequenceName" + "} RETURN n";
            String cached = (String)this.queryCache.putIfAbsent((Object)idSourceKey.getTable(), (Object)query);
            if (cached != null) {
                query = cached;
            }
        }
        return query;
    }

    private Long updateSequenceValue(IdSourceKey idSourceKey, Node sequence, int increment) {
        String valueProperty = idSourceKey.getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.TABLE ? idSourceKey.getMetadata().getValueColumnName() : "next_val";
        Number currentValue = (Number)sequence.getProperty(valueProperty);
        long updatedValue = currentValue.longValue() + (long)increment;
        sequence.setProperty(valueProperty, (Object)updatedValue);
        return currentValue.longValue();
    }
}

