/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.common.impl;

import java.util.Map;
import org.hibernate.ogm.cfg.spi.Hosts;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jBasedQueryParserService;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jConfiguration;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jDatabaseIdentifier;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.query.spi.QueryParserService;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public abstract class RemoteNeo4jDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
Configurable,
ServiceRegistryAwareService {
    private static final Log logger = LoggerFactory.getLogger();
    private static final int DEFAULT_SEQUENCE_QUERY_CACHE_MAX_SIZE = 128;
    protected RemoteNeo4jConfiguration configuration;
    private final int defaultPort;
    private final String protocol;
    private Integer sequenceCacheMaxSize;

    protected RemoteNeo4jDatastoreProvider(String protocol, int defaultPort) {
        this.protocol = protocol;
        this.defaultPort = defaultPort;
    }

    public abstract Object getSequenceGenerator();

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
    }

    public Class<? extends QueryParserService> getDefaultQueryParserServiceType() {
        return Neo4jBasedQueryParserService.class;
    }

    public void configure(Map configurationValues) {
        this.configuration = new RemoteNeo4jConfiguration(new ConfigurationPropertyReader(configurationValues), this.defaultPort);
        this.sequenceCacheMaxSize = (Integer)new ConfigurationPropertyReader(configurationValues).property("hibernate.ogm.neo4j.sequence_query_cache_max_size", Integer.TYPE).withDefault((Object)128).getValue();
    }

    public boolean allowsTransactionEmulation() {
        return false;
    }

    protected RemoteNeo4jDatabaseIdentifier getDatabaseIdentifier() {
        if (!this.configuration.getHosts().isSingleHost()) {
            logger.doesNotSupportMultipleHosts(this.configuration.getHosts().toString());
        }
        Hosts.HostAndPort hostAndPort = this.configuration.getHosts().getFirst();
        try {
            return new RemoteNeo4jDatabaseIdentifier(this.protocol, this.configuration);
        }
        catch (Exception e) {
            throw logger.malformedDataBaseUrl(e, hostAndPort.getHost(), hostAndPort.getPort(), this.configuration.getDatabaseName());
        }
    }

    public Integer getSequenceCacheMaxSize() {
        return this.sequenceCacheMaxSize;
    }
}

