/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.BaseNeo4jEntityQueries;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.remote.common.dialect.impl.RemoteNeo4jAssociationPropertiesRow;
import org.hibernate.ogm.datastore.neo4j.remote.common.util.impl.RemoteNeo4jHelper;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.NodeWithEmbeddedNodes;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.ErrorResponse;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Graph;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Row;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Statement;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.StatementResult;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Statements;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.StatementsResponse;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.util.impl.ArrayHelper;

public class HttpNeo4jEntityQueries
extends BaseNeo4jEntityQueries {
    private static final ClosableIteratorAdapter<RemoteNeo4jAssociationPropertiesRow> EMPTY_RELATIONSHIPS = new ClosableIteratorAdapter(Collections.emptyList().iterator());
    private static final ClosableIteratorAdapter<NodeWithEmbeddedNodes> EMPTY_NODES = new ClosableIteratorAdapter(Collections.emptyList().iterator());

    public HttpNeo4jEntityQueries(EntityKeyMetadata entityKeyMetadata) {
        this(entityKeyMetadata, null);
    }

    public HttpNeo4jEntityQueries(EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext) {
        super(entityKeyMetadata, tupleTypeContext, true);
    }

    public NodeWithEmbeddedNodes findEntity(HttpNeo4jClient executionEngine, Long transactionId, Object[] columnValues) {
        Map<String, Object> params = this.params(columnValues);
        Statements statements = new Statements();
        statements.addStatement(this.getFindEntityQuery(), params, "graph");
        List<StatementResult> queryResult = this.executeQuery(executionEngine, transactionId, statements);
        if (queryResult != null) {
            Graph.Node owner = this.findOwner(queryResult);
            HashMap<String, Collection<Graph.Node>> embeddedNodesMap = new HashMap<String, Collection<Graph.Node>>();
            List<Row> rows = queryResult.get(0).getData();
            for (Row row : rows) {
                Graph graph = row.getGraph();
                if (graph.getNodes().size() <= 0) continue;
                this.updateEmbeddedNodesMap(embeddedNodesMap, graph.getNodes(), graph.getRelationships(), owner);
            }
            return new NodeWithEmbeddedNodes(owner, embeddedNodesMap);
        }
        return null;
    }

    private Graph.Node findOwner(List<StatementResult> queryResult) {
        Graph graph = queryResult.get(0).getData().get(0).getGraph();
        Graph.Node owner = this.findEntity(graph.getNodes());
        return owner;
    }

    private Graph.Node findEntity(List<Graph.Node> nodes) {
        for (Graph.Node node : nodes) {
            if (!node.getLabels().contains(NodeLabel.ENTITY.name())) continue;
            return node;
        }
        return null;
    }

    private void updateEmbeddedNodesMap(Map<String, Collection<Graph.Node>> embeddedNodesMap, List<Graph.Node> allNodes, List<Graph.Relationship> embeddedRelationships, Graph.Node owner) {
        Graph.Relationship currentRelationship;
        if (embeddedRelationships.size() > 0 && (currentRelationship = this.findRelationship(embeddedRelationships, owner.getId())) != null) {
            StringBuilder builder = new StringBuilder();
            Graph.Node currentNode = null;
            while (currentRelationship != null) {
                builder.append(".");
                builder.append(currentRelationship.getType());
                currentNode = this.findEmbeddedNode(allNodes, currentRelationship.getEndNode());
                currentRelationship = this.findRelationship(embeddedRelationships, currentRelationship.getEndNode());
            }
            String path = builder.substring(1);
            this.saveEmbeddedNode(embeddedNodesMap, path, currentNode);
        }
    }

    private Graph.Relationship findRelationship(List<Graph.Relationship> relationships, Long startNodeId) {
        for (Graph.Relationship relationship : relationships) {
            if (!relationship.getStartNode().equals(startNodeId)) continue;
            return relationship;
        }
        return null;
    }

    private void saveEmbeddedNode(Map<String, Collection<Graph.Node>> embeddedNodesMap, String path, Graph.Node embeddedNode) {
        if (!embeddedNode.getProperties().isEmpty()) {
            if (embeddedNodesMap.containsKey(path)) {
                embeddedNodesMap.get(path).add(embeddedNode);
            } else {
                HashSet<Graph.Node> embeddedNodes = new HashSet<Graph.Node>();
                embeddedNodes.add(embeddedNode);
                embeddedNodesMap.put(path, embeddedNodes);
            }
        }
    }

    private Graph.Node findEmbeddedNode(List<Graph.Node> allNodes, Long embeddedNodeId) {
        for (Graph.Node node : allNodes) {
            if (!node.getId().equals(embeddedNodeId)) continue;
            return node;
        }
        return null;
    }

    public Graph.Node findAssociatedEntity(HttpNeo4jClient neo4jClient, Long txId, Object[] keyValues, String associationrole) {
        Graph result;
        Map<String, Object> params = this.params(keyValues);
        String query = this.getFindAssociatedEntityQuery(associationrole);
        if (query != null && (result = this.executeQueryAndReturnGraph(neo4jClient, txId, query, params, new String[0])) != null && result.getNodes().size() > 0) {
            return result.getNodes().get(0);
        }
        return null;
    }

    public Statement getCreateEntityWithPropertiesQueryStatement(Object[] columnValues, Map<String, Object> properties) {
        String query = this.getCreateEntityWithPropertiesQuery();
        Map<String, Object> params = Collections.singletonMap("props", properties);
        return new Statement(query, params);
    }

    public Statement removeColumnStatement(Object[] columnValues, String column) {
        String query = this.getRemoveColumnQuery(column);
        Map<String, Object> params = this.params(columnValues);
        return new Statement(query, params);
    }

    public Statement getUpdateEntityPropertiesStatement(Object[] columnvalues, Map<String, Object> properties) {
        String query = this.getUpdateEntityPropertiesQuery(properties);
        Object[] paramsValues = ArrayHelper.concat(Arrays.asList(columnvalues, new Object[properties.size()]));
        int index = columnvalues.length;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            paramsValues[index++] = entry.getValue();
        }
        return new Statement(query, this.params(paramsValues));
    }

    public void removeEntity(HttpNeo4jClient executionEngine, Long txId, Object[] columnValues) {
        this.executeQueryAndReturnGraph(executionEngine, txId, this.getRemoveEntityQuery(), this.params(columnValues), new String[0]);
    }

    public ClosableIterator<NodeWithEmbeddedNodes> findEntitiesWithEmbedded(HttpNeo4jClient executionEngine, Long txId) {
        Statements statements = new Statements();
        statements.addStatement(this.getFindEntitiesQuery());
        List<StatementResult> result = this.executeQuery(executionEngine, txId, statements);
        return this.closableIterator(result);
    }

    public ClosableIterator<NodeWithEmbeddedNodes> findEntities(HttpNeo4jClient executionEngine, EntityKey[] keys, Long txId) {
        if (this.singlePropertyKey) {
            return this.singlePropertyIdFindEntities(executionEngine, keys, txId);
        }
        return this.multiPropertiesIdFindEntities(executionEngine, keys, txId);
    }

    private ClosableIterator<NodeWithEmbeddedNodes> multiPropertiesIdFindEntities(HttpNeo4jClient executionEngine, EntityKey[] keys, Long txId) {
        String query = this.getMultiGetQueryCacheQuery(keys);
        Map<String, Object> params = this.multiGetParams(keys);
        List<StatementResult> results = this.executeQuery(executionEngine, txId, query, params, new String[0]);
        return this.closableIterator(results);
    }

    private ClosableIterator<NodeWithEmbeddedNodes> singlePropertyIdFindEntities(HttpNeo4jClient executionEngine, EntityKey[] keys, Long txId) {
        Object[] paramsValues = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            paramsValues[i] = keys[i].getColumnValues()[0];
        }
        Map<String, Object[]> params = Collections.singletonMap("0", paramsValues);
        Statements statements = new Statements();
        statements.addStatement(this.multiGetQuery, params, "graph");
        List<StatementResult> results = this.executeQuery(executionEngine, txId, statements);
        return this.closableIterator(results, keys);
    }

    private ClosableIterator<NodeWithEmbeddedNodes> closableIterator(List<StatementResult> results) {
        return this.closableIterator(results, null);
    }

    private ClosableIterator<NodeWithEmbeddedNodes> closableIterator(List<StatementResult> results, EntityKey[] keys) {
        List<Row> data;
        if (results != null && (data = results.get(0).getData()).size() > 0) {
            ArrayList<Graph.Node> owners = new ArrayList<Graph.Node>();
            HashMap<Long, HashMap<String, Collection<Graph.Node>>> nodes = new HashMap<Long, HashMap<String, Collection<Graph.Node>>>();
            for (Row row : data) {
                if (row.getGraph().getNodes().size() <= 0) continue;
                Graph.Node owner = this.findEntity(row.getGraph().getNodes());
                HashMap<String, Collection<Graph.Node>> embeddedNodesMap = (HashMap<String, Collection<Graph.Node>>)nodes.get(owner.getId());
                if (embeddedNodesMap == null) {
                    embeddedNodesMap = new HashMap<String, Collection<Graph.Node>>();
                    nodes.put(owner.getId(), embeddedNodesMap);
                    owners.add(owner);
                }
                this.updateEmbeddedNodesMap(embeddedNodesMap, row.getGraph().getNodes(), row.getGraph().getRelationships(), owner);
            }
            if (keys == null) {
                ArrayList<NodeWithEmbeddedNodes> nodeWithEmbeddeds = new ArrayList<NodeWithEmbeddedNodes>();
                for (Graph.Node owner : owners) {
                    nodeWithEmbeddeds.add(new NodeWithEmbeddedNodes(owner, (Map)nodes.get(owner.getId())));
                }
                return new ClosableIteratorAdapter<NodeWithEmbeddedNodes>(nodeWithEmbeddeds.iterator());
            }
            NodeWithEmbeddedNodes[] array = new NodeWithEmbeddedNodes[keys.length];
            for (Graph.Node owner : owners) {
                int index = this.findKeyIndex(keys, owner);
                if (index <= -1) continue;
                array[index] = new NodeWithEmbeddedNodes(owner, (Map)nodes.get(owner.getId()));
            }
            ArrayList<NodeWithEmbeddedNodes> arrayList = new ArrayList<NodeWithEmbeddedNodes>();
            for (NodeWithEmbeddedNodes node : array) {
                if (node == null) continue;
                arrayList.add(node);
            }
            return new ClosableIteratorAdapter<NodeWithEmbeddedNodes>(arrayList.iterator());
        }
        return EMPTY_NODES;
    }

    private int findKeyIndex(EntityKey[] keys, Graph.Node owner) {
        for (int i = 0; i < keys.length; ++i) {
            if (!RemoteNeo4jHelper.matches(owner.getProperties(), keys[i].getColumnNames(), keys[i].getColumnValues())) continue;
            return i;
        }
        return -1;
    }

    public Statement getUpdateOneToOneAssociationStatement(String associationRole, Object[] ownerKeyValues, Object[] targetKeyValues) {
        String query = this.getUpdateToOneQuery(associationRole);
        Map<String, Object> params = this.params(ownerKeyValues);
        params.putAll(this.params(targetKeyValues, ownerKeyValues.length));
        return new Statement(query, params);
    }

    private Graph executeQueryAndReturnGraph(HttpNeo4jClient executionEngine, Long txId, String query, Map<String, Object> properties, String ... dataContents) {
        List<StatementResult> results = this.executeQuery(executionEngine, txId, query, properties, dataContents);
        if (results == null) {
            return null;
        }
        return HttpNeo4jEntityQueries.row(results).getGraph();
    }

    private List<StatementResult> executeQuery(HttpNeo4jClient executionEngine, Long txId, String query, Map<String, Object> properties, String ... dataContents) {
        Statements statements = new Statements();
        statements.addStatement(query, properties, dataContents);
        return this.executeQuery(executionEngine, txId, statements);
    }

    private List<StatementResult> executeQuery(HttpNeo4jClient executionEngine, Long txId, Statements statements) {
        StatementsResponse statementsResponse = txId == null ? executionEngine.executeQueriesInNewTransaction(statements) : executionEngine.executeQueriesInOpenTransaction(txId, statements);
        this.validate(statementsResponse);
        List<StatementResult> results = statementsResponse.getResults();
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.get(0).getData().isEmpty()) {
            return null;
        }
        return results;
    }

    private static Row row(List<StatementResult> results) {
        Row row = results.get(0).getData().get(0);
        return row;
    }

    private void validate(StatementsResponse statementsResponse) {
        if (!statementsResponse.getErrors().isEmpty()) {
            ErrorResponse errorResponse = statementsResponse.getErrors().get(0);
            throw new HibernateException(String.valueOf(errorResponse));
        }
    }

    public Statement updateEmbeddedColumnStatement(Object[] keyValues, String column, Object value) {
        String query = this.getUpdateEmbeddedColumnQuery(keyValues, column);
        Map<String, Object> params = this.params(ArrayHelper.concat((Object[])keyValues, (Object[])new Object[]{value, value}));
        return new Statement(query, params);
    }

    public Statement removeEmbeddedColumnStatement(Object[] keyValues, String embeddedColumn) {
        String query = this.getRemoveEmbeddedPropertyQuery().get(embeddedColumn);
        Map<String, Object> params = this.params(keyValues);
        return new Statement(query, params);
    }

    public Statement removeEmptyEmbeddedNodesStatement(Object[] keyValues, String embeddedColumn) {
        String query = this.getRemoveEmbeddedPropertyQuery().get(embeddedColumn);
        Map<String, Object> params = this.params(keyValues);
        return new Statement(query, params);
    }

    public ClosableIterator<RemoteNeo4jAssociationPropertiesRow> findAssociation(HttpNeo4jClient executionEngine, Long txId, Object[] columnValues, String role, AssociationKeyMetadata associationKeyMetadata) {
        String queryForAssociation = this.getFindAssociationQuery(role, associationKeyMetadata);
        String queryForEmbedded = this.getFindAssociationTargetEmbeddedValues(role, associationKeyMetadata);
        Map<String, Object> params = this.params(columnValues);
        Statements statements = new Statements();
        statements.addStatement(queryForAssociation, params, "row");
        statements.addStatement(queryForEmbedded, params, "row");
        List<StatementResult> response = this.executeQuery(executionEngine, txId, statements);
        if (response != null) {
            List<Row> data = response.get(0).getData();
            List<Row> embeddedNodes = response.get(1).getData();
            int embeddedNodesIndex = 0;
            ArrayList<RemoteNeo4jAssociationPropertiesRow> responseRows = new ArrayList<RemoteNeo4jAssociationPropertiesRow>(data.size());
            for (int i = 0; i < data.size(); ++i) {
                Row row;
                String embeddedOwnerId;
                String idTarget = String.valueOf(data.get(i).getRow().get(0));
                Map rel = (Map)data.get(i).getRow().get(1);
                Map ownerNode = (Map)data.get(i).getRow().get(2);
                Map targetNode = (Map)data.get(i).getRow().get(3);
                while (embeddedNodesIndex < embeddedNodes.size() && (embeddedOwnerId = (row = embeddedNodes.get(embeddedNodesIndex)).getRow().get(0).toString()).equals(idTarget)) {
                    this.addTargetEmbeddedProperties(targetNode, row);
                    ++embeddedNodesIndex;
                }
                RemoteNeo4jAssociationPropertiesRow associationPropertiesRow = new RemoteNeo4jAssociationPropertiesRow(rel, ownerNode, targetNode);
                responseRows.add(associationPropertiesRow);
            }
            if (responseRows.isEmpty()) {
                return EMPTY_RELATIONSHIPS;
            }
            return new ClosableIteratorAdapter<RemoteNeo4jAssociationPropertiesRow>(responseRows.iterator());
        }
        return EMPTY_RELATIONSHIPS;
    }

    private void addTargetEmbeddedProperties(Map<String, Object> targetNode, Row row) {
        List pathToNode = (List)row.getRow().get(1);
        if (pathToNode != null) {
            Map embeddedNodeProperties = (Map)row.getRow().get(3);
            String path = this.concat(pathToNode);
            for (Map.Entry entry : embeddedNodeProperties.entrySet()) {
                targetNode.put(path + "." + (String)entry.getKey(), entry.getValue());
            }
        }
    }

    private String concat(List<String> pathToNode) {
        StringBuilder path = new StringBuilder();
        for (String entry : pathToNode) {
            path.append(".");
            path.append(entry);
        }
        return path.substring(1);
    }

    public Graph.Node findEmbeddedNode(HttpNeo4jClient neo4jClient, Long txId, Object[] keyValues, String embeddedPath) {
        Graph result = this.executeQueryAndReturnGraph(neo4jClient, txId, this.getFindEmbeddedNodeQueries().get(embeddedPath), this.params(keyValues), new String[0]);
        if (result == null) {
            return null;
        }
        return result.getNodes().get(0);
    }

    public void removeToOneAssociation(HttpNeo4jClient executionEngine, Long txId, Object[] columnValues, String associationRole) {
        Map<String, Object> params = this.params(ArrayHelper.concat((Object[])columnValues, (Object[])new Object[]{associationRole}));
        this.executeQueryAndReturnGraph(executionEngine, txId, this.getRemoveToOneAssociation(), params, new String[0]);
    }

    private static class ClosableIteratorAdapter<T>
    implements ClosableIterator<T> {
        private final Iterator<T> iterator;

        public ClosableIteratorAdapter(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public T next() {
            return this.iterator.next();
        }

        public void close() {
        }

        public void remove() {
        }
    }
}

