/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.ogm.datastore.neo4j.impl.BaseNeo4jSchemaDefiner;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.impl.BoltNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.util.Resource;

public class BoltNeo4jSchemaDefiner
extends BaseNeo4jSchemaDefiner {
    private static final Log log = LoggerFactory.getLogger();

    @Override
    protected void createSequences(List<Sequence> sequences, Set<IdSourceKeyMetadata> allIdSourceKeyMetadata, DatastoreProvider provider) {
        BoltNeo4jDatastoreProvider boltProvider = (BoltNeo4jDatastoreProvider)provider;
        BoltNeo4jSequenceGenerator sequenceGenerator = boltProvider.getSequenceGenerator();
        sequenceGenerator.createSequences(sequences, allIdSourceKeyMetadata);
    }

    @Override
    protected void createUniqueConstraintsIfMissing(DatastoreProvider provider, List<BaseNeo4jSchemaDefiner.UniqueConstraintDetails> constraints) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (BaseNeo4jSchemaDefiner.UniqueConstraintDetails constraint : constraints) {
            log.tracef("Creating unique constraint for nodes labeled as %1$s on property %2$s", constraint.getLabel(), constraint.getProperty());
            statements.add(new Statement(constraint.asCypherQuery()));
        }
        this.run(provider, statements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(DatastoreProvider provider, List<Statement> statements) {
        BoltNeo4jDatastoreProvider boltProvider = (BoltNeo4jDatastoreProvider)provider;
        Driver driver = boltProvider.getClient().getDriver();
        Session session = null;
        try {
            session = driver.session();
            Transaction tx = null;
            try {
                tx = session.beginTransaction();
                this.runAll(tx, statements);
                tx.success();
            }
            catch (ClientException e) {
                throw log.constraintsCreationException(e.code(), e.getMessage());
            }
            finally {
                this.close((Resource)tx);
            }
        }
        finally {
            this.close((Resource)session);
        }
    }

    private void runAll(Transaction tx, List<Statement> statements) {
        for (Statement statement : statements) {
            StatementResult result = tx.run(statement);
            this.validate(result);
        }
    }

    private void validate(StatementResult result) {
        result.hasNext();
    }

    private void close(Resource closable) {
        if (closable != null) {
            closable.close();
        }
    }
}

