/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.ogm.datastore.neo4j.BaseNeo4jDialect;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jAssociationQueries;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jAssociationSnapshot;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jBackendQueryResultIterator;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jEntityQueries;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jNodesTupleIterator;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jTupleAssociationSnapshot;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jTypeConverter;
import org.hibernate.ogm.datastore.neo4j.embedded.impl.EmbeddedNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.logging.impl.GraphLogger;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.QueryParameters;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.EntityMetadataInformation;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.util.impl.EmbeddedHelper;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;

public class EmbeddedNeo4jDialect
extends BaseNeo4jDialect<EmbeddedNeo4jEntityQueries, EmbeddedNeo4jAssociationQueries> {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final GraphDatabaseService dataBase;
    private final EmbeddedNeo4jSequenceGenerator sequenceGenerator;

    public EmbeddedNeo4jDialect(EmbeddedNeo4jDatastoreProvider provider) {
        super(EmbeddedNeo4jTypeConverter.INSTANCE);
        this.dataBase = provider.getDatabase();
        this.sequenceGenerator = provider.getSequenceGenerator();
    }

    @Override
    protected EmbeddedNeo4jAssociationQueries createNeo4jAssociationQueries(EntityKeyMetadata ownerEntityKeyMetadata, AssociationKeyMetadata associationKeyMetadata) {
        return new EmbeddedNeo4jAssociationQueries(ownerEntityKeyMetadata, associationKeyMetadata);
    }

    @Override
    protected EmbeddedNeo4jEntityQueries createNeo4jEntityQueries(EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext) {
        return new EmbeddedNeo4jEntityQueries(entityKeyMetadata, tupleTypeContext);
    }

    public Tuple getTuple(EntityKey key, OperationContext context) {
        Node entityNode = ((EmbeddedNeo4jEntityQueries)this.getEntityQueries(key.getMetadata(), context)).findEntity(this.dataBase, key.getColumnValues());
        if (entityNode == null) {
            return null;
        }
        return new Tuple((TupleSnapshot)EmbeddedNeo4jTupleSnapshot.fromNode(entityNode, context.getTupleTypeContext().getAllAssociatedEntityKeyMetadata(), context.getTupleTypeContext().getAllRoles(), key.getMetadata()), Tuple.SnapshotType.UPDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        EntityKeyMetadata metadata = keys[0].getMetadata();
        try (ResourceIterator<Node> nodes = ((EmbeddedNeo4jEntityQueries)this.getEntityQueries(metadata, tupleContext.getTupleTypeContext())).findEntities(this.dataBase, keys);){
            List<Tuple> list = this.tuplesResult(keys, tupleContext, nodes);
            return list;
        }
    }

    private List<Tuple> tuplesResult(EntityKey[] keys, TupleContext tupleContext, ResourceIterator<Node> nodes) {
        Tuple[] tuples = new Tuple[keys.length];
        block0: while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            for (int i = 0; i < keys.length; ++i) {
                if (!this.matches(node, keys[i].getColumnNames(), keys[i].getColumnValues())) continue;
                tuples[i] = new Tuple((TupleSnapshot)EmbeddedNeo4jTupleSnapshot.fromNode(node, tupleContext.getTupleTypeContext().getAllAssociatedEntityKeyMetadata(), tupleContext.getTupleTypeContext().getAllRoles(), keys[i].getMetadata()), Tuple.SnapshotType.UPDATE);
                continue block0;
            }
        }
        return Arrays.asList(tuples);
    }

    private boolean matches(Node node, String[] properties, Object[] values) {
        for (int i = 0; i < properties.length; ++i) {
            if (node.hasProperty(properties[i]) && !node.getProperty(properties[i]).equals(values[i])) {
                return false;
            }
            if (node.hasProperty(properties[i]) || values[i] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Tuple createTuple(EntityKey key, OperationContext tupleContext) {
        return new Tuple((TupleSnapshot)EmbeddedNeo4jTupleSnapshot.emptySnapshot(key.getMetadata()), Tuple.SnapshotType.INSERT);
    }

    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) {
        Tuple tuple = tuplePointer.getTuple();
        EmbeddedNeo4jTupleSnapshot snapshot = (EmbeddedNeo4jTupleSnapshot)tuple.getSnapshot();
        if (snapshot.isNew()) {
            Node node = this.insertTuple(key, tuple, tupleContext.getTupleTypeContext());
            snapshot.setNode(node);
            this.applyTupleOperations(key, tuple, node, tuple.getOperations(), tupleContext);
            GraphLogger.log("Inserted node: %1$s", node);
        } else {
            Node node = snapshot.getNode();
            this.applyTupleOperations(key, tuple, node, tuple.getOperations(), tupleContext);
            GraphLogger.log("Updated node: %1$s", node);
        }
    }

    private Node insertTuple(EntityKey key, Tuple tuple, TupleTypeContext tupleTypeContext) {
        try {
            return ((EmbeddedNeo4jEntityQueries)this.getEntityQueries(key.getMetadata(), tupleTypeContext)).insertEntity(this.dataBase, key.getColumnValues());
        }
        catch (QueryExecutionException qee) {
            Throwable cause;
            if ("Neo.ClientError.Schema.ConstraintValidationFailed".equals(qee.getStatusCode()) && (cause = this.findRecognizableCause(qee)) instanceof UniquePropertyValueValidationException) {
                throw new TupleAlreadyExistsException(key, (Throwable)qee);
            }
            throw qee;
        }
    }

    private Throwable findRecognizableCause(QueryExecutionException qee) {
        Throwable cause = qee.getCause();
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        ((EmbeddedNeo4jEntityQueries)this.getEntityQueries(key.getMetadata(), (OperationContext)tupleContext)).removeEntity(this.dataBase, key.getColumnValues());
    }

    private Relationship createRelationship(AssociationKey associationKey, Tuple associationRow, AssociatedEntityKeyMetadata associatedEntityKeyMetadata, AssociationContext associationContext) {
        switch (associationKey.getMetadata().getAssociationKind()) {
            case EMBEDDED_COLLECTION: {
                return this.createRelationshipWithEmbeddedNode(associationKey, associationRow, associatedEntityKeyMetadata);
            }
            case ASSOCIATION: {
                return this.findOrCreateRelationshipWithEntityNode(associationKey, associationRow, associatedEntityKeyMetadata, associationContext.getTupleTypeContext());
            }
        }
        throw new AssertionFailure("Unrecognized associationKind: " + associationKey.getMetadata().getAssociationKind());
    }

    private Relationship createRelationshipWithEmbeddedNode(AssociationKey associationKey, Tuple associationRow, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        EntityKey embeddedKey = this.getEntityKey(associationRow, associatedEntityKeyMetadata);
        Relationship relationship = ((EmbeddedNeo4jAssociationQueries)this.getAssociationQueries(associationKey.getMetadata())).createRelationshipForEmbeddedAssociation(this.dataBase, associationKey, embeddedKey);
        this.applyProperties(associationKey, associationRow, relationship);
        return relationship;
    }

    @Override
    protected EntityKeyMetadata entityKeyMetadata(EntityKeyMetadata keyMetadata, TupleTypeContext tupleTypeContext) {
        return keyMetadata;
    }

    private Relationship findOrCreateRelationshipWithEntityNode(AssociationKey associationKey, Tuple associationRow, AssociatedEntityKeyMetadata associatedEntityKeyMetadata, TupleTypeContext tupleTypeContext) {
        EntityKey targetEntityKey = this.getEntityKey(associationRow, associatedEntityKeyMetadata);
        Node targetNode = ((EmbeddedNeo4jEntityQueries)this.getEntityQueries(targetEntityKey.getMetadata(), (TupleTypeContext)null)).findEntity(this.dataBase, targetEntityKey.getColumnValues());
        return this.createRelationshipWithTargetNode(associationKey, associationRow, tupleTypeContext, targetNode);
    }

    private void applyProperties(AssociationKey associationKey, Tuple associationRow, Relationship relationship) {
        String[] indexColumns = associationKey.getMetadata().getRowKeyIndexColumnNames();
        for (int i = 0; i < indexColumns.length; ++i) {
            String propertyName = indexColumns[i];
            Object propertyValue = associationRow.get(propertyName);
            relationship.setProperty(propertyName, propertyValue);
        }
    }

    private Relationship createRelationshipWithTargetNode(AssociationKey associationKey, Tuple associationRow, TupleTypeContext tupleTypeContext, Node targetNode) {
        EntityKey entityKey = associationKey.getEntityKey();
        Node ownerNode = ((EmbeddedNeo4jEntityQueries)this.getEntityQueries(entityKey.getMetadata(), tupleTypeContext)).findEntity(this.dataBase, entityKey.getColumnValues());
        Relationship relationship = ownerNode.createRelationshipTo(targetNode, RelationshipType.withName((String)associationKey.getMetadata().getCollectionRole()));
        this.applyProperties(associationKey, associationRow, relationship);
        return relationship;
    }

    public Association getAssociation(AssociationKey associationKey, AssociationContext associationContext) {
        EntityKey entityKey = associationKey.getEntityKey();
        Node entityNode = ((EmbeddedNeo4jEntityQueries)this.getEntityQueries(entityKey.getMetadata(), (OperationContext)associationContext)).findEntity(this.dataBase, entityKey.getColumnValues());
        GraphLogger.log("Found owner node: %1$s", entityNode);
        if (entityNode == null) {
            return null;
        }
        Map<RowKey, Tuple> tuples = this.createAssociationMap(associationKey, associationContext, entityKey);
        return new Association((AssociationSnapshot)new EmbeddedNeo4jAssociationSnapshot(tuples));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<RowKey, Tuple> createAssociationMap(AssociationKey associationKey, AssociationContext associationContext, EntityKey entityKey) {
        String relationshipType = associationContext.getAssociationTypeContext().getRoleOnMainSide();
        HashMap<RowKey, Tuple> tuples = new HashMap<RowKey, Tuple>();
        try (ResourceIterator<Relationship> relationships = ((EmbeddedNeo4jEntityQueries)this.getEntityQueries(entityKey.getMetadata(), (OperationContext)associationContext)).findAssociation(this.dataBase, entityKey.getColumnValues(), relationshipType, associationKey.getMetadata());){
            while (relationships.hasNext()) {
                Relationship relationship = (Relationship)relationships.next();
                AssociatedEntityKeyMetadata associatedEntityKeyMetadata = associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata();
                EmbeddedNeo4jTupleAssociationSnapshot snapshot = new EmbeddedNeo4jTupleAssociationSnapshot(relationship, associationKey, associatedEntityKeyMetadata);
                RowKey rowKey = this.convert(associationKey, snapshot);
                tuples.put(rowKey, new Tuple((TupleSnapshot)snapshot, Tuple.SnapshotType.UPDATE));
            }
            HashMap<RowKey, Tuple> hashMap = tuples;
            return hashMap;
        }
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        if (key.getMetadata().isInverse()) {
            return;
        }
        for (AssociationOperation action : association.getOperations()) {
            this.applyAssociationOperation(association, key, action, associationContext);
        }
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (key.getMetadata().isInverse()) {
            return;
        }
        ((EmbeddedNeo4jAssociationQueries)this.getAssociationQueries(key.getMetadata())).removeAssociation(this.dataBase, key);
    }

    private void applyAssociationOperation(Association association, AssociationKey key, AssociationOperation operation, AssociationContext associationContext) {
        switch (operation.getType()) {
            case CLEAR: {
                this.removeAssociation(key, associationContext);
                break;
            }
            case PUT: {
                this.putAssociationOperation(association, key, operation, associationContext);
                break;
            }
            case REMOVE: {
                this.removeAssociationOperation(association, key, operation, associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata());
            }
        }
    }

    private void putAssociationOperation(Association association, AssociationKey associationKey, AssociationOperation action, AssociationContext associationContext) {
        AssociatedEntityKeyMetadata associatedEntityKeyMetadata = associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata();
        Relationship relationship = ((EmbeddedNeo4jAssociationQueries)this.getAssociationQueries(associationKey.getMetadata())).findRelationship(this.dataBase, associationKey, action.getKey());
        if (relationship != null) {
            for (String relationshipProperty : associationKey.getMetadata().getRowKeyIndexColumnNames()) {
                relationship.setProperty(relationshipProperty, action.getValue().get(relationshipProperty));
            }
            for (String column : associationKey.getMetadata().getColumnsWithoutKeyColumns((Iterable)action.getValue().getColumnNames())) {
                if (this.isRowKeyColumn(associationKey.getMetadata(), column)) continue;
                relationship.getEndNode().setProperty(column, action.getValue().get(column));
            }
            GraphLogger.log("Updated relationship: %1$s", relationship);
        } else {
            relationship = this.createRelationship(associationKey, action.getValue(), associatedEntityKeyMetadata, associationContext);
            GraphLogger.log("Created relationship: %1$s", relationship);
        }
    }

    private boolean isRowKeyColumn(AssociationKeyMetadata metadata, String column) {
        for (String rowKeyColumn : metadata.getRowKeyColumnNames()) {
            if (!rowKeyColumn.equals(column)) continue;
            return true;
        }
        return false;
    }

    private void removeAssociationOperation(Association association, AssociationKey associationKey, AssociationOperation action, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        ((EmbeddedNeo4jAssociationQueries)this.getAssociationQueries(associationKey.getMetadata())).removeAssociationRow(this.dataBase, associationKey, action.getKey());
    }

    private void applyTupleOperations(EntityKey entityKey, Tuple tuple, Node node, Set<TupleOperation> operations, TupleContext tupleContext) {
        HashSet<String> processedAssociationRoles = new HashSet<String>();
        for (TupleOperation operation : operations) {
            this.applyOperation(entityKey, tuple, node, operation, tupleContext, processedAssociationRoles);
        }
    }

    private void applyOperation(EntityKey entityKey, Tuple tuple, Node node, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        switch (operation.getType()) {
            case PUT: {
                this.putTupleOperation(entityKey, tuple, node, operation, tupleContext, processedAssociationRoles);
                break;
            }
            case PUT_NULL: 
            case REMOVE: {
                this.removeTupleOperation(entityKey, node, operation, tupleContext, processedAssociationRoles);
            }
        }
    }

    private void removeTupleOperation(EntityKey entityKey, Node node, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        if (!tupleContext.getTupleTypeContext().isPartOfAssociation(operation.getColumn())) {
            if (EmbeddedNeo4jDialect.isPartOfRegularEmbedded(entityKey.getColumnNames(), operation.getColumn())) {
                String[] split = EmbeddedHelper.split((String)operation.getColumn());
                this.removePropertyForEmbedded(node, split, 0);
            } else if (node.hasProperty(operation.getColumn())) {
                node.removeProperty(operation.getColumn());
            }
        } else {
            Iterator relationships;
            String associationRole = tupleContext.getTupleTypeContext().getRole(operation.getColumn());
            if (!processedAssociationRoles.contains(associationRole) && (relationships = node.getRelationships(new RelationshipType[]{RelationshipType.withName((String)associationRole)}).iterator()).hasNext()) {
                ((Relationship)relationships.next()).delete();
            }
        }
    }

    private void removePropertyForEmbedded(Node embeddedNode, String[] embeddedColumnSplit, int i) {
        Iterator iterator;
        if (i == embeddedColumnSplit.length - 1) {
            String property = embeddedColumnSplit[embeddedColumnSplit.length - 1];
            if (embeddedNode.hasProperty(property)) {
                embeddedNode.removeProperty(property);
            }
        } else {
            iterator = embeddedNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{RelationshipType.withName((String)embeddedColumnSplit[i])}).iterator();
            if (iterator.hasNext()) {
                this.removePropertyForEmbedded(((Relationship)iterator.next()).getEndNode(), embeddedColumnSplit, i + 1);
            }
        }
        if (!embeddedNode.getPropertyKeys().iterator().hasNext() && (iterator = embeddedNode.getRelationships().iterator()).hasNext()) {
            Relationship relationship = (Relationship)iterator.next();
            if (!iterator.hasNext()) {
                relationship.delete();
                embeddedNode.delete();
            }
        }
    }

    private void putTupleOperation(EntityKey entityKey, Tuple tuple, Node node, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        if (tupleContext.getTupleTypeContext().isPartOfAssociation(operation.getColumn())) {
            this.putOneToOneAssociation(tuple, node, operation, tupleContext, processedAssociationRoles);
        } else if (EmbeddedNeo4jDialect.isPartOfRegularEmbedded(entityKey.getMetadata().getColumnNames(), operation.getColumn())) {
            ((EmbeddedNeo4jEntityQueries)this.getEntityQueries(entityKey.getMetadata(), (OperationContext)tupleContext)).updateEmbeddedColumn(this.dataBase, entityKey.getColumnValues(), operation.getColumn(), operation.getValue());
        } else {
            this.putProperty(entityKey, node, operation);
        }
    }

    private void putProperty(EntityKey entityKey, Node node, TupleOperation operation) {
        try {
            node.setProperty(operation.getColumn(), operation.getValue());
        }
        catch (ConstraintViolationException e) {
            String message = e.getMessage();
            if (message.contains("already exists")) {
                throw log.mustNotInsertSameEntityTwice(String.valueOf(operation), (Exception)((Object)e));
            }
            throw log.constraintViolation(entityKey, String.valueOf(operation), (Exception)((Object)e));
        }
    }

    private void putOneToOneAssociation(Tuple tuple, Node node, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        String associationRole = tupleContext.getTupleTypeContext().getRole(operation.getColumn());
        if (!processedAssociationRoles.contains(associationRole)) {
            processedAssociationRoles.add(associationRole);
            EntityKey targetKey = this.getEntityKey(tuple, tupleContext.getTupleTypeContext().getAssociatedEntityKeyMetadata(operation.getColumn()));
            Iterator relationships = node.getRelationships(new RelationshipType[]{RelationshipType.withName((String)associationRole)}).iterator();
            if (relationships.hasNext()) {
                ((Relationship)relationships.next()).delete();
            }
            Node targetNode = ((EmbeddedNeo4jEntityQueries)this.getEntityQueries(targetKey.getMetadata(), (OperationContext)tupleContext)).findEntity(this.dataBase, targetKey.getColumnValues());
            node.createRelationshipTo(targetNode, RelationshipType.withName((String)associationRole));
        }
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        ResourceIterator<Node> queryNodes = ((EmbeddedNeo4jEntityQueries)this.getEntityQueries(entityKeyMetadata, tupleTypeContext)).findEntities(this.dataBase);
        consumer.consume((TuplesSupplier)new EmbeddedNeo4jTuplesSupplier(queryNodes, tupleTypeContext, entityKeyMetadata));
    }

    public Number nextValue(NextValueRequest request) {
        return this.sequenceGenerator.nextValue(request);
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<String> backendQuery, QueryParameters queryParameters, TupleContext tupleContext) {
        Map<String, Object> parameters = this.getParameters(queryParameters);
        String nativeQuery = this.buildNativeQuery(backendQuery, queryParameters);
        try {
            Result result = this.dataBase.execute(nativeQuery, parameters);
            EntityMetadataInformation entityMetadataInformation = backendQuery.getSingleEntityMetadataInformationOrNull();
            return new EmbeddedNeo4jBackendQueryResultIterator(result, entityMetadataInformation, tupleContext);
        }
        catch (QueryExecutionException qe) {
            throw log.nativeQueryException(qe.getStatusCode(), qe.getMessage(), (Exception)((Object)qe));
        }
    }

    @Override
    public int executeBackendUpdateQuery(BackendQuery<String> backendQuery, QueryParameters queryParameters, TupleContext tupleContext) {
        Map<String, Object> parameters = this.getParameters(queryParameters);
        String nativeQuery = this.buildNativeQuery(backendQuery, queryParameters);
        try {
            Result result = this.dataBase.execute(nativeQuery, parameters);
            return this.summaryUpdates(result);
        }
        catch (QueryExecutionException qe) {
            throw log.nativeQueryException(qe.getStatusCode(), qe.getMessage(), (Exception)((Object)qe));
        }
    }

    private int summaryUpdates(Result result) {
        int updates = 0;
        updates += result.getQueryStatistics().getConstraintsAdded();
        updates += result.getQueryStatistics().getConstraintsRemoved();
        updates += result.getQueryStatistics().getNodesCreated();
        updates += result.getQueryStatistics().getNodesDeleted();
        updates += result.getQueryStatistics().getRelationshipsCreated();
        updates += result.getQueryStatistics().getRelationshipsDeleted();
        updates += result.getQueryStatistics().getLabelsAdded();
        updates += result.getQueryStatistics().getLabelsRemoved();
        return updates += result.getQueryStatistics().getPropertiesSet();
    }

    @Override
    public String parseNativeQuery(String nativeQuery) {
        return nativeQuery;
    }

    private static class EmbeddedNeo4jTuplesSupplier
    implements TuplesSupplier {
        private final ResourceIterator<Node> nodes;
        private final TupleTypeContext tupleTypeContext;
        private final EntityKeyMetadata entityKeyMetadata;

        public EmbeddedNeo4jTuplesSupplier(ResourceIterator<Node> nodes, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
            this.nodes = nodes;
            this.tupleTypeContext = tupleTypeContext;
            this.entityKeyMetadata = entityKeyMetadata;
        }

        public ClosableIterator<Tuple> get(TransactionContext transactionContext) {
            return new EmbeddedNeo4jNodesTupleIterator(this.nodes, this.entityKeyMetadata, this.tupleTypeContext);
        }
    }
}

