/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.BaseNeo4jQueries;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKind;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.util.impl.EmbeddedHelper;

public abstract class BaseNeo4jEntityQueries
extends BaseNeo4jQueries {
    public static final String ENTITY_ALIAS = "owner";
    public static final String FIRST_EMBEDDED_ALIAS = "emb";
    public static final String EMBEDDED_ALIAS = "emb_2";
    public static final String FIRST_EMBEDDED_REL_ALIAS = "r";
    public static final String EMBEDDED_REL_ALIAS = "r2";
    private static final int CACHE_CAPACITY = 1000;
    private static final int CACHE_CONCURRENCY_LEVEL = 20;
    protected final boolean singlePropertyKey;
    protected final String[] keyColumns;
    protected final String multiGetQuery;
    private final Map<String, String> findEmbeddedNodeQueries;
    private final Map<String, String> removeEmbeddedPropertyQuery;
    private final Map<String, String> removePropertyQueries;
    private final BoundedConcurrentHashMap<String, String> updateEmbeddedPropertyQueryCache;
    private final BoundedConcurrentHashMap<String, String> findAssociationQueryCache;
    private final BoundedConcurrentHashMap<Integer, String> multiGetQueryCache;
    private final String removeToOneAssociation;
    private final String createEmbeddedNodeQuery;
    private final String findEntityQuery;
    private final String findEntityWithEmbeddedEndNodeQuery;
    private final String findEntitiesQuery;
    private final String findAssociationPartialQuery;
    private final String createEntityQuery;
    private final String createEntityWithPropertiesQuery;
    private final String updateEntityProperties;
    private final String removeEntityQuery;
    private final String updateEmbeddedNodeQuery;
    private final Map<String, String> updateToOneQuery;
    private final Map<String, String> findAssociatedEntityQuery;
    private final boolean includeEmbedded;
    private final EntityKeyMetadata entityKeyMetadata;

    public BaseNeo4jEntityQueries(EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext, boolean includeEmbedded) {
        this.entityKeyMetadata = entityKeyMetadata;
        this.includeEmbedded = includeEmbedded;
        this.updateEmbeddedPropertyQueryCache = new BoundedConcurrentHashMap(1000, 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.findAssociationQueryCache = new BoundedConcurrentHashMap(1000, 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.multiGetQueryCache = new BoundedConcurrentHashMap(1000, 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.findAssociationPartialQuery = BaseNeo4jEntityQueries.initMatchOwnerEntityNode(entityKeyMetadata);
        this.createEmbeddedNodeQuery = BaseNeo4jEntityQueries.initCreateEmbeddedNodeQuery(entityKeyMetadata);
        this.findEntityQuery = BaseNeo4jEntityQueries.initFindEntityQuery(entityKeyMetadata, includeEmbedded);
        this.findEntityWithEmbeddedEndNodeQuery = BaseNeo4jEntityQueries.initFindEntityQueryWithEmbeddedEndNode(entityKeyMetadata);
        this.findEntitiesQuery = BaseNeo4jEntityQueries.initFindEntitiesQuery(entityKeyMetadata, includeEmbedded);
        this.createEntityQuery = BaseNeo4jEntityQueries.initCreateEntityQuery(entityKeyMetadata);
        this.updateEntityProperties = BaseNeo4jEntityQueries.initMatchOwnerEntityNode(entityKeyMetadata);
        this.createEntityWithPropertiesQuery = BaseNeo4jEntityQueries.initCreateEntityWithPropertiesQuery(entityKeyMetadata);
        this.removeEntityQuery = BaseNeo4jEntityQueries.initRemoveEntityQuery(entityKeyMetadata);
        this.updateEmbeddedNodeQuery = BaseNeo4jEntityQueries.initUpdateEmbeddedNodeQuery(entityKeyMetadata);
        this.updateToOneQuery = this.initUpdateToOneQuery(entityKeyMetadata, tupleTypeContext);
        this.findAssociatedEntityQuery = this.initFindAssociatedEntityQuery(entityKeyMetadata, tupleTypeContext);
        this.findEmbeddedNodeQueries = this.initFindEmbeddedNodeQuery(entityKeyMetadata, tupleTypeContext);
        this.multiGetQuery = BaseNeo4jEntityQueries.initMultiGetEntitiesQuery(entityKeyMetadata, includeEmbedded);
        this.removeEmbeddedPropertyQuery = this.initRemoveEmbeddedPropertyQuery(entityKeyMetadata, tupleTypeContext);
        this.removePropertyQueries = this.initRemovePropertyQueries(entityKeyMetadata, tupleTypeContext);
        this.removeToOneAssociation = this.initRemoveToOneAssociation(entityKeyMetadata, tupleTypeContext);
        this.singlePropertyKey = entityKeyMetadata.getColumnNames().length == 1;
        this.keyColumns = entityKeyMetadata.getColumnNames();
    }

    private String initRemoveToOneAssociation(EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext) {
        StringBuilder queryBuilder = new StringBuilder();
        BaseNeo4jEntityQueries.appendMatchOwnerEntityNode(queryBuilder, entityKeyMetadata);
        queryBuilder.append(" -[r]-> (:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(") WHERE type(r) = {");
        queryBuilder.append(entityKeyMetadata.getColumnNames().length);
        queryBuilder.append("} DELETE r");
        return queryBuilder.toString();
    }

    private Map<String, String> initRemovePropertyQueries(EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext) {
        if (tupleTypeContext == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> removeColumn = new HashMap<String, String>();
        for (String column : tupleTypeContext.getSelectableColumns()) {
            if (column.contains(".")) continue;
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("MATCH ");
            BaseNeo4jEntityQueries.appendEntityNode("n", entityKeyMetadata, queryBuilder);
            queryBuilder.append(" REMOVE n.");
            CypherDSL.escapeIdentifier(queryBuilder, column);
            removeColumn.put(column, queryBuilder.toString());
        }
        return Collections.unmodifiableMap(removeColumn);
    }

    private static String initMultiGetEntitiesQuery(EntityKeyMetadata entityKeyMetadata, boolean includeEmbedded) {
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(");
        queryBuilder.append(ENTITY_ALIAS);
        queryBuilder.append(":");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        BaseNeo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        queryBuilder.append(") ");
        queryBuilder.append(" WHERE ");
        if (entityKeyMetadata.getColumnNames().length == 1) {
            queryBuilder.append(ENTITY_ALIAS);
            queryBuilder.append(".");
            CypherDSL.escapeIdentifier(queryBuilder, entityKeyMetadata.getColumnNames()[0]);
            queryBuilder.append(" IN {0}");
            BaseNeo4jEntityQueries.appendGetEmbeddedNodesIfNeeded(includeEmbedded, queryBuilder);
        }
        return queryBuilder.toString();
    }

    private Map<String, String> initRemoveEmbeddedPropertyQuery(EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext) {
        if (tupleTypeContext == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> removeColumn = new HashMap<String, String>();
        for (String column : tupleTypeContext.getSelectableColumns()) {
            if (!EmbeddedHelper.isPartOfEmbedded((String)column) || removeColumn.containsKey(column)) continue;
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append("MATCH ");
            BaseNeo4jEntityQueries.appendEntityNode("n", entityKeyMetadata, queryBuilder);
            String[] path = EmbeddedHelper.split((String)column);
            for (int i = 0; i < path.length - 1; ++i) {
                queryBuilder.append("-[:");
                BaseNeo4jEntityQueries.appendRelationshipType(queryBuilder, path[i]);
                queryBuilder.append("]->");
                if (i == path.length - 2) {
                    queryBuilder.append("(e:EMBEDDED) ");
                    continue;
                }
                queryBuilder.append("(:EMBEDDED) ");
            }
            queryBuilder.append("REMOVE e.");
            CypherDSL.escapeIdentifier(queryBuilder, path[path.length - 1]);
            queryBuilder.append(" WITH e ");
            queryBuilder.append("MATCH (e)<-[erel]-(a) ");
            queryBuilder.append("WHERE length(keys(e))=0 AND NOT ((e)-->()) ");
            queryBuilder.append("DELETE e, erel ");
            queryBuilder.append("WITH a ");
            queryBuilder.append("OPTIONAL MATCH path=(a)<-[r*]-(b:EMBEDDED), (b)<-[brel]-(), (x) ");
            queryBuilder.append("WHERE a:EMBEDDED AND length(keys(a))=0 AND NOT((a)<-[*]-(:EMBEDDED)-->())  AND NOT ((a)<-[*]-(x)<-[*]-(b)) AND length(keys(b))>0 ");
            queryBuilder.append("FOREACH (r in relationships(path) | DELETE r) ");
            queryBuilder.append("FOREACH (n in nodes(path) | DELETE n) ");
            queryBuilder.append("WITH a ");
            queryBuilder.append("MATCH (a)<-[arel]-() ");
            queryBuilder.append("WHERE length(keys(a))=0 AND a:EMBEDDED ");
            queryBuilder.append("DELETE arel, a ");
            removeColumn.put(column, queryBuilder.toString());
        }
        return Collections.unmodifiableMap(removeColumn);
    }

    private Map<String, String> initUpdateToOneQuery(EntityKeyMetadata ownerEntityKeyMetadata, TupleTypeContext tupleTypeContext) {
        if (tupleTypeContext != null) {
            Map allAssociatedEntityKeyMetadata = tupleTypeContext.getAllAssociatedEntityKeyMetadata();
            HashMap<String, String> queries = new HashMap<String, String>(allAssociatedEntityKeyMetadata.size());
            for (Map.Entry entry : allAssociatedEntityKeyMetadata.entrySet()) {
                String associationRole = tupleTypeContext.getRole((String)entry.getKey());
                AssociatedEntityKeyMetadata associatedEntityKeyMetadata = (AssociatedEntityKeyMetadata)entry.getValue();
                EntityKeyMetadata targetKeyMetadata = associatedEntityKeyMetadata.getEntityKeyMetadata();
                StringBuilder queryBuilder = new StringBuilder("MATCH ");
                BaseNeo4jEntityQueries.appendEntityNode(ENTITY_ALIAS, ownerEntityKeyMetadata, queryBuilder);
                queryBuilder.append(", ");
                BaseNeo4jEntityQueries.appendEntityNode("target", targetKeyMetadata, queryBuilder, ownerEntityKeyMetadata.getColumnNames().length);
                queryBuilder.append(" OPTIONAL MATCH (");
                queryBuilder.append(ENTITY_ALIAS);
                queryBuilder.append(")");
                queryBuilder.append(" -[r:");
                BaseNeo4jEntityQueries.appendRelationshipType(queryBuilder, associationRole);
                queryBuilder.append("]-> () DELETE r ");
                queryBuilder.append("CREATE (");
                queryBuilder.append(ENTITY_ALIAS);
                queryBuilder.append(") -[:");
                BaseNeo4jEntityQueries.appendRelationshipType(queryBuilder, associationRole);
                queryBuilder.append("]-> (target)");
                queries.put(associationRole, queryBuilder.toString());
            }
            return queries;
        }
        return Collections.emptyMap();
    }

    private Map<String, String> initFindAssociatedEntityQuery(EntityKeyMetadata ownerEntityKeyMetadata, TupleTypeContext tupleTypeContext) {
        if (tupleTypeContext != null) {
            Map allAssociatedEntityKeyMetadata = tupleTypeContext.getAllAssociatedEntityKeyMetadata();
            HashMap<String, String> queries = new HashMap<String, String>(allAssociatedEntityKeyMetadata.size());
            for (Map.Entry entry : allAssociatedEntityKeyMetadata.entrySet()) {
                EntityKeyMetadata targetKeyMetadata = ((AssociatedEntityKeyMetadata)entry.getValue()).getEntityKeyMetadata();
                String associationRole = tupleTypeContext.getRole((String)entry.getKey());
                StringBuilder queryBuilder = new StringBuilder("MATCH ");
                BaseNeo4jEntityQueries.appendEntityNode(ENTITY_ALIAS, ownerEntityKeyMetadata, queryBuilder);
                queryBuilder.append(" -[r:");
                BaseNeo4jEntityQueries.appendRelationshipType(queryBuilder, associationRole);
                queryBuilder.append("]-> ");
                BaseNeo4jEntityQueries.appendEntityNode("target", targetKeyMetadata, queryBuilder, 0, false);
                queryBuilder.append(" RETURN target");
                queries.put(associationRole, queryBuilder.toString());
            }
            return queries;
        }
        return Collections.emptyMap();
    }

    private Map<String, String> initFindEmbeddedNodeQuery(EntityKeyMetadata ownerEntityKeyMetadata, TupleTypeContext tupleTypeContext) {
        if (tupleTypeContext != null) {
            HashMap<String, String> queries = new HashMap<String, String>();
            List selectableColumns = tupleTypeContext.getSelectableColumns();
            for (String column : selectableColumns) {
                if (!EmbeddedHelper.isPartOfEmbedded((String)column)) continue;
                String embeddedPath = column.substring(0, column.lastIndexOf("."));
                if (queries.containsKey(column)) continue;
                String[] columnPath = EmbeddedHelper.split((String)column);
                StringBuilder queryBuilder = new StringBuilder("MATCH ");
                BaseNeo4jEntityQueries.appendEntityNode(ENTITY_ALIAS, ownerEntityKeyMetadata, queryBuilder);
                for (int i = 0; i < columnPath.length - 1; ++i) {
                    queryBuilder.append(" -[:");
                    BaseNeo4jEntityQueries.appendRelationshipType(queryBuilder, columnPath[i]);
                    queryBuilder.append("]-> (");
                    if (i == columnPath.length - 2) {
                        queryBuilder.append("e");
                    }
                    queryBuilder.append(":");
                    queryBuilder.append((Object)NodeLabel.EMBEDDED);
                    queryBuilder.append(")");
                }
                queryBuilder.append(" RETURN e");
                queries.put(embeddedPath, queryBuilder.toString());
            }
            return Collections.unmodifiableMap(queries);
        }
        return Collections.emptyMap();
    }

    private static String initMatchOwnerEntityNode(EntityKeyMetadata ownerEntityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder();
        BaseNeo4jEntityQueries.appendMatchOwnerEntityNode(queryBuilder, ownerEntityKeyMetadata);
        return queryBuilder.toString();
    }

    private String completeFindAssociationQuery(String relationshipType, AssociationKeyMetadata associationKeyMetadata) {
        StringBuilder queryBuilder = this.findAssociationPartialQuery(relationshipType, associationKeyMetadata);
        queryBuilder.append("RETURN id(target), r, ");
        queryBuilder.append(ENTITY_ALIAS);
        queryBuilder.append(", target ORDER BY id(target) ");
        return queryBuilder.toString();
    }

    protected String getFindAssociationTargetEmbeddedValues(String relationshipType, AssociationKeyMetadata associationKeyMetadata) {
        StringBuilder queryBuilder = this.findAssociationPartialQuery(relationshipType, associationKeyMetadata);
        queryBuilder.append("OPTIONAL MATCH (target) -[x*1..]->(e:EMBEDDED) ");
        queryBuilder.append("RETURN id(target), extract(n IN x| type(n)), x, e ORDER BY id(target)");
        return queryBuilder.toString();
    }

    private StringBuilder findAssociationPartialQuery(String relationshipType, AssociationKeyMetadata associationKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder(this.findAssociationPartialQuery);
        if (EmbeddedHelper.isPartOfEmbedded((String)relationshipType)) {
            String[] path = EmbeddedHelper.split((String)relationshipType);
            int index = 0;
            for (String embeddedRelationshipType : path) {
                queryBuilder.append(" -[");
                if (index == path.length - 1) {
                    queryBuilder.append(FIRST_EMBEDDED_REL_ALIAS);
                }
                queryBuilder.append(":");
                BaseNeo4jEntityQueries.appendRelationshipType(queryBuilder, embeddedRelationshipType);
                queryBuilder.append("]-> (");
                if (++index == path.length) {
                    queryBuilder.append("target");
                }
                queryBuilder.append(":");
                queryBuilder.append((Object)NodeLabel.EMBEDDED);
                queryBuilder.append(") ");
            }
        } else {
            queryBuilder.append(associationKeyMetadata.isInverse() ? " <-[r:" : " -[r:");
            BaseNeo4jEntityQueries.appendRelationshipType(queryBuilder, relationshipType);
            queryBuilder.append(associationKeyMetadata.isInverse() ? "]- " : "]-> ");
            if (associationKeyMetadata.getAssociationKind() == AssociationKind.ASSOCIATION) {
                EntityKeyMetadata associatedEntityMetadata = associationKeyMetadata.getAssociatedEntityKeyMetadata().getEntityKeyMetadata();
                BaseNeo4jEntityQueries.appendEntityNode("target", associatedEntityMetadata, queryBuilder, 0, false);
            } else {
                queryBuilder.append("(target)");
            }
            queryBuilder.append(' ');
        }
        return queryBuilder;
    }

    private static String initCreateEmbeddedNodeQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("CREATE ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.EMBEDDED);
        queryBuilder.append(":");
        BaseNeo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        BaseNeo4jEntityQueries.appendProperties(entityKeyMetadata, queryBuilder);
        queryBuilder.append(") RETURN n");
        return queryBuilder.toString();
    }

    private static String initUpdateEmbeddedNodeQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MERGE ");
        BaseNeo4jEntityQueries.appendEntityNode(ENTITY_ALIAS, entityKeyMetadata, queryBuilder);
        queryBuilder.append(" MERGE (owner)");
        return queryBuilder.toString();
    }

    private static String initFindEntityQuery(EntityKeyMetadata entityKeyMetadata, boolean includeEmbedded) {
        StringBuilder queryBuilder = new StringBuilder();
        BaseNeo4jEntityQueries.appendMatchOwnerEntityNode(queryBuilder, entityKeyMetadata);
        BaseNeo4jEntityQueries.appendGetEmbeddedNodesIfNeeded(includeEmbedded, queryBuilder);
        return queryBuilder.toString();
    }

    private static String initFindEntityQueryWithEmbeddedEndNode(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder();
        BaseNeo4jEntityQueries.appendMatchOwnerEntityNode(queryBuilder, entityKeyMetadata);
        BaseNeo4jEntityQueries.appendGetEmbeddedNodesIfNeeded(true, queryBuilder);
        return queryBuilder.toString();
    }

    private static void appendGetEmbeddedNodesIfNeeded(boolean includeEmbedded, StringBuilder queryBuilder) {
        if (includeEmbedded) {
            BaseNeo4jEntityQueries.appendOptionalMatchOwnerEmbeddedNodes(queryBuilder);
            queryBuilder.append(" RETURN ");
            queryBuilder.append(ENTITY_ALIAS);
            queryBuilder.append(", ");
            queryBuilder.append(FIRST_EMBEDDED_REL_ALIAS);
            queryBuilder.append(", ");
            queryBuilder.append(FIRST_EMBEDDED_ALIAS);
            queryBuilder.append(", ");
            queryBuilder.append(EMBEDDED_REL_ALIAS);
            queryBuilder.append(", ");
            queryBuilder.append(EMBEDDED_ALIAS);
        } else {
            queryBuilder.append(" RETURN ");
            queryBuilder.append(ENTITY_ALIAS);
        }
    }

    private static void appendOptionalMatchOwnerEmbeddedNodes(StringBuilder queryBuilder) {
        queryBuilder.append(" OPTIONAL MATCH (");
        queryBuilder.append(ENTITY_ALIAS);
        queryBuilder.append(") -[");
        queryBuilder.append(FIRST_EMBEDDED_REL_ALIAS);
        queryBuilder.append("]->(");
        queryBuilder.append(FIRST_EMBEDDED_ALIAS);
        queryBuilder.append(":");
        queryBuilder.append((Object)NodeLabel.EMBEDDED);
        queryBuilder.append(")");
        queryBuilder.append(" OPTIONAL MATCH (");
        queryBuilder.append(FIRST_EMBEDDED_ALIAS);
        queryBuilder.append(")-[");
        queryBuilder.append(EMBEDDED_REL_ALIAS);
        queryBuilder.append("*]->(");
        queryBuilder.append(EMBEDDED_ALIAS);
        queryBuilder.append(":");
        queryBuilder.append((Object)NodeLabel.EMBEDDED);
        queryBuilder.append(")");
    }

    private static String initFindEntitiesQuery(EntityKeyMetadata entityKeyMetadata, boolean includeEmbedded) {
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(");
        queryBuilder.append(ENTITY_ALIAS);
        queryBuilder.append(":");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        BaseNeo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        queryBuilder.append(")");
        BaseNeo4jEntityQueries.appendOptionalMatchOwnerEmbeddedNodes(queryBuilder);
        BaseNeo4jEntityQueries.appendGetEmbeddedNodesIfNeeded(includeEmbedded, queryBuilder);
        return queryBuilder.toString();
    }

    private static String initCreateEntityQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("CREATE ");
        BaseNeo4jEntityQueries.appendEntityNode(ENTITY_ALIAS, entityKeyMetadata, queryBuilder);
        queryBuilder.append(" RETURN ");
        queryBuilder.append(ENTITY_ALIAS);
        return queryBuilder.toString();
    }

    private static String initCreateEntityWithPropertiesQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("CREATE ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        BaseNeo4jEntityQueries.appendLabel(entityKeyMetadata, queryBuilder);
        queryBuilder.append(" {props})");
        queryBuilder.append(" RETURN n");
        return queryBuilder.toString();
    }

    private static String initRemoveEntityQuery(EntityKeyMetadata entityKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        BaseNeo4jEntityQueries.appendEntityNode("n", entityKeyMetadata, queryBuilder);
        queryBuilder.append(" OPTIONAL MATCH (n)-[r]->(e:EMBEDDED), path=(e)-[*0..]->(:EMBEDDED) ");
        queryBuilder.append(" DELETE r ");
        queryBuilder.append(" FOREACH (er IN relationships(path) | DELETE er) ");
        queryBuilder.append(" FOREACH (en IN nodes(path) | DELETE en) ");
        queryBuilder.append(" WITH n ");
        queryBuilder.append(" OPTIONAL MATCH (n)-[r]-() ");
        queryBuilder.append(" DELETE r,n ");
        return queryBuilder.toString();
    }

    private String initUpdateEmbeddedColumnQuery(Object[] keyValues, String embeddedColumn) {
        StringBuilder queryBuilder = new StringBuilder(this.getUpdateEmbeddedNodeQuery());
        String[] columns = BaseNeo4jEntityQueries.appendEmbeddedNodes(embeddedColumn, queryBuilder);
        queryBuilder.append(" ON CREATE SET e.");
        CypherDSL.escapeIdentifier(queryBuilder, columns[columns.length - 1]);
        queryBuilder.append(" = {");
        queryBuilder.append(keyValues.length);
        queryBuilder.append("}");
        queryBuilder.append(" ON MATCH SET e.");
        CypherDSL.escapeIdentifier(queryBuilder, columns[columns.length - 1]);
        queryBuilder.append(" = {");
        queryBuilder.append(keyValues.length + 1);
        queryBuilder.append("}");
        return queryBuilder.toString();
    }

    private static String[] appendEmbeddedNodes(String path, StringBuilder queryBuilder) {
        String[] columns = EmbeddedHelper.split((String)path);
        for (int i = 0; i < columns.length - 1; ++i) {
            queryBuilder.append(" - [:");
            BaseNeo4jEntityQueries.appendRelationshipType(queryBuilder, columns[i]);
            queryBuilder.append("] ->");
            if (i >= columns.length - 2) continue;
            queryBuilder.append(" (e");
            queryBuilder.append(i);
            queryBuilder.append(":");
            queryBuilder.append((Object)NodeLabel.EMBEDDED);
            queryBuilder.append(") MERGE (e");
            queryBuilder.append(i);
            queryBuilder.append(")");
        }
        queryBuilder.append(" (e:");
        queryBuilder.append((Object)NodeLabel.EMBEDDED);
        queryBuilder.append(")");
        return columns;
    }

    public String getUpdateEmbeddedColumnQuery(Object[] keyValues, String embeddedColumn) {
        return (String)this.updateEmbeddedPropertyQueryCache.computeIfAbsent((Object)embeddedColumn, ec -> this.initUpdateEmbeddedColumnQuery(keyValues, (String)ec));
    }

    public String getFindAssociationQuery(String relationshipType, AssociationKeyMetadata associationKeyMetadata) {
        return (String)this.findAssociationQueryCache.computeIfAbsent((Object)associationKeyMetadata.getCollectionRole(), role -> this.completeFindAssociationQuery(relationshipType, associationKeyMetadata));
    }

    protected String getMultiGetQueryCacheQuery(EntityKey[] keys) {
        int numberOfKeys = keys.length;
        String query = (String)this.multiGetQueryCache.get((Object)numberOfKeys);
        if (query == null) {
            query = this.createMultiGetOnMultiplePropertiesId(numberOfKeys);
            String cached = (String)this.multiGetQueryCache.putIfAbsent((Object)numberOfKeys, (Object)query);
            if (cached != null) {
                query = cached;
            }
        }
        return query;
    }

    protected Map<String, Object> multiGetParams(EntityKey[] keys) {
        int numberOfColumnNames = keys[0].getColumnNames().length;
        int numberOfParams = keys.length * numberOfColumnNames;
        int counter = 0;
        HashMap<String, Object> params = new HashMap<String, Object>(numberOfParams);
        for (int row = 0; row < keys.length; ++row) {
            for (int col = 0; col < keys[row].getColumnValues().length; ++col) {
                params.put(String.valueOf(counter++), keys[row].getColumnValues()[col]);
            }
        }
        return params;
    }

    private String createMultiGetOnMultiplePropertiesId(int keysNumber) {
        StringBuilder builder = new StringBuilder(this.multiGetQuery);
        int counter = 0;
        for (int row = 0; row < keysNumber; ++row) {
            builder.append("(");
            for (int col = 0; col < this.keyColumns.length; ++col) {
                builder.append(ENTITY_ALIAS);
                builder.append(".");
                CypherDSL.escapeIdentifier(builder, this.keyColumns[col]);
                builder.append(" = {");
                builder.append(counter++);
                builder.append("}");
                if (col >= this.keyColumns.length - 1) continue;
                builder.append(" AND ");
            }
            builder.append(")");
            if (row >= keysNumber - 1) continue;
            builder.append(" OR ");
        }
        BaseNeo4jEntityQueries.appendGetEmbeddedNodesIfNeeded(this.includeEmbedded, builder);
        return builder.toString();
    }

    public String getUpdateEntityPropertiesQuery(Map<String, Object> properties) {
        StringBuilder queryBuilder = new StringBuilder(this.updateEntityProperties);
        queryBuilder.append(" SET ");
        int index = this.entityKeyMetadata.getColumnNames().length;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            queryBuilder.append(ENTITY_ALIAS);
            queryBuilder.append(".");
            CypherDSL.escapeIdentifier(queryBuilder, entry.getKey());
            queryBuilder.append(" = {");
            queryBuilder.append(index);
            queryBuilder.append("}, ");
            ++index;
        }
        return queryBuilder.substring(0, queryBuilder.length() - 2);
    }

    public String getCreateEmbeddedNodeQuery() {
        return this.createEmbeddedNodeQuery;
    }

    public String getFindEntityQuery() {
        return this.findEntityQuery;
    }

    public String getFindEntityWithEmbeddedEndNodeQuery() {
        return this.findEntityWithEmbeddedEndNodeQuery;
    }

    public String getFindEntitiesQuery() {
        return this.findEntitiesQuery;
    }

    public String getFindAssociationPartialQuery() {
        return this.findAssociationPartialQuery;
    }

    public String getCreateEntityQuery() {
        return this.createEntityQuery;
    }

    public String getCreateEntityWithPropertiesQuery() {
        return this.createEntityWithPropertiesQuery;
    }

    public String getRemoveEntityQuery() {
        return this.removeEntityQuery;
    }

    public String getUpdateEmbeddedNodeQuery() {
        return this.updateEmbeddedNodeQuery;
    }

    public String getUpdateToOneQuery(String associationRole) {
        return this.updateToOneQuery.get(associationRole);
    }

    public String getFindAssociatedEntityQuery(String associationRole) {
        return this.findAssociatedEntityQuery.get(associationRole);
    }

    public String getRemoveColumnQuery(String column) {
        return this.removePropertyQueries.get(column);
    }

    public Map<String, String> getFindEmbeddedNodeQueries() {
        return this.findEmbeddedNodeQueries;
    }

    public Map<String, String> getRemoveEmbeddedPropertyQuery() {
        return this.removeEmbeddedPropertyQuery;
    }

    public Map<String, String> getRemovePropertyQueries() {
        return this.removePropertyQueries;
    }

    public String getRemoveToOneAssociation() {
        return this.removeToOneAssociation;
    }

    public String getUpdateEntityProperties() {
        return this.updateEntityProperties;
    }

    public Map<String, String> getFindAssociatedEntityQuery() {
        return this.findAssociatedEntityQuery;
    }
}

