/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jTupleIterator;
import org.hibernate.ogm.datastore.neo4j.embedded.dialect.impl.EmbeddedNeo4jTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.EntityMetadataInformation;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;

public class EmbeddedNeo4jBackendQueryResultIterator
extends EmbeddedNeo4jTupleIterator<Map<String, Object>> {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final EntityKeyMetadata entityKeyMetadata;
    private final TupleTypeContext tupleTypeContext;

    public EmbeddedNeo4jBackendQueryResultIterator(Result result, EntityMetadataInformation info, TupleContext tupleContext) {
        super(result);
        this.entityKeyMetadata = info != null ? info.getEntityKeyMetadata() : null;
        this.tupleTypeContext = info != null ? tupleContext.getTupleTypeContext() : null;
    }

    @Override
    protected Tuple convert(Map<String, Object> next) {
        TupleSnapshot snapshot = this.createSnapshot(next);
        return new Tuple(snapshot, Tuple.SnapshotType.UPDATE);
    }

    private TupleSnapshot createSnapshot(Map<String, Object> next) {
        if (this.entityKeyMetadata == null) {
            return this.mapSnapshot(next);
        }
        Object value = next.values().iterator().next();
        if (value instanceof Node) {
            return this.nodeSnapshot((Node)value);
        }
        throw log.addEntityNotAllowedInNativeQueriesUsingProjection(this.entityKeyMetadata.getTable(), "");
    }

    private TupleSnapshot mapSnapshot(Map<String, Object> next) {
        MapTupleSnapshot snapshot = new MapTupleSnapshot(next);
        return snapshot;
    }

    private TupleSnapshot nodeSnapshot(Node node) {
        return EmbeddedNeo4jTupleSnapshot.fromNode(node, this.tupleTypeContext.getAllAssociatedEntityKeyMetadata(), this.tupleTypeContext.getAllRoles(), this.entityKeyMetadata);
    }
}

