/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.RemoteNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.impl.BoltNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.common.request.impl.RemoteStatement;
import org.hibernate.ogm.datastore.neo4j.remote.common.request.impl.RemoteStatements;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.util.Resource;

public class BoltNeo4jSequenceGenerator
extends RemoteNeo4jSequenceGenerator {
    private final BoltNeo4jClient client;

    public BoltNeo4jSequenceGenerator(BoltNeo4jClient client, int sequenceCacheMaxSize) {
        super(sequenceCacheMaxSize);
        this.client = client;
    }

    private void createSequencesConstraintsStatements(List<Statement> statements, Iterable<Sequence> sequences) {
        Statement statement = this.createUniqueConstraintStatement("sequence_name", NodeLabel.SEQUENCE.name());
        statements.add(statement);
    }

    public List<Statement> createSequencesStatements(Iterable<Sequence> sequences) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Sequence sequence : sequences) {
            this.addSequence(statements, sequence);
        }
        return statements;
    }

    private void addUniqueConstraintForTableBasedSequence(List<Statement> statements, IdSourceKeyMetadata generatorKeyMetadata) {
        Statement statement = this.createUniqueConstraintStatement(generatorKeyMetadata.getKeyColumnName(), generatorKeyMetadata.getName());
        statements.add(statement);
    }

    private Statement createUniqueConstraintStatement(String propertyName, String label) {
        String queryString = this.createUniqueConstraintQuery(propertyName, label);
        Statement statement = new Statement(queryString);
        return statement;
    }

    private void addSequence(List<Statement> statements, Sequence sequence) {
        Statement statement = new Statement(SEQUENCE_CREATION_QUERY, Collections.singletonMap("sequenceName", sequence.getName().render()));
        statements.add(statement);
    }

    @Override
    protected Number nextValue(RemoteStatements remoteStatements) {
        List<Statement> statements = this.convert(remoteStatements);
        StatementResult result = this.execute(statements);
        Number nextValue = result.single().get(0).asNumber();
        return nextValue;
    }

    public void createUniqueConstraintsForTableSequences(List<Statement> statements, Iterable<IdSourceKeyMetadata> tableIdGenerators) {
        for (IdSourceKeyMetadata idSourceKeyMetadata : tableIdGenerators) {
            if (idSourceKeyMetadata.getType() != IdSourceKeyMetadata.IdSourceType.TABLE) continue;
            this.addUniqueConstraintForTableBasedSequence(statements, idSourceKeyMetadata);
        }
    }

    private List<Statement> convert(RemoteStatements remoteStatements) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (RemoteStatement remoteStatement : remoteStatements) {
            Statement statement = new Statement(remoteStatement.getQuery(), remoteStatement.getParams());
            statements.add(statement);
        }
        return statements;
    }

    private void createUniqueConstraints(List<Sequence> sequences, Iterable<IdSourceKeyMetadata> idSourceKeyMetadata) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        this.createSequencesConstraintsStatements(statements, sequences);
        this.createUniqueConstraintsForTableSequences(statements, idSourceKeyMetadata);
        this.execute(statements);
    }

    @Override
    public void createSequences(List<Sequence> sequences, Iterable<IdSourceKeyMetadata> idSourceKeyMetadata) {
        this.createUniqueConstraints(sequences, idSourceKeyMetadata);
        List<Statement> statements = this.createSequencesStatements(sequences);
        this.execute(statements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatementResult execute(List<Statement> statements) {
        Driver driver = this.client.getDriver();
        Session session = null;
        try {
            session = driver.session();
            Transaction tx = null;
            try {
                tx = session.beginTransaction();
                StatementResult result = this.runAll(tx, statements);
                tx.success();
                StatementResult statementResult = result;
                this.close((Resource)tx);
                return statementResult;
            }
            catch (Throwable throwable) {
                this.close((Resource)tx);
                throw throwable;
            }
        }
        finally {
            this.close((Resource)session);
        }
    }

    private StatementResult runAll(Transaction tx, List<Statement> statements) {
        StatementResult result = null;
        for (Statement statement : statements) {
            result = tx.run(statement);
            this.validate(result);
        }
        return result;
    }

    private void validate(StatementResult result) {
        result.hasNext();
    }

    private void close(Resource closable) {
        if (closable != null) {
            closable.close();
        }
    }
}

