/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.ogm.datastore.neo4j.embedded.impl.EmbeddedNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.impl.BaseNeo4jSchemaDefiner;
import org.hibernate.ogm.datastore.neo4j.index.impl.Neo4jIndexSpec;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;

public class EmbeddedNeo4jSchemaDefiner
extends BaseNeo4jSchemaDefiner {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());

    @Override
    protected void createSequences(List<Sequence> sequences, Set<IdSourceKeyMetadata> allIdSourceKeyMetadata, DatastoreProvider provider) {
        EmbeddedNeo4jDatastoreProvider neo4jProvider = (EmbeddedNeo4jDatastoreProvider)provider;
        neo4jProvider.getSequenceGenerator().createSequences(sequences);
        neo4jProvider.getSequenceGenerator().createUniqueConstraintsForTableSequences(allIdSourceKeyMetadata);
    }

    @Override
    protected void createIndexesIfMissing(DatastoreProvider provider, List<Neo4jIndexSpec> indexes) {
        EmbeddedNeo4jDatastoreProvider neo4jProvider = (EmbeddedNeo4jDatastoreProvider)provider;
        GraphDatabaseService neo4jDb = neo4jProvider.getDatabase();
        try (Transaction tx = neo4jDb.beginTx();){
            for (Neo4jIndexSpec index : indexes) {
                this.createIndex(neo4jDb, index);
            }
            tx.success();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createUniqueConstraintsIfMissing(DatastoreProvider provider, List<BaseNeo4jSchemaDefiner.UniqueConstraintDetails> constraints) {
        EmbeddedNeo4jDatastoreProvider neo4jProvider = (EmbeddedNeo4jDatastoreProvider)provider;
        GraphDatabaseService neo4jDb = neo4jProvider.getDatabase();
        try (Transaction tx = neo4jDb.beginTx();){
            for (BaseNeo4jSchemaDefiner.UniqueConstraintDetails constraint : constraints) {
                this.createUniqueConstraint(neo4jDb, constraint);
            }
            tx.success();
        }
    }

    private void createIndex(GraphDatabaseService neo4jDb, Neo4jIndexSpec index) {
        Label label = index.getLabel();
        if (this.isIndexMissing(neo4jDb, index)) {
            log.tracef("Creating index for nodes labeled as %1$s on properties %2$s", label, index.getProperties());
            IndexCreator indexCreator = neo4jDb.schema().indexFor(label);
            for (String property : index.getProperties()) {
                indexCreator = indexCreator.on(property);
            }
            indexCreator.create();
        } else {
            log.tracef("Index already exists for nodes labeled as %1$s on properties %2$s", label, index.getProperties());
        }
    }

    private boolean isIndexMissing(GraphDatabaseService neo4jDb, Neo4jIndexSpec indexDetails) {
        Iterable indexes = neo4jDb.schema().getIndexes(indexDetails.getLabel());
        for (IndexDefinition index : indexes) {
            List indexProperties = CollectionHelper.toList((Iterable)index.getPropertyKeys());
            if (!Objects.equals(indexProperties, indexDetails.getProperties())) continue;
            return false;
        }
        return true;
    }

    private void createUniqueConstraint(GraphDatabaseService neo4jDb, BaseNeo4jSchemaDefiner.UniqueConstraintDetails constraint) {
        Label label = constraint.getLabel();
        String property = constraint.getProperty();
        if (this.isMissingUniqueConstraint(neo4jDb, constraint)) {
            log.tracef("Creating unique constraint for nodes labeled as %1$s on property %2$s", label, property);
            neo4jDb.schema().constraintFor(constraint.getLabel()).assertPropertyIsUnique(constraint.getProperty()).create();
        } else {
            log.tracef("Unique constraint already exists for nodes labeled as %1$s on property %2$s", label, property);
        }
    }

    private boolean isMissingUniqueConstraint(GraphDatabaseService neo4jDb, BaseNeo4jSchemaDefiner.UniqueConstraintDetails constraintDetails) {
        Iterable constraints = neo4jDb.schema().getConstraints(constraintDetails.getLabel());
        for (ConstraintDefinition constraint : constraints) {
            if (!constraint.isConstraintType(ConstraintType.UNIQUENESS)) continue;
            for (String propertyKey : constraint.getPropertyKeys()) {
                if (!propertyKey.equals(constraintDetails.getProperty())) continue;
                return false;
            }
        }
        return true;
    }
}

