/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.BaseNeo4jAssociationQueries;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.ErrorResponse;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Graph;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Row;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.StatementResult;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Statements;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.StatementsResponse;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.util.impl.ArrayHelper;

public class HttpNeo4jAssociationQueries
extends BaseNeo4jAssociationQueries {
    public HttpNeo4jAssociationQueries(EntityKeyMetadata ownerEntityKeyMetadata, AssociationKeyMetadata associationKeyMetadata) {
        super(ownerEntityKeyMetadata, associationKeyMetadata);
    }

    public void removeAssociation(HttpNeo4jClient dataBase, Long txId, AssociationKey associationKey) {
        HttpNeo4jAssociationQueries.executeQuery(dataBase, txId, this.removeAssociationQuery, this.params(associationKey.getEntityKey().getColumnValues()));
    }

    public Graph.Relationship findRelationship(HttpNeo4jClient dataBase, Long txId, AssociationKey associationKey, RowKey rowKey) {
        Object[] relationshipValues = this.relationshipValues(associationKey, rowKey);
        Object[] queryValues = ArrayHelper.concat((Object[])associationKey.getEntityKey().getColumnValues(), (Object[])relationshipValues);
        Graph result = HttpNeo4jAssociationQueries.executeQuery(dataBase, txId, this.findRelationshipQuery, this.params(queryValues));
        if (result != null && result.getRelationships().size() > 0) {
            return result.getRelationships().get(0);
        }
        return null;
    }

    public Graph.Relationship createRelationshipForEmbeddedAssociation(HttpNeo4jClient executionEngine, Long txId, AssociationKey associationKey, EntityKey embeddedKey, Object[] relationshipProperties) {
        String query = this.initCreateEmbeddedAssociationQuery(associationKey, embeddedKey);
        Object[] queryValues = this.createRelationshipForEmbeddedQueryValues(associationKey, embeddedKey, relationshipProperties);
        Map<String, Object> params = this.params(queryValues);
        Graph result = HttpNeo4jAssociationQueries.executeQuery(executionEngine, txId, query, params);
        return result.getRelationships().get(0);
    }

    public Graph.Relationship createRelationship(HttpNeo4jClient dataBase, Long txId, Object[] ownerKeyValues, Object[] targetKeyValues, Object[] relationshipProperties) {
        Object[] concat = ArrayHelper.concat(Arrays.asList(ownerKeyValues, targetKeyValues, relationshipProperties));
        Map<String, Object> params = this.params(concat);
        Graph result = HttpNeo4jAssociationQueries.executeQuery(dataBase, txId, this.createRelationshipQuery, params);
        return result.getRelationships().get(0);
    }

    public void removeAssociationRow(HttpNeo4jClient database, Long txId, AssociationKey associationKey, RowKey rowKey) {
        Object[] relationshipValues = this.relationshipValues(associationKey, rowKey);
        Object[] queryValues = ArrayHelper.concat((Object[])associationKey.getEntityKey().getColumnValues(), (Object[])relationshipValues);
        HttpNeo4jAssociationQueries.executeQuery(database, txId, this.removeAssociationRowQuery, this.params(queryValues));
    }

    private static Graph executeQuery(HttpNeo4jClient executionEngine, Long txId, String query, Map<String, Object> properties) {
        Statements statements = new Statements();
        statements.addStatement(query, properties, new String[0]);
        StatementsResponse statementsResponse = executionEngine.executeQueriesInOpenTransaction(txId, statements);
        HttpNeo4jAssociationQueries.validate(statementsResponse);
        List<StatementResult> results = statementsResponse.getResults();
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.get(0).getData().isEmpty()) {
            return null;
        }
        Row row = HttpNeo4jAssociationQueries.row(results);
        return row.getGraph();
    }

    public static Row row(List<StatementResult> results) {
        Row row = results.get(0).getData().get(0);
        return row;
    }

    private static void validate(StatementsResponse readEntity) {
        if (!readEntity.getErrors().isEmpty()) {
            ErrorResponse errorResponse = readEntity.getErrors().get(0);
            throw new HibernateException(String.valueOf(errorResponse));
        }
    }
}

