/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.type.impl.LocalDateAsStringType;
import org.hibernate.ogm.type.impl.LocalDateTimeAsStringType;
import org.hibernate.ogm.type.impl.LocalTimeAsStringType;
import org.hibernate.ogm.type.impl.StringCalendarDateType;
import org.hibernate.ogm.type.impl.StringDateTypeDescriptor;
import org.hibernate.ogm.type.impl.StringTimestampTypeDescriptor;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.LocalDateTimeType;
import org.hibernate.type.LocalDateType;
import org.hibernate.type.LocalTimeType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public abstract class BaseNeo4jTypeConverter {
    private static final Map<Type, GridType> conversionMap = BaseNeo4jTypeConverter.createGridTypeConversionMap();

    protected static Map<Type, GridType> createGridTypeConversionMap() {
        HashMap<Type, GridType> conversion = new HashMap<Type, GridType>();
        conversion.put((Type)StandardBasicTypes.CALENDAR, (GridType)StringCalendarDateType.INSTANCE);
        conversion.put((Type)StandardBasicTypes.CALENDAR_DATE, (GridType)StringCalendarDateType.INSTANCE);
        conversion.put((Type)StandardBasicTypes.DATE, (GridType)StringDateTypeDescriptor.INSTANCE);
        conversion.put((Type)StandardBasicTypes.TIME, (GridType)StringDateTypeDescriptor.INSTANCE);
        conversion.put((Type)StandardBasicTypes.TIMESTAMP, (GridType)StringTimestampTypeDescriptor.INSTANCE);
        conversion.put((Type)LocalDateType.INSTANCE, (GridType)LocalDateAsStringType.INSTANCE);
        conversion.put((Type)LocalDateTimeType.INSTANCE, (GridType)LocalDateTimeAsStringType.INSTANCE);
        conversion.put((Type)LocalTimeType.INSTANCE, (GridType)LocalTimeAsStringType.INSTANCE);
        return conversion;
    }

    public GridType convert(Type type) {
        return conversionMap.get(type);
    }
}

