/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.index.impl;

import java.util.List;
import java.util.Objects;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.neo4j.graphdb.Label;

public class Neo4jIndexSpec {
    private Label label;
    private List<String> properties;
    private boolean unique;

    public Neo4jIndexSpec(Label label, List<String> properties) {
        this(label, properties, false);
    }

    public Neo4jIndexSpec(Label label, List<String> properties, boolean unique) {
        this.label = label;
        this.properties = properties;
        this.unique = unique;
    }

    public Label getLabel() {
        return this.label;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String asCypherCreateQuery() {
        StringBuilder queryBuilder = new StringBuilder("CREATE ");
        return this.asCypher(queryBuilder);
    }

    public String asCypherDropQuery() {
        StringBuilder queryBuilder = new StringBuilder("DROP ");
        return this.asCypher(queryBuilder);
    }

    private String asCypher(StringBuilder queryBuilder) {
        queryBuilder.append("INDEX ON :");
        CypherDSL.escapeIdentifier(queryBuilder, this.label.name());
        queryBuilder.append("(");
        for (int i = 0; i < this.properties.size(); ++i) {
            if (i != 0) {
                queryBuilder.append(", ");
            }
            CypherDSL.escapeIdentifier(queryBuilder, this.properties.get(i));
        }
        queryBuilder.append(")");
        return queryBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Neo4jIndexSpec that = (Neo4jIndexSpec)object;
        return Objects.equals(this.label, that.label) && Objects.equals(this.properties, that.properties) && Objects.equals(this.unique, that.unique);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.properties, this.unique);
    }

    public String toString() {
        return "Neo4jIndexSpec[label=" + this.label + ", properties=" + this.properties + ", unique=" + this.unique + ']';
    }
}

