/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RelationshipAliasTree {
    private final String relationshipName;
    private final String targetEntityName;
    private final String alias;
    private final List<RelationshipAliasTree> children;

    private RelationshipAliasTree(String alias, String relationshipName, String targetEntityName) {
        this.alias = alias;
        this.relationshipName = relationshipName;
        this.targetEntityName = targetEntityName;
        this.children = new ArrayList<RelationshipAliasTree>();
    }

    public static RelationshipAliasTree root(String alias) {
        return new RelationshipAliasTree(alias, alias, alias);
    }

    public static RelationshipAliasTree relationship(String alias, String relationshipName, String targetEntityName) {
        return new RelationshipAliasTree(alias, relationshipName, targetEntityName);
    }

    public RelationshipAliasTree findChild(String relationshipName) {
        for (RelationshipAliasTree child : this.children) {
            if (!child.getRelationshipName().equals(relationshipName)) continue;
            return child;
        }
        return null;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    public String getTargetEntityName() {
        return this.targetEntityName;
    }

    public void addChild(RelationshipAliasTree embeddedNode) {
        this.children.add(embeddedNode);
    }

    public String getAlias() {
        return this.alias;
    }

    public List<RelationshipAliasTree> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[relationshipName=");
        builder.append(this.relationshipName);
        builder.append(", targetEntityName=");
        builder.append(this.targetEntityName);
        builder.append(", alias=");
        builder.append(this.alias);
        builder.append("]");
        return builder.toString();
    }
}

