/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jEntityQueries;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.NodeWithEmbeddedNodes;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.types.Node;

public final class BoltNeo4jAssociatedNodesHelper {
    private BoltNeo4jAssociatedNodesHelper() {
    }

    public static Map<String, Node> findAssociatedNodes(Transaction tx, NodeWithEmbeddedNodes node, EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext, BoltNeo4jEntityQueries queries) {
        HashMap<String, Node> associatedNodes = new HashMap<String, Node>(tupleTypeContext.getAllAssociatedEntityKeyMetadata().size());
        if (tupleTypeContext.getAllAssociatedEntityKeyMetadata().size() > 0) {
            Object[] keyValues = BoltNeo4jAssociatedNodesHelper.keyValues(node.getOwner(), entityKeyMetadata);
            for (Map.Entry entry : tupleTypeContext.getAllAssociatedEntityKeyMetadata().entrySet()) {
                String associationRole = (String)tupleTypeContext.getAllRoles().get(entry.getKey());
                Node associatedEntity = queries.findAssociatedEntity(tx, keyValues, associationRole);
                associatedNodes.put(associationRole, associatedEntity);
            }
        }
        return associatedNodes;
    }

    private static Object[] keyValues(Node node, EntityKeyMetadata entityKeyMetadata) {
        Object[] values = new Object[entityKeyMetadata.getColumnNames().length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = node.get(entityKeyMetadata.getColumnNames()[i]);
        }
        return values;
    }
}

