/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import java.io.Serializable;

public class ClientOptions
implements Serializable {
    public static final boolean DEFAULT_PING_BEFORE_ACTIVATE_CONNECTION = false;
    public static final boolean DEFAULT_AUTO_RECONNECT = true;
    public static final boolean DEFAULT_CANCEL_CMD_RECONNECT_FAIL = false;
    public static final boolean DEFAULT_SUSPEND_RECONNECT_PROTO_FAIL = false;
    public static final int DEFAULT_REQUEST_QUEUE_SIZE = Integer.MAX_VALUE;
    public static final DisconnectedBehavior DEFAULT_DISCONNECTED_BEHAVIOR = DisconnectedBehavior.DEFAULT;
    private final boolean pingBeforeActivateConnection;
    private final boolean autoReconnect;
    private final boolean cancelCommandsOnReconnectFailure;
    private final boolean suspendReconnectOnProtocolFailure;
    private final int requestQueueSize;
    private final DisconnectedBehavior disconnectedBehavior;

    protected ClientOptions(Builder builder) {
        this.pingBeforeActivateConnection = builder.pingBeforeActivateConnection;
        this.cancelCommandsOnReconnectFailure = builder.cancelCommandsOnReconnectFailure;
        this.autoReconnect = builder.autoReconnect;
        this.suspendReconnectOnProtocolFailure = builder.suspendReconnectOnProtocolFailure;
        this.requestQueueSize = builder.requestQueueSize;
        this.disconnectedBehavior = builder.disconnectedBehavior;
    }

    protected ClientOptions(ClientOptions original) {
        this.pingBeforeActivateConnection = original.pingBeforeActivateConnection;
        this.autoReconnect = original.autoReconnect;
        this.cancelCommandsOnReconnectFailure = original.cancelCommandsOnReconnectFailure;
        this.suspendReconnectOnProtocolFailure = original.suspendReconnectOnProtocolFailure;
        this.requestQueueSize = original.requestQueueSize;
        this.disconnectedBehavior = original.disconnectedBehavior;
    }

    public static ClientOptions copyOf(ClientOptions options) {
        return new ClientOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ClientOptions create() {
        return ClientOptions.builder().build();
    }

    public boolean isPingBeforeActivateConnection() {
        return this.pingBeforeActivateConnection;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public boolean isCancelCommandsOnReconnectFailure() {
        return this.cancelCommandsOnReconnectFailure;
    }

    public boolean isSuspendReconnectOnProtocolFailure() {
        return this.suspendReconnectOnProtocolFailure;
    }

    public int getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public DisconnectedBehavior getDisconnectedBehavior() {
        return this.disconnectedBehavior;
    }

    public static enum DisconnectedBehavior {
        DEFAULT,
        ACCEPT_COMMANDS,
        REJECT_COMMANDS;

    }

    public static class Builder {
        private boolean pingBeforeActivateConnection = false;
        private boolean autoReconnect = true;
        private boolean cancelCommandsOnReconnectFailure = false;
        private boolean suspendReconnectOnProtocolFailure = false;
        private int requestQueueSize = Integer.MAX_VALUE;
        private DisconnectedBehavior disconnectedBehavior = DEFAULT_DISCONNECTED_BEHAVIOR;

        @Deprecated
        public Builder() {
        }

        public Builder pingBeforeActivateConnection(boolean pingBeforeActivateConnection) {
            this.pingBeforeActivateConnection = pingBeforeActivateConnection;
            return this;
        }

        public Builder autoReconnect(boolean autoReconnect) {
            this.autoReconnect = autoReconnect;
            return this;
        }

        public Builder suspendReconnectOnProtocolFailure(boolean suspendReconnectOnProtocolFailure) {
            this.suspendReconnectOnProtocolFailure = suspendReconnectOnProtocolFailure;
            return this;
        }

        public Builder cancelCommandsOnReconnectFailure(boolean cancelCommandsOnReconnectFailure) {
            this.cancelCommandsOnReconnectFailure = cancelCommandsOnReconnectFailure;
            return this;
        }

        public Builder requestQueueSize(int requestQueueSize) {
            this.requestQueueSize = requestQueueSize;
            return this;
        }

        public Builder disconnectedBehavior(DisconnectedBehavior disconnectedBehavior) {
            this.disconnectedBehavior = disconnectedBehavior;
            return this;
        }

        public ClientOptions build() {
            return new ClientOptions(this);
        }
    }
}

