/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.cluster.AbstractNodeSelection;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

abstract class DynamicNodeSelection<API, CMD, K, V>
extends AbstractNodeSelection<API, CMD, K, V> {
    private final Predicate<RedisClusterNode> selector;

    public DynamicNodeSelection(StatefulRedisClusterConnection<K, V> globalConnection, Predicate<RedisClusterNode> selector, ClusterConnectionProvider.Intent intent) {
        super(globalConnection, intent);
        this.selector = selector;
    }

    @Override
    protected List<RedisClusterNode> nodes() {
        return this.globalConnection.getPartitions().getPartitions().stream().filter(this.selector).collect(Collectors.toList());
    }
}

