/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.ScoredValueStreamingChannel;
import java.nio.ByteBuffer;

public class ScoredValueStreamingOutput<K, V>
extends CommandOutput<K, V, Long> {
    private V value;
    private final ScoredValueStreamingChannel<V> channel;

    public ScoredValueStreamingOutput(RedisCodec<K, V> codec, ScoredValueStreamingChannel<V> channel) {
        super(codec, 0L);
        this.channel = channel;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = Double.parseDouble(this.decodeAscii(bytes));
        this.channel.onValue(new ScoredValue<V>(score, this.value));
        this.value = null;
        this.output = (Long)this.output + 1L;
    }
}

