/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis;

import com.lambdaworks.redis.KeyScanCursor;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.ScanArgs;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hibernate.ogm.datastore.document.association.spi.impl.DocumentHelpers;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.spi.AssociationStorageOption;
import org.hibernate.ogm.datastore.map.impl.MapHelpers;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociation;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociationSnapshot;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisTupleSnapshot;
import org.hibernate.ogm.datastore.redis.dialect.value.Association;
import org.hibernate.ogm.datastore.redis.dialect.value.Entity;
import org.hibernate.ogm.datastore.redis.impl.RedisDatastoreProvider;
import org.hibernate.ogm.datastore.redis.impl.json.JsonEntityStorageStrategy;
import org.hibernate.ogm.datastore.redis.impl.json.JsonSerializationStrategy;
import org.hibernate.ogm.datastore.redis.options.impl.TTLOption;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationKind;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.Type;

public class RedisDialect
extends BaseGridDialect
implements MultigetGridDialect {
    public static final String IDENTIFIERS = "Identifiers";
    public static final String ASSOCIATIONS = "Associations";
    protected final JsonEntityStorageStrategy entityStorageStrategy;
    private final RedisConnection<byte[], byte[]> connection;
    private final JsonSerializationStrategy serializationStrategy = new JsonSerializationStrategy();

    public RedisDialect(RedisDatastoreProvider provider) {
        this.connection = provider.getConnection();
        this.entityStorageStrategy = new JsonEntityStorageStrategy(this.serializationStrategy, this.connection);
    }

    public GridType overrideType(Type type) {
        return this.serializationStrategy.overrideType(type);
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        Entity entity = this.entityStorageStrategy.getEntity(this.entityId(key));
        if (entity != null) {
            return new Tuple((TupleSnapshot)new RedisTupleSnapshot(entity.getProperties()));
        }
        return null;
    }

    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        return new Tuple((TupleSnapshot)new RedisTupleSnapshot(new HashMap<String, Object>()));
    }

    public void insertOrUpdateTuple(EntityKey key, Tuple tuple, TupleContext tupleContext) {
        Map<String, Object> map = ((RedisTupleSnapshot)tuple.getSnapshot()).getMap();
        MapHelpers.applyTupleOpsOnMap((Tuple)tuple, map);
        this.storeEntity(key, map, tupleContext.getOptionsContext(), (Set<TupleOperation>)tuple.getOperations());
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.remove(key);
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata keyMetadata, AssociationTypeContext associationTypeContext) {
        AssociationStorageType associationStorage = this.getAssociationStorageType(associationTypeContext);
        return keyMetadata.isOneToOne() || keyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION || associationStorage == AssociationStorageType.IN_ENTITY;
    }

    private AssociationStorageType getAssociationStorageType(AssociationTypeContext associationTypeContext) {
        return (AssociationStorageType)associationTypeContext.getOptionsContext().getUnique(AssociationStorageOption.class);
    }

    private Long getTTL(OptionsContext optionsContext) {
        return (Long)optionsContext.getUnique(TTLOption.class);
    }

    private Long getTTL(AssociationContext associationContext) {
        return (Long)associationContext.getAssociationTypeContext().getOptionsContext().getUnique(TTLOption.class);
    }

    public Number nextValue(NextValueRequest request) {
        byte[] key = this.identifierId(request.getKey());
        byte[] hget = (byte[])this.connection.get((Object)key);
        if (hget == null || hget.length == 0) {
            this.connection.set((Object)key, (Object)RedisDialect.toBytes(Long.toString(request.getInitialValue())));
            return request.getInitialValue();
        }
        return this.connection.incrby((Object)key, (long)request.getIncrement());
    }

    public void forEachTuple(ModelConsumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            KeyScanCursor cursor = null;
            String prefix = entityKeyMetadata.getTable() + ":";
            byte[] prefixBytes = RedisDialect.toBytes(prefix);
            ScanArgs scanArgs = ScanArgs.Builder.matches((String)(prefix + "*"));
            do {
                cursor = cursor != null ? this.connection.scan(cursor, scanArgs) : this.connection.scan(scanArgs);
                for (byte[] key : cursor.getKeys()) {
                    Entity document = this.entityStorageStrategy.getEntity(key);
                    this.addKeyValuesFromKeyName(entityKeyMetadata, prefixBytes, key, document);
                    consumer.consume(new Tuple((TupleSnapshot)new RedisTupleSnapshot(document.getProperties())));
                }
            } while (!cursor.isFinished());
        }
    }

    private void addKeyValuesFromKeyName(EntityKeyMetadata entityKeyMetadata, byte[] prefix, byte[] key, Entity document) {
        if (this.startsWith(key, prefix)) {
            byte[] keyWithoutPrefix = this.getKeyWithoutTablePrefix(prefix, key);
            Map<String, Object> keys = this.keyBytesToMap(entityKeyMetadata, keyWithoutPrefix);
            for (Map.Entry<String, Object> entry : keys.entrySet()) {
                document.set(entry.getKey(), entry.getValue());
            }
        }
    }

    private byte[] getKeyWithoutTablePrefix(byte[] prefixBytes, byte[] key) {
        byte[] keyWithoutPrefix = new byte[key.length - prefixBytes.length];
        System.arraycopy(key, prefixBytes.length, keyWithoutPrefix, 0, keyWithoutPrefix.length);
        return keyWithoutPrefix;
    }

    private boolean startsWith(byte[] bytes, byte[] prefixBytes) {
        if (prefixBytes.length > bytes.length) {
            return false;
        }
        for (int i = 0; i < prefixBytes.length; ++i) {
            if (bytes[i] == prefixBytes[i]) continue;
            return false;
        }
        return true;
    }

    public org.hibernate.ogm.model.spi.Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        RedisAssociation redisAssociation = null;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            Entity owningEntity = this.getEmbeddingEntity(key);
            if (owningEntity != null && DotPatternMapHelpers.hasField(owningEntity.getPropertiesAsHierarchy(), (String)key.getMetadata().getCollectionRole())) {
                redisAssociation = RedisAssociation.fromEmbeddedAssociation(owningEntity, key.getMetadata());
            }
        } else {
            Association association = this.getAssociation(key.getEntityKey());
            if (association != null) {
                redisAssociation = RedisAssociation.fromAssociationDocument(association);
            }
        }
        return redisAssociation != null ? new org.hibernate.ogm.model.spi.Association((AssociationSnapshot)new RedisAssociationSnapshot(redisAssociation, key)) : null;
    }

    public org.hibernate.ogm.model.spi.Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        RedisAssociation redisAssociation;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            Entity owningEntity = this.getEmbeddingEntity(key);
            if (owningEntity == null) {
                owningEntity = this.storeEntity(key.getEntityKey(), new Entity(), associationContext);
            }
            redisAssociation = RedisAssociation.fromEmbeddedAssociation(owningEntity, key.getMetadata());
        } else {
            Association association = new Association();
            redisAssociation = RedisAssociation.fromAssociationDocument(association);
        }
        return new org.hibernate.ogm.model.spi.Association((AssociationSnapshot)new RedisAssociationSnapshot(redisAssociation, key));
    }

    private Entity getEmbeddingEntity(AssociationKey key) {
        return this.entityStorageStrategy.getEntity(this.entityId(key.getEntityKey()));
    }

    public void insertOrUpdateAssociation(AssociationKey associationKey, org.hibernate.ogm.model.spi.Association association, AssociationContext associationContext) {
        Object rows = this.getAssociationRows(association, associationKey, associationContext);
        RedisAssociation redisAssociation = ((RedisAssociationSnapshot)association.getSnapshot()).getRedisAssociation();
        redisAssociation.setRows(rows);
        if (this.isStoredInEntityStructure(associationKey.getMetadata(), associationContext.getAssociationTypeContext())) {
            this.storeEntity(associationKey.getEntityKey(), (Entity)redisAssociation.getOwningDocument(), associationContext);
        } else {
            Long currentTtl = this.connection.pttl((Object)this.entityId(associationKey.getEntityKey()));
            this.storeAssociation(associationKey.getEntityKey(), (Association)redisAssociation.getOwningDocument());
            this.setAssociationTTL(associationKey, associationContext, currentTtl);
        }
    }

    private void setAssociationTTL(AssociationKey associationKey, AssociationContext associationContext, Long currentTtl) {
        Long ttl = this.getTTL(associationContext);
        if (ttl != null) {
            this.expireAssociation(associationKey.getEntityKey(), ttl);
        } else if (currentTtl != null && currentTtl > 0L) {
            this.expireAssociation(associationKey.getEntityKey(), currentTtl);
        }
    }

    private Object getAssociationRows(org.hibernate.ogm.model.spi.Association association, AssociationKey key, AssociationContext associationContext) {
        boolean organizeByRowKey = DotPatternMapHelpers.organizeAssociationMapByRowKey((org.hibernate.ogm.model.spi.Association)association, (AssociationKey)key, (AssociationContext)associationContext);
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext()) && organizeByRowKey) {
            String rowKeyColumn = organizeByRowKey ? key.getMetadata().getRowKeyIndexColumnNames()[0] : null;
            HashMap rows = new HashMap();
            for (RowKey rowKey : association.getKeys()) {
                Map row = (Map)this.getAssociationRow(association.get(rowKey), key);
                String rowKeyValue = (String)row.remove(rowKeyColumn);
                if (row.keySet().size() == 1) {
                    rows.put(rowKeyValue, row.values().iterator().next());
                    continue;
                }
                rows.put(rowKeyValue, row);
            }
            return rows;
        }
        ArrayList<Object> rows = new ArrayList<Object>(association.size());
        for (RowKey rowKey : association.getKeys()) {
            rows.add(this.getAssociationRow(association.get(rowKey), key));
        }
        return rows;
    }

    private Object getAssociationRow(Tuple row, AssociationKey associationKey) {
        String[] columnsToPersist = associationKey.getMetadata().getColumnsWithoutKeyColumns((Iterable)row.getColumnNames());
        if (columnsToPersist.length == 1) {
            return row.get(columnsToPersist[0]);
        }
        Entity rowObject = new Entity();
        String prefix = this.getColumnSharedPrefixOfAssociatedEntityLink(associationKey);
        for (String column : columnsToPersist) {
            Object value = row.get(column);
            if (value == null) continue;
            String columnName = column.startsWith(prefix) ? column.substring(prefix.length()) : column;
            rowObject.set(columnName, value);
        }
        return rowObject.getPropertiesAsHierarchy();
    }

    private String getColumnSharedPrefixOfAssociatedEntityLink(AssociationKey associationKey) {
        String[] associationKeyColumns = associationKey.getMetadata().getAssociatedEntityKeyMetadata().getAssociationKeyColumns();
        String prefix = DocumentHelpers.getColumnSharedPrefix((String[])associationKeyColumns);
        return prefix == null ? "" : prefix + ".";
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            Entity owningEntity = this.getEmbeddingEntity(key);
            if (owningEntity != null) {
                owningEntity.removeAssociation(key.getMetadata().getCollectionRole());
                this.storeEntity(key.getEntityKey(), owningEntity, associationContext);
            }
        } else {
            this.removeAssociation(key.getEntityKey());
        }
    }

    private void addIdToEntity(Entity entity, String[] columnNames, Object[] columnValues) {
        for (int i = 0; i < columnNames.length; ++i) {
            entity.set(columnNames[i], columnValues[i]);
        }
    }

    private void storeEntity(EntityKey key, Map<String, Object> map, OptionsContext optionsContext, Set<TupleOperation> operations) {
        Entity entityDocument = new Entity();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (key.getMetadata().isKeyColumn(entry.getKey())) continue;
            entityDocument.set(entry.getKey(), entry.getValue());
        }
        this.storeEntity(key, entityDocument, optionsContext, operations);
    }

    private void storeEntity(EntityKey key, Entity document, OptionsContext optionsContext, Set<TupleOperation> operations) {
        Long currentTtl = this.connection.pttl((Object)this.entityId(key));
        this.entityStorageStrategy.storeEntity(this.entityId(key), document, operations);
        this.setEntityTTL(key, currentTtl, this.getTTL(optionsContext));
    }

    private void setEntityTTL(EntityKey key, Long currentTtl, Long configuredTTL) {
        if (configuredTTL != null) {
            this.expireEntity(key, configuredTTL);
        } else if (currentTtl != null && currentTtl > 0L) {
            this.expireEntity(key, currentTtl);
        }
    }

    private Association getAssociation(EntityKey key) {
        byte[] associationId = this.associationId(key);
        List lrange = this.connection.lrange((Object)associationId, 0L, -1L);
        Association association = new Association();
        for (byte[] bytes : lrange) {
            association.getRows().add(this.serializationStrategy.deserialize(bytes, Object.class));
        }
        return association;
    }

    private Entity storeEntity(EntityKey key, Entity entity, AssociationContext associationContext) {
        Long currentTtl = this.connection.pttl((Object)this.entityId(key));
        this.entityStorageStrategy.storeEntity(this.entityId(key), entity, null);
        this.setEntityTTL(key, currentTtl, this.getTTL(associationContext));
        return entity;
    }

    private void expireEntity(EntityKey key, Long ttl) {
        byte[] associationId = this.entityId(key);
        this.connection.pexpire((Object)associationId, ttl.longValue());
    }

    private void storeAssociation(EntityKey key, Association document) {
        byte[] associationId = this.associationId(key);
        this.connection.del((Object[])new byte[][]{associationId});
        for (Object row : document.getRows()) {
            this.connection.rpush((Object)associationId, (Object[])new byte[][]{this.serializationStrategy.serialize(row)});
        }
    }

    private void expireAssociation(EntityKey key, Long ttl) {
        byte[] associationId = this.associationId(key);
        this.connection.pexpire((Object)associationId, ttl.longValue());
    }

    private void removeAssociation(EntityKey key) {
        this.connection.del((Object[])new byte[][]{this.associationId(key)});
    }

    private void remove(EntityKey key) {
        this.connection.del((Object[])new byte[][]{this.entityId(key)});
    }

    private byte[] identifierId(IdSourceKey key) {
        byte[] prefix = RedisDialect.toBytes("Identifiers:" + key.getTable() + ":");
        byte[] entityId = this.keyToBytes(key.getColumnNames(), key.getColumnValues());
        byte[] identifierId = new byte[prefix.length + entityId.length];
        System.arraycopy(prefix, 0, identifierId, 0, prefix.length);
        System.arraycopy(entityId, 0, identifierId, prefix.length, entityId.length);
        return identifierId;
    }

    private byte[] associationId(EntityKey key) {
        byte[] prefix = RedisDialect.toBytes("Associations:" + key.getTable() + ":");
        byte[] entityId = this.keyToBytes(key.getColumnNames(), key.getColumnValues());
        byte[] associationId = new byte[prefix.length + entityId.length];
        System.arraycopy(prefix, 0, associationId, 0, prefix.length);
        System.arraycopy(entityId, 0, associationId, prefix.length, entityId.length);
        return associationId;
    }

    public byte[] entityId(EntityKey key) {
        byte[] prefix = RedisDialect.toBytes(key.getTable() + ":");
        byte[] entityId = this.keyToBytes(key.getColumnNames(), key.getColumnValues());
        byte[] associationId = new byte[prefix.length + entityId.length];
        System.arraycopy(prefix, 0, associationId, 0, prefix.length);
        System.arraycopy(entityId, 0, associationId, prefix.length, entityId.length);
        return associationId;
    }

    public JsonEntityStorageStrategy getEntityStorageStrategy() {
        return this.entityStorageStrategy;
    }

    private byte[] keyToBytes(String[] columnNames, Object[] columnValues) {
        if (columnNames.length == 1) {
            return RedisDialect.toBytes(columnValues[0].toString());
        }
        Collator collator = Collator.getInstance(Locale.ENGLISH);
        collator.setStrength(1);
        TreeMap<Object, Object> idObject = new TreeMap<Object, Object>(collator);
        for (int i = 0; i < columnNames.length; ++i) {
            idObject.put(columnNames[i], columnValues[i]);
        }
        return this.serializationStrategy.serialize(idObject);
    }

    private Map<String, Object> keyBytesToMap(EntityKeyMetadata entityKeyMetadata, byte[] key) {
        if (entityKeyMetadata.getColumnNames().length == 1) {
            return Collections.singletonMap(entityKeyMetadata.getColumnNames()[0], RedisDialect.toString(key));
        }
        return this.serializationStrategy.deserialize(key, Map.class);
    }

    public static byte[] toBytes(String string) {
        if (string == null) {
            return new byte[0];
        }
        return string.getBytes(LettuceCharsets.UTF8);
    }

    public static String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, 0, bytes.length, LettuceCharsets.UTF8);
    }

    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        byte[][] ids = new byte[keys.length][];
        for (int i = 0; i < keys.length; ++i) {
            ids[i] = this.entityId(keys[i]);
        }
        Iterable<Entity> entities = this.entityStorageStrategy.getEntities(ids);
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(keys.length);
        int i = 0;
        for (Entity entity : entities) {
            if (entity != null) {
                EntityKey key = keys[i];
                this.addIdToEntity(entity, key.getColumnNames(), key.getColumnValues());
                tuples.add(new Tuple((TupleSnapshot)new RedisTupleSnapshot(entity.getProperties())));
            }
            ++i;
        }
        return tuples;
    }
}

