/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.impl.json;

import com.lambdaworks.redis.RedisConnection;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.ogm.datastore.redis.dialect.value.Entity;
import org.hibernate.ogm.datastore.redis.impl.json.JsonSerializationStrategy;
import org.hibernate.ogm.model.spi.TupleOperation;

public class JsonEntityStorageStrategy {
    private final JsonSerializationStrategy jsonSerializationStrategy;
    private final RedisConnection<byte[], byte[]> connection;

    public JsonEntityStorageStrategy(JsonSerializationStrategy jsonSerializationStrategy, RedisConnection<byte[], byte[]> connection) {
        this.jsonSerializationStrategy = jsonSerializationStrategy;
        this.connection = connection;
    }

    public Entity getEntity(byte[] key) {
        byte[] value = (byte[])this.connection.get((Object)key);
        return this.jsonSerializationStrategy.deserialize(value, Entity.class);
    }

    public void storeEntity(byte[] key, Entity entity, Set<TupleOperation> operations) {
        byte[] value = this.jsonSerializationStrategy.serialize(entity);
        this.connection.set((Object)key, (Object)value);
    }

    public Iterable<Entity> getEntities(byte[][] keys) {
        final Iterator values = this.connection.mget((Object[])keys).iterator();
        return new Iterable<Entity>(){

            @Override
            public Iterator<Entity> iterator() {
                return new Iterator<Entity>(){

                    @Override
                    public boolean hasNext() {
                        return values.hasNext();
                    }

                    @Override
                    public Entity next() {
                        byte[] value = (byte[])values.next();
                        return value != null ? JsonEntityStorageStrategy.this.jsonSerializationStrategy.deserialize(value, Entity.class) : null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal is not supported");
                    }
                };
            }
        };
    }
}

