/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.impl.json;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.redis.impl.RedisJsonBlobType;
import org.hibernate.ogm.datastore.redis.impl.RedisJsonByteType;
import org.hibernate.ogm.datastore.redis.impl.RedisJsonLongType;
import org.hibernate.ogm.type.impl.AbstractGenericBasicType;
import org.hibernate.ogm.type.impl.Iso8601StringCalendarType;
import org.hibernate.ogm.type.impl.Iso8601StringDateType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.MaterializedBlobType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class RedisJsonTypeConverter {
    public static final RedisJsonTypeConverter INSTANCE = new RedisJsonTypeConverter();
    private static final Map<Type, AbstractGenericBasicType<?>> conversionMap = RedisJsonTypeConverter.createGridTypeConversionMap();

    private static Map<Type, AbstractGenericBasicType<?>> createGridTypeConversionMap() {
        HashMap conversion = new HashMap();
        conversion.put((Type)StandardBasicTypes.CALENDAR, (AbstractGenericBasicType<?>)Iso8601StringCalendarType.DATE_TIME);
        conversion.put((Type)StandardBasicTypes.CALENDAR_DATE, (AbstractGenericBasicType<?>)Iso8601StringCalendarType.DATE);
        conversion.put((Type)StandardBasicTypes.DATE, (AbstractGenericBasicType<?>)Iso8601StringDateType.DATE);
        conversion.put((Type)StandardBasicTypes.TIME, (AbstractGenericBasicType<?>)Iso8601StringDateType.TIME);
        conversion.put((Type)StandardBasicTypes.TIMESTAMP, (AbstractGenericBasicType<?>)Iso8601StringDateType.DATE_TIME);
        conversion.put((Type)StandardBasicTypes.BYTE, RedisJsonByteType.INSTANCE);
        conversion.put((Type)StandardBasicTypes.LONG, RedisJsonLongType.INSTANCE);
        conversion.put((Type)BinaryType.INSTANCE, RedisJsonBlobType.INSTANCE);
        conversion.put((Type)MaterializedBlobType.INSTANCE, RedisJsonBlobType.INSTANCE);
        return conversion;
    }

    public AbstractGenericBasicType<Object> convert(Type type) {
        return conversionMap.get(type);
    }
}

