/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.dialect.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociation;
import org.hibernate.ogm.datastore.redis.dialect.value.Entity;
import org.hibernate.ogm.datastore.redis.dialect.value.StructuredValue;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationType;

class EmbeddedAssociation
extends RedisAssociation {
    private final Entity entity;
    private final AssociationKeyMetadata associationKeyMetadata;

    public EmbeddedAssociation(Entity entity, AssociationKeyMetadata associationKeyMetadata) {
        this.entity = entity;
        this.associationKeyMetadata = associationKeyMetadata;
    }

    @Override
    public Object getRows() {
        Object fieldValue = DotPatternMapHelpers.getValueOrNull(this.entity.getPropertiesAsHierarchy(), (String)this.associationKeyMetadata.getCollectionRole());
        Object rows = fieldValue == null ? Collections.emptyList() : (this.associationKeyMetadata.getAssociationType() == AssociationType.ONE_TO_ONE ? fieldValue : fieldValue);
        return rows;
    }

    @Override
    public void setRows(Object rows) {
        if (this.isEmpty(rows)) {
            this.entity.removeAssociation(this.associationKeyMetadata.getCollectionRole());
        } else {
            this.entity.removeAssociation(this.associationKeyMetadata.getCollectionRole());
            if (this.associationKeyMetadata.getAssociationType() == AssociationType.ONE_TO_ONE && rows instanceof Collection) {
                Object value = ((Collection)rows).iterator().next();
                this.entity.set(this.associationKeyMetadata.getCollectionRole(), value);
            } else {
                this.entity.set(this.associationKeyMetadata.getCollectionRole(), rows);
            }
        }
    }

    protected boolean isEmpty(Object rows) {
        if (rows == null) {
            return true;
        }
        if (rows instanceof Collection && ((Collection)rows).isEmpty()) {
            return true;
        }
        return rows instanceof Map && ((Map)rows).isEmpty();
    }

    @Override
    public StructuredValue getOwningDocument() {
        return this.entity;
    }
}

