/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.impl;

import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.ogm.cfg.spi.Hosts;
import org.hibernate.ogm.datastore.redis.RedisDialect;
import org.hibernate.ogm.datastore.redis.impl.RedisConfiguration;
import org.hibernate.ogm.datastore.redis.logging.impl.Log;
import org.hibernate.ogm.datastore.redis.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class RedisDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
ServiceRegistryAwareService,
Configurable {
    private static final Log log = LoggerFactory.getLogger();
    private ServiceRegistryImplementor serviceRegistry;
    private RedisConfiguration config;
    private RedisClient redisClient;
    private RedisConnection<String, String> connection;

    public Class<? extends GridDialect> getDefaultDialect() {
        return RedisDialect.class;
    }

    public void configure(Map configurationValues) {
        ClassLoaderService classLoaderService = (ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class);
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues, classLoaderService);
        try {
            this.config = new RedisConfiguration(propertyReader);
        }
        catch (Exception e) {
            throw log.unableToConfigureDatastoreProvider(e);
        }
    }

    public void start() {
        try {
            Hosts.HostAndPort hostAndPort = this.config.getHosts().getFirst();
            this.redisClient = this.createClient(hostAndPort);
            log.connectingToRedis(this.config.getHosts().toString(), this.config.getTimeout());
            this.connection = this.redisClient.connect((RedisCodec)new Utf8StringCodec());
        }
        catch (RuntimeException e) {
            throw log.unableToInitializeRedis(e);
        }
    }

    protected RedisClient createClient(Hosts.HostAndPort hostAndPort) {
        RedisURI.Builder builder = RedisURI.Builder.redis((String)hostAndPort.getHost(), (int)hostAndPort.getPort());
        builder.withSsl(this.config.isSsl());
        builder.withDatabase(this.config.getDatabaseNumber());
        if (this.config.getPassword() != null) {
            builder.withPassword(this.config.getPassword());
        }
        builder.withTimeout(this.config.getTimeout(), TimeUnit.MILLISECONDS);
        return new RedisClient(builder.build());
    }

    public void stop() {
        if (this.connection != null) {
            log.disconnectingFromRedis();
            this.connection.close();
            this.connection = null;
            this.shutdownClient();
        }
    }

    protected void shutdownClient() {
        this.redisClient.shutdown(100L, 100L, TimeUnit.MILLISECONDS);
        this.redisClient = null;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public boolean allowsTransactionEmulation() {
        return true;
    }

    public RedisConnection<String, String> getConnection() {
        return this.connection;
    }
}

