/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis;

import com.lambdaworks.redis.KeyScanCursor;
import com.lambdaworks.redis.ScanArgs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.ogm.datastore.map.impl.MapHelpers;
import org.hibernate.ogm.datastore.redis.AbstractRedisDialect;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociation;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociationSnapshot;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisTupleSnapshot;
import org.hibernate.ogm.datastore.redis.dialect.value.Association;
import org.hibernate.ogm.datastore.redis.dialect.value.HashEntity;
import org.hibernate.ogm.datastore.redis.impl.RedisDatastoreProvider;
import org.hibernate.ogm.datastore.redis.impl.hash.RedisHashTypeConverter;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationType;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.Type;

public class RedisHashDialect
extends AbstractRedisDialect {
    public RedisHashDialect(RedisDatastoreProvider provider) {
        super(provider.getConnection(), provider.isCluster());
    }

    public GridType overrideType(Type type) {
        return RedisHashTypeConverter.INSTANCE.convert(type);
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        Map<String, Object> objects;
        String entityIdString = this.entityId(key);
        if (!this.connection.exists((Object)entityIdString).booleanValue()) {
            return null;
        }
        if (tupleContext.getSelectableColumns().isEmpty()) {
            objects = this.connection.hgetall((Object)entityIdString);
        } else {
            List hmget = this.connection.hmget((Object)entityIdString, (Object[])this.getFields(tupleContext));
            objects = this.toEntity(tupleContext, hmget);
        }
        return new Tuple((TupleSnapshot)new RedisTupleSnapshot(objects));
    }

    private Map<String, Object> toEntity(TupleContext tupleContext, List<String> hmget) {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        for (int i = 0; i < tupleContext.getSelectableColumns().size(); ++i) {
            String columnName = (String)tupleContext.getSelectableColumns().get(i);
            String value = hmget.get(i);
            if (value == null) continue;
            objects.put(columnName, value);
        }
        return objects;
    }

    private String[] getFields(TupleContext tupleContext) {
        return tupleContext.getSelectableColumns().toArray(new String[tupleContext.getSelectableColumns().size()]);
    }

    public void insertOrUpdateTuple(EntityKey key, Tuple tuple, TupleContext tupleContext) throws TupleAlreadyExistsException {
        Map<String, Object> map = ((RedisTupleSnapshot)tuple.getSnapshot()).getMap();
        MapHelpers.applyTupleOpsOnMap((Tuple)tuple, map);
        Map<String, String> entity = this.getEntityForUpdate(key, tuple);
        List<String> toDelete = this.getKeysForRemoval(tuple);
        String entityId = this.entityId(key);
        Long currentTtl = this.connection.pttl((Object)this.entityId(key));
        if (!toDelete.isEmpty()) {
            this.connection.hdel((Object)entityId, (Object[])toDelete.toArray(new String[toDelete.size()]));
        }
        if (!entity.isEmpty()) {
            this.connection.hmset((Object)entityId, entity);
        }
        this.setEntityTTL(key, currentTtl, this.getTTL(tupleContext.getOptionsContext()));
    }

    private Map<String, String> getEntityForUpdate(EntityKey key, Tuple tuple) {
        HashMap<String, String> entity = new HashMap<String, String>();
        for (TupleOperation action : tuple.getOperations()) {
            switch (action.getType()) {
                case PUT: {
                    if (action.getValue() instanceof Character) {
                        entity.put(action.getColumn(), action.getValue().toString());
                        break;
                    }
                    entity.put(action.getColumn(), (String)action.getValue());
                }
            }
        }
        return entity;
    }

    private List<String> getKeysForRemoval(Tuple tuple) {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (TupleOperation action : tuple.getOperations()) {
            switch (action.getType()) {
                case REMOVE: 
                case PUT_NULL: {
                    toDelete.add(action.getColumn());
                }
            }
        }
        return toDelete;
    }

    public org.hibernate.ogm.model.spi.Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        RedisAssociation redisAssociation;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            if (!this.connection.exists((Object)this.entityId(key.getEntityKey())).booleanValue()) {
                return null;
            }
            Map entity = this.connection.hgetall((Object)this.entityId(key.getEntityKey()));
            redisAssociation = RedisAssociation.fromEmbeddedAssociation(entity, key.getMetadata());
        } else {
            Association association = this.getAssociation(key);
            if (association == null) {
                return null;
            }
            redisAssociation = RedisAssociation.fromAssociationDocument(association);
        }
        return redisAssociation != null ? new org.hibernate.ogm.model.spi.Association((AssociationSnapshot)new RedisAssociationSnapshot(redisAssociation, key)) : null;
    }

    public org.hibernate.ogm.model.spi.Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        RedisAssociation redisAssociation;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            Map entity = this.connection.hgetall((Object)this.entityId(key.getEntityKey()));
            redisAssociation = RedisAssociation.fromEmbeddedAssociation(entity, key.getMetadata());
        } else {
            Association association = this.getAssociation(key);
            if (association == null) {
                return null;
            }
            redisAssociation = RedisAssociation.fromAssociationDocument(association);
        }
        return new org.hibernate.ogm.model.spi.Association((AssociationSnapshot)new RedisAssociationSnapshot(redisAssociation, key));
    }

    public void insertOrUpdateAssociation(AssociationKey associationKey, org.hibernate.ogm.model.spi.Association association, AssociationContext associationContext) {
        Object rows = this.getAssociationRows(association, associationKey);
        RedisAssociation redisAssociation = ((RedisAssociationSnapshot)association.getSnapshot()).getRedisAssociation();
        redisAssociation.setRows(rows);
        if (this.isStoredInEntityStructure(associationKey.getMetadata(), associationContext.getAssociationTypeContext())) {
            HashEntity owningDocument = (HashEntity)redisAssociation.getOwningDocument();
            this.connection.hmset((Object)this.entityId(associationKey.getEntityKey()), owningDocument.getEntity());
        } else {
            Long currentTtl = this.connection.pttl((Object)this.associationId(associationKey));
            this.storeAssociation(associationKey, (Association)redisAssociation.getOwningDocument());
            this.setAssociationTTL(associationKey, associationContext, currentTtl);
        }
    }

    private Object getAssociationRows(org.hibernate.ogm.model.spi.Association association, AssociationKey key) {
        ArrayList<Object> rows = new ArrayList<Object>(association.size());
        for (RowKey rowKey : association.getKeys()) {
            rows.add(RedisHashDialect.getAssociationRow(association.get(rowKey), key));
        }
        return rows;
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            String entityId = this.entityId(key.getEntityKey());
            this.connection.hdel((Object)entityId, (Object[])new String[]{key.getMetadata().getCollectionRole()});
        } else {
            this.connection.del((Object[])new String[]{this.associationId(key)});
        }
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata keyMetadata, AssociationTypeContext associationTypeContext) {
        return keyMetadata.getAssociationType() == AssociationType.ONE_TO_ONE;
    }

    public void forEachTuple(ModelConsumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            KeyScanCursor<String> cursor = null;
            String prefix = entityKeyMetadata.getTable() + ":";
            ScanArgs scanArgs = ScanArgs.Builder.matches((String)(prefix + "*"));
            do {
                cursor = this.scan(cursor, scanArgs);
                for (String key : cursor.getKeys()) {
                    Map hgetall = this.connection.hgetall((Object)key);
                    HashMap<String, Object> entity = new HashMap<String, Object>();
                    entity.putAll(hgetall);
                    this.addKeyValuesFromKeyName(entityKeyMetadata, prefix, key, entity);
                    consumer.consume(new Tuple((TupleSnapshot)new RedisTupleSnapshot(entity)));
                }
            } while (!cursor.isFinished());
        }
    }

    protected void addKeyValuesFromKeyName(EntityKeyMetadata entityKeyMetadata, String prefix, String key, Map<String, Object> document) {
        if (key.startsWith(prefix)) {
            String keyWithoutPrefix = key.substring(prefix.length());
            Map<String, Object> keys = this.keyToMap(entityKeyMetadata, keyWithoutPrefix);
            for (Map.Entry<String, Object> entry : keys.entrySet()) {
                document.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

