/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.dialect.model.impl;

import java.util.Collection;
import java.util.Map;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociation;
import org.hibernate.ogm.datastore.redis.dialect.value.HashEntity;
import org.hibernate.ogm.datastore.redis.dialect.value.StructuredValue;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;

class HashEmbeddedAssociation
extends RedisAssociation {
    private final Map<String, String> entity;
    private final HashEntity hashEntity;
    private final AssociationKeyMetadata associationKeyMetadata;

    public HashEmbeddedAssociation(Map<String, String> entity, AssociationKeyMetadata associationKeyMetadata) {
        this.entity = entity;
        this.associationKeyMetadata = associationKeyMetadata;
        this.hashEntity = new HashEntity(entity);
    }

    @Override
    public Object getRows() {
        return this.entity.get(this.associationKeyMetadata.getCollectionRole());
    }

    @Override
    public void setRows(Object rows) {
        if (this.isEmpty(rows)) {
            this.entity.put(this.associationKeyMetadata.getCollectionRole(), null);
        } else {
            Object value = ((Collection)rows).iterator().next();
            this.entity.put(this.associationKeyMetadata.getCollectionRole(), (String)value);
        }
    }

    protected boolean isEmpty(Object rows) {
        if (rows == null) {
            return true;
        }
        return rows instanceof Collection && ((Collection)rows).isEmpty();
    }

    @Override
    public StructuredValue getOwningDocument() {
        return this.hashEntity;
    }
}

