/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.dialect.model.impl;

import java.util.Map;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.DocumentBasedAssociation;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.EmbeddedAssociation;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.HashEmbeddedAssociation;
import org.hibernate.ogm.datastore.redis.dialect.value.Association;
import org.hibernate.ogm.datastore.redis.dialect.value.Entity;
import org.hibernate.ogm.datastore.redis.dialect.value.StructuredValue;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;

public abstract class RedisAssociation {
    public static RedisAssociation fromEmbeddedAssociation(Entity entity, AssociationKeyMetadata associationKeyMetadata) {
        return new EmbeddedAssociation(entity, associationKeyMetadata);
    }

    public static RedisAssociation fromEmbeddedAssociation(Map<String, String> entity, AssociationKeyMetadata associationKeyMetadata) {
        return new HashEmbeddedAssociation(entity, associationKeyMetadata);
    }

    public static RedisAssociation fromAssociationDocument(Association associationDocument) {
        return new DocumentBasedAssociation(associationDocument);
    }

    public abstract Object getRows();

    public abstract void setRows(Object var1);

    public abstract StructuredValue getOwningDocument();
}

