/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.logging.impl;

import org.hibernate.HibernateException;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="OGM")
public interface Log
extends org.hibernate.ogm.util.impl.Log {
    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1701, value="Connecting to Redis at %1$s with a timeout set at %2$d millisecond(s)")
    public void connectingToRedis(String var1, long var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1702, value="Closing connection to Redis")
    public void disconnectingFromRedis();

    @Message(id=1703, value="Unable to find or initialize a connection to the Redis server")
    public HibernateException unableToInitializeRedis(@Cause RuntimeException var1);

    @Message(id=1704, value="The value set for the configuration property 'hibernate.ogm.datastore.database' must be a number between 0 and 15. Found '%s'.")
    public HibernateException illegalDatabaseValue(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1705, value="Cannot determine redis_mode from INFO output. Found '%s'.")
    public void cannotDetermineRedisMode(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1706, value="Connected Redis node runs in mode '%s'.")
    public void connectedRedisNodeRunsIn(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1707, value="Connecting to Redis Cluster at %1$s with a timeout set at %2$d millisecond(s)")
    public void connectingToRedisCluster(String var1, long var2);

    @Message(id=1708, value="The connection is configured for cluster mode but Redis runs in '%s' mode")
    public HibernateException redisModeMismatchClusterModeConfigured(String var1);

    @Message(id=1709, value="The connection is configured for standalone mode but Redis runs in '%s' mode")
    public HibernateException redisModeMismatchStandaloneModeConfigured(String var1);

    @Message(id=1710, value="Redis Hash dialect does not support *ToMany associations embedded in the entity %1$s#%2$s")
    public HibernateException embeddedToManyAssociationsNotSupportByRedisHash(String var1, String var2);
}

