/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis;

import com.lambdaworks.redis.KeyScanCursor;
import com.lambdaworks.redis.ScanArgs;
import com.lambdaworks.redis.cluster.api.sync.RedisClusterCommands;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.ogm.datastore.redis.AbstractRedisDialect;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociation;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisAssociationSnapshot;
import org.hibernate.ogm.datastore.redis.dialect.model.impl.RedisHashTupleSnapshot;
import org.hibernate.ogm.datastore.redis.dialect.value.Association;
import org.hibernate.ogm.datastore.redis.dialect.value.HashEntity;
import org.hibernate.ogm.datastore.redis.impl.RedisDatastoreProvider;
import org.hibernate.ogm.datastore.redis.impl.hash.RedisHashTypeConverter;
import org.hibernate.ogm.dialect.batch.spi.GroupedChangesToEntityOperation;
import org.hibernate.ogm.dialect.batch.spi.GroupingByEntityDialect;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.Operation;
import org.hibernate.ogm.dialect.batch.spi.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationType;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.Type;

public class RedisHashDialect
extends AbstractRedisDialect
implements GroupingByEntityDialect {
    public RedisHashDialect(RedisDatastoreProvider provider) {
        super(provider.getConnection(), provider.isCluster());
    }

    public GridType overrideType(Type type) {
        return RedisHashTypeConverter.INSTANCE.convert(type);
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        Map<String, String> objects;
        String entityIdString = this.entityId(key);
        if (!this.connection.exists((Object)entityIdString).booleanValue()) {
            return null;
        }
        if (operationContext.getTupleTypeContext().getSelectableColumns().isEmpty()) {
            objects = this.connection.hgetall((Object)entityIdString);
        } else {
            List hmget = this.connection.hmget((Object)entityIdString, (Object[])this.getFields(operationContext.getTupleTypeContext()));
            objects = this.toEntity(operationContext.getTupleTypeContext(), hmget);
        }
        return RedisHashDialect.createTuple(objects);
    }

    public Tuple createTuple(EntityKey key, OperationContext operationContext) {
        return new Tuple((TupleSnapshot)new RedisHashTupleSnapshot(new HashEntity(new HashMap<String, String>())), Tuple.SnapshotType.INSERT);
    }

    private Map<String, String> toEntity(TupleTypeContext tupleTypeContext, List<String> hmget) {
        HashMap<String, String> objects = new HashMap<String, String>();
        for (int i = 0; i < tupleTypeContext.getSelectableColumns().size(); ++i) {
            String columnName = (String)tupleTypeContext.getSelectableColumns().get(i);
            String value = hmget.get(i);
            if (value == null) continue;
            objects.put(columnName, value);
        }
        return objects;
    }

    private String[] getFields(TupleTypeContext tupleTypeContext) {
        return tupleTypeContext.getSelectableColumns().toArray(new String[tupleTypeContext.getSelectableColumns().size()]);
    }

    public org.hibernate.ogm.model.spi.Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        RedisAssociation redisAssociation = null;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            TuplePointer tuplePointer = this.getEmbeddingEntityTuplePointer(key, associationContext);
            if (tuplePointer == null) {
                return null;
            }
            HashEntity owningEntity = this.getEntityFromTuple(tuplePointer.getTuple());
            if (owningEntity != null && owningEntity.has(key.getMetadata().getCollectionRole())) {
                redisAssociation = RedisAssociation.fromHashEmbeddedAssociation(tuplePointer, key.getMetadata());
            }
        } else {
            Association association = this.getAssociation(key);
            if (association == null) {
                return null;
            }
            redisAssociation = RedisAssociation.fromAssociationDocument(association);
        }
        return redisAssociation != null ? new org.hibernate.ogm.model.spi.Association((AssociationSnapshot)new RedisAssociationSnapshot(redisAssociation, key)) : null;
    }

    public org.hibernate.ogm.model.spi.Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        RedisAssociation redisAssociation;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            TuplePointer tuplePointer = this.getEmbeddingEntityTuplePointer(key, associationContext);
            HashEntity owningEntity = this.getEntityFromTuple(tuplePointer.getTuple());
            if (owningEntity == null) {
                owningEntity = new HashEntity(new HashMap<String, String>());
                this.storeEntity(key.getEntityKey(), owningEntity, associationContext.getAssociationTypeContext().getOwnerEntityOptionsContext());
                tuplePointer.setTuple(new Tuple((TupleSnapshot)new RedisHashTupleSnapshot(owningEntity), Tuple.SnapshotType.UPDATE));
            }
            redisAssociation = RedisAssociation.fromHashEmbeddedAssociation(tuplePointer, key.getMetadata());
        } else {
            redisAssociation = RedisAssociation.fromAssociationDocument(new Association());
        }
        return new org.hibernate.ogm.model.spi.Association((AssociationSnapshot)new RedisAssociationSnapshot(redisAssociation, key));
    }

    private Object getAssociationRows(org.hibernate.ogm.model.spi.Association association, AssociationKey key) {
        ArrayList<Object> rows = new ArrayList<Object>(association.size());
        for (RowKey rowKey : association.getKeys()) {
            rows.add(RedisHashDialect.getAssociationRow(association.get(rowKey), key));
        }
        return rows;
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata keyMetadata, AssociationTypeContext associationTypeContext) {
        return keyMetadata.getAssociationType() == AssociationType.ONE_TO_ONE;
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        KeyScanCursor<String> cursor = null;
        String prefix = entityKeyMetadata.getTable() + ":";
        ScanArgs scanArgs = ScanArgs.Builder.matches((String)(prefix + "*"));
        do {
            cursor = this.scan(cursor, scanArgs);
            consumer.consume((TuplesSupplier)new RedisHashDialectTuplesSupplier(cursor, (RedisClusterCommands<String, String>)this.connection, prefix, entityKeyMetadata));
        } while (!cursor.isFinished());
    }

    private static Tuple createTuple(Map<String, String> properties) {
        return new Tuple((TupleSnapshot)new RedisHashTupleSnapshot(new HashEntity(properties)), Tuple.SnapshotType.UPDATE);
    }

    protected void addKeyValuesFromKeyName(EntityKeyMetadata entityKeyMetadata, String prefix, String key, Map<String, String> document) {
        if (key.startsWith(prefix)) {
            String keyWithoutPrefix = key.substring(prefix.length());
            Map<String, String> keys = this.keyToMap(entityKeyMetadata, keyWithoutPrefix);
            for (Map.Entry<String, String> entry : keys.entrySet()) {
                document.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void executeGroupedChangesToEntity(GroupedChangesToEntityOperation groupedOperation) {
        String entityId = this.entityId(groupedOperation.getEntityKey());
        HashEntity owningEntity = null;
        ArrayList<String> toDelete = new ArrayList<String>();
        ArrayList<AssociationKey> associationsToRemove = new ArrayList<AssociationKey>();
        OptionsContext optionsContext = null;
        for (Operation operation : groupedOperation.getOperations()) {
            AssociationKey associationKey;
            if (operation instanceof InsertOrUpdateTupleOperation) {
                InsertOrUpdateTupleOperation insertOrUpdateTupleOperation = (InsertOrUpdateTupleOperation)operation;
                Tuple tuple = insertOrUpdateTupleOperation.getTuplePointer().getTuple();
                TupleContext tupleContext = insertOrUpdateTupleOperation.getTupleContext();
                if (owningEntity == null) {
                    owningEntity = this.getEntityFromTuple(tuple);
                }
                for (TupleOperation action : tuple.getOperations()) {
                    switch (action.getType()) {
                        case PUT: {
                            if (action.getValue() instanceof Character) {
                                owningEntity.set(action.getColumn(), action.getValue().toString());
                            } else {
                                owningEntity.set(action.getColumn(), (String)action.getValue());
                            }
                            toDelete.remove(action.getColumn());
                            break;
                        }
                        case REMOVE: 
                        case PUT_NULL: {
                            owningEntity.unset(action.getColumn());
                            toDelete.add(action.getColumn());
                        }
                    }
                }
                tuple.setSnapshotType(Tuple.SnapshotType.UPDATE);
                optionsContext = tupleContext.getTupleTypeContext().getOptionsContext();
                continue;
            }
            if (operation instanceof InsertOrUpdateAssociationOperation) {
                InsertOrUpdateAssociationOperation insertOrUpdateAssociationOperation = (InsertOrUpdateAssociationOperation)operation;
                associationKey = insertOrUpdateAssociationOperation.getAssociationKey();
                org.hibernate.ogm.model.spi.Association association = insertOrUpdateAssociationOperation.getAssociation();
                AssociationContext associationContext = insertOrUpdateAssociationOperation.getContext();
                Object rows = this.getAssociationRows(association, associationKey);
                RedisAssociation redisAssociation = ((RedisAssociationSnapshot)association.getSnapshot()).getRedisAssociation();
                redisAssociation.setRows(rows);
                if (this.isStoredInEntityStructure(associationKey.getMetadata(), associationContext.getAssociationTypeContext())) {
                    if (owningEntity != null) continue;
                    owningEntity = (HashEntity)redisAssociation.getOwningDocument();
                    optionsContext = associationContext.getAssociationTypeContext().getOwnerEntityOptionsContext();
                    continue;
                }
                associationsToRemove.remove(associationKey);
                String associationId = this.associationId(associationKey);
                Long ttl = this.getObjectTTL(associationId, associationContext.getAssociationTypeContext().getOptionsContext());
                this.storeAssociation(associationKey, (Association)redisAssociation.getOwningDocument());
                this.setObjectTTL(associationId, ttl);
                continue;
            }
            if (operation instanceof RemoveAssociationOperation) {
                RemoveAssociationOperation removeAssociationOperation = (RemoveAssociationOperation)operation;
                associationKey = removeAssociationOperation.getAssociationKey();
                AssociationContext associationContext = removeAssociationOperation.getContext();
                if (this.isStoredInEntityStructure(associationKey.getMetadata(), associationContext.getAssociationTypeContext())) {
                    if (owningEntity == null) {
                        TuplePointer tuplePointer = this.getEmbeddingEntityTuplePointer(associationKey, associationContext);
                        owningEntity = this.getEntityFromTuple(tuplePointer.getTuple());
                    }
                    if (owningEntity != null) {
                        owningEntity.unset(associationKey.getMetadata().getCollectionRole());
                        optionsContext = associationContext.getAssociationTypeContext().getOwnerEntityOptionsContext();
                    }
                    toDelete.add(associationKey.getMetadata().getCollectionRole());
                    continue;
                }
                associationsToRemove.add(associationKey);
                continue;
            }
            throw new IllegalStateException(operation.getClass().getSimpleName() + " not supported here");
        }
        if (owningEntity != null) {
            this.storeEntity(groupedOperation.getEntityKey(), owningEntity, optionsContext);
        }
        if (!toDelete.isEmpty()) {
            this.connection.hdel((Object)entityId, (Object[])toDelete.toArray(new String[toDelete.size()]));
        }
        if (associationsToRemove.size() > 0) {
            this.removeAssociations(associationsToRemove);
        }
    }

    private HashEntity getEntityFromTuple(Tuple tuple) {
        if (tuple == null) {
            return null;
        }
        return ((RedisHashTupleSnapshot)tuple.getSnapshot()).getEntity();
    }

    private void storeEntity(EntityKey key, HashEntity entity, OptionsContext optionsContext) {
        String entityId = this.entityId(key);
        if (!entity.isEmpty()) {
            Long currentTtl = this.getObjectTTL(entityId, optionsContext);
            this.connection.hmset((Object)entityId, entity.getProperties());
            this.setObjectTTL(entityId, currentTtl);
        }
    }

    private class RedisHashTupleIterator
    implements ClosableIterator<Tuple> {
        private final Iterator<String> iterator;
        private final EntityKeyMetadata entityKeyMetadata;
        private final RedisClusterCommands<String, String> connection;
        private final String prefix;

        public RedisHashTupleIterator(KeyScanCursor<String> cursor, RedisClusterCommands<String, String> connection, String prefix, EntityKeyMetadata entityKeyMetadata) {
            this.connection = connection;
            this.prefix = prefix;
            this.entityKeyMetadata = entityKeyMetadata;
            this.iterator = cursor.getKeys().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Tuple next() {
            String key = this.iterator.next();
            Map hgetall = this.connection.hgetall((Object)key);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(hgetall);
            RedisHashDialect.this.addKeyValuesFromKeyName(this.entityKeyMetadata, this.prefix, key, properties);
            return RedisHashDialect.createTuple(properties);
        }

        public void close() {
        }
    }

    private class RedisHashDialectTuplesSupplier
    implements TuplesSupplier {
        private final KeyScanCursor<String> cursor;
        private final RedisClusterCommands<String, String> connection;
        private final String prefix;
        private final EntityKeyMetadata entityKeyMetadata;

        public RedisHashDialectTuplesSupplier(KeyScanCursor<String> cursor, RedisClusterCommands<String, String> connection, String prefix, EntityKeyMetadata entityKeyMetadata) {
            this.cursor = cursor;
            this.connection = connection;
            this.prefix = prefix;
            this.entityKeyMetadata = entityKeyMetadata;
        }

        public ClosableIterator<Tuple> get(TransactionContext transactionContext) {
            return new RedisHashTupleIterator(this.cursor, this.connection, this.prefix, this.entityKeyMetadata);
        }
    }
}

