/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.dialect.value;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.redis.dialect.value.StructuredValue;

public class HashEntity
extends StructuredValue {
    private final Map<String, String> properties;

    public HashEntity(Map<String, String> properties) {
        this.properties = properties;
    }

    @JsonAnyGetter
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonAnySetter
    public void set(String name, String value) {
        this.properties.put(name, value);
    }

    @JsonIgnore
    public void unset(String name) {
        this.properties.remove(name);
    }

    @JsonIgnore
    public Object get(String column) {
        return this.properties.get(column);
    }

    @JsonIgnore
    public boolean has(String column) {
        return this.properties.containsKey(column);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @JsonIgnore
    public Set<String> getColumnNames() {
        return this.properties.keySet();
    }
}

