/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.LockMode;
import org.hibernate.community.dialect.CacheSqlAstTranslator;
import org.hibernate.community.dialect.identity.CacheIdentityColumnSupport;
import org.hibernate.community.dialect.sequence.CacheSequenceSupport;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadUpdateLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteUpdateLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.lock.UpdateLockingStrategy;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class CacheDialect
extends Dialect {
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"constraint (", (String)") violated", (String)sqle.getMessage()));

    public CacheDialect() {
        super((DatabaseVersion)SimpleDatabaseVersion.ZERO_VERSION);
    }

    public CacheDialect(DialectResolutionInfo info) {
        super(info);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return "bit";
            }
            case 93: 
            case 2014: {
                return "timestamp";
            }
            case 2004: {
                return "image";
            }
            case 2005: {
                return "text";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected void initDefaultProperties() {
        super.initDefaultProperties();
        this.getDefaultProperties().setProperty("hibernate.use_sql_comments", "false");
    }

    public int getDefaultStatementBatchSize() {
        return 15;
    }

    private static void useJdbcEscape(QueryEngine queryEngine, String name) {
        queryEngine.getSqmFunctionRegistry().wrapInJdbcEscape(name, queryEngine.getSqmFunctionRegistry().findFunctionDescriptor(name));
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    public int getDefaultDecimalPrecision() {
        return 19;
    }

    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(queryEngine);
        functionFactory.repeat();
        functionFactory.trim2();
        functionFactory.substr();
        functionFactory.concat_pipeOperator();
        functionFactory.cot();
        functionFactory.log10();
        functionFactory.log();
        functionFactory.pi();
        functionFactory.space();
        functionFactory.hourMinuteSecond();
        functionFactory.yearMonthDay();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.truncate();
        functionFactory.dayofweekmonthyear();
        functionFactory.repeat_replicate();
        functionFactory.datepartDatename();
        functionFactory.ascii();
        functionFactory.chr_char();
        functionFactory.nowCurdateCurtime();
        functionFactory.sysdate();
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.lastDay();
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("locate", queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER), "$find(?2,?1)", "$find(?2,?1,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, queryEngine.getTypeConfiguration()).setArgumentListSignature("(pattern, string[, start])");
        functionFactory.bitLength_pattern("($length(?1)*8)");
        CacheDialect.useJdbcEscape(queryEngine, "sin");
        CacheDialect.useJdbcEscape(queryEngine, "cos");
        CacheDialect.useJdbcEscape(queryEngine, "tan");
        CacheDialect.useJdbcEscape(queryEngine, "asin");
        CacheDialect.useJdbcEscape(queryEngine, "acos");
        CacheDialect.useJdbcEscape(queryEngine, "atan");
        CacheDialect.useJdbcEscape(queryEngine, "atan2");
        CacheDialect.useJdbcEscape(queryEngine, "exp");
        CacheDialect.useJdbcEscape(queryEngine, "log");
        CacheDialect.useJdbcEscape(queryEngine, "log10");
        CacheDialect.useJdbcEscape(queryEngine, "pi");
        CacheDialect.useJdbcEscape(queryEngine, "truncate");
        CacheDialect.useJdbcEscape(queryEngine, "left");
        CacheDialect.useJdbcEscape(queryEngine, "right");
        CacheDialect.useJdbcEscape(queryEngine, "hour");
        CacheDialect.useJdbcEscape(queryEngine, "minute");
        CacheDialect.useJdbcEscape(queryEngine, "second");
        CacheDialect.useJdbcEscape(queryEngine, "week");
        CacheDialect.useJdbcEscape(queryEngine, "quarter");
        CacheDialect.useJdbcEscape(queryEngine, "dayname");
        CacheDialect.useJdbcEscape(queryEngine, "monthname");
        CacheDialect.useJdbcEscape(queryEngine, "dayofweek");
        CacheDialect.useJdbcEscape(queryEngine, "dayofmonth");
        CacheDialect.useJdbcEscape(queryEngine, "dayofyear");
    }

    public String extractPattern(TemporalUnit unit) {
        return "datepart(?1,?2)";
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "dateadd(millisecond,(?2)/1e6,?3)";
            }
        }
        return "dateadd(?1,?2,?3)";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "datediff(millisecond,?2,?3)*1e6";
            }
        }
        return "datediff(?1,?2,?3)";
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        return new StringBuilder(300).append(" ADD CONSTRAINT ").append(constraintName).append(" FOREIGN KEY ").append(constraintName).append(" (").append(String.join((CharSequence)", ", foreignKey)).append(") REFERENCES ").append(referencedTable).append(" (").append(String.join((CharSequence)", ", primaryKey)).append(") ").toString();
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return true;
    }

    public String getNativeIdentifierGeneratorStrategy() {
        return "identity";
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return new CacheIdentityColumnSupport();
    }

    public SequenceSupport getSequenceSupport() {
        return CacheSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return "select name from InterSystems.Sequences";
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: {
                return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_WRITE: {
                return new PessimisticWriteUpdateLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_READ: {
                return new PessimisticReadUpdateLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC: {
                return new OptimisticLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
        }
        if (lockMode.greaterThan(LockMode.READ)) {
            return new UpdateLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new CacheSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public LimitHandler getLimitHandler() {
        return TopLimitHandler.INSTANCE;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) {
        return col;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public String getNullColumnString() {
        return " null";
    }

    public String getNoColumnsInsertString() {
        return " default values";
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlStateClassCode = JdbcExceptionHelper.extractSqlStateClassCode((SQLException)sqlException);
            if (sqlStateClassCode != null) {
                int errorCode = JdbcExceptionHelper.extractErrorCode((SQLException)sqlException);
                if (errorCode >= 119 && errorCode <= 127 && errorCode != 126) {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                if (sqlStateClassCode.equals("22") || sqlStateClassCode.equals("21") || sqlStateClassCode.equals("02")) {
                    return new DataException(message, sqlException, sql);
                }
            }
            return null;
        };
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public boolean supportsOrderByInSubquery() {
        return false;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat((String)format, (boolean)false, (boolean)false).result());
    }
}

