/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class FirebirdSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private boolean inFunction;

    public FirebirdSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        if (this.getDialect().getVersion().isSameOrAfter(3)) {
            boolean isNegated = booleanExpressionPredicate.isNegated();
            if (isNegated) {
                this.appendSql("not(");
            }
            booleanExpressionPredicate.getExpression().accept((SqlAstWalker)this);
            if (isNegated) {
                this.appendSql(')');
            }
        } else {
            super.visitBooleanExpressionPredicate(booleanExpressionPredicate);
        }
    }

    protected String getForUpdate() {
        return " with lock";
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.getDialect().getVersion().isSameOrAfter(3) && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitSelectClause(SelectClause selectClause) {
        Stack clauseStack = this.getClauseStack();
        clauseStack.push((Object)Clause.SELECT);
        try {
            this.appendSql("select ");
            this.visitSqlSelections(selectClause);
        }
        finally {
            clauseStack.pop();
        }
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        if (!this.supportsOffsetFetchClause()) {
            this.renderFirstSkipClause((QuerySpec)this.getQueryPartStack().getCurrent());
        }
        if (selectClause.isDistinct()) {
            this.appendSql("distinct ");
        }
        super.visitSqlSelections(selectClause);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.supportsOffsetFetchClause() && !this.isRowNumberingCurrentQueryPart()) {
            this.renderOffsetFetchClause(queryPart, true);
        }
    }

    protected void renderSearchClause(CteStatement cte) {
    }

    protected void renderCycleClause(CteStatement cte) {
    }

    protected boolean supportsSimpleQueryGrouping() {
        return false;
    }

    protected void renderSelectExpression(Expression expression) {
        this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    protected String getFromDual() {
        return " from rdb$database";
    }

    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion().isSameOrAfter(3);
    }

    public void visitSelfRenderingPredicate(SelfRenderingPredicate selfRenderingPredicate) {
        boolean inFunction = this.inFunction;
        this.inFunction = true;
        try {
            super.visitSelfRenderingPredicate(selfRenderingPredicate);
        }
        finally {
            this.inFunction = inFunction;
        }
    }

    public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
        boolean inFunction = this.inFunction;
        this.inFunction = !(expression instanceof FunctionExpression) || !"cast".equals(((FunctionExpression)expression).getFunctionName());
        try {
            super.visitSelfRenderingExpression(expression);
        }
        finally {
            this.inFunction = inFunction;
        }
    }

    public void visitParameter(JdbcParameter jdbcParameter) {
        if (this.inFunction) {
            this.inFunction = false;
            try {
                this.renderCasted((Expression)jdbcParameter);
            }
            finally {
                this.inFunction = true;
            }
        } else {
            super.visitParameter(jdbcParameter);
        }
    }

    public void visitJdbcLiteral(JdbcLiteral<?> jdbcLiteral) {
        this.visitLiteral((Literal)jdbcLiteral);
    }

    public void visitQueryLiteral(QueryLiteral<?> queryLiteral) {
        this.visitLiteral((Literal)queryLiteral);
    }

    private void visitLiteral(Literal literal) {
        if (literal.getLiteralValue() == null) {
            this.appendSql("null");
        } else {
            this.renderLiteral(literal, this.inFunction);
        }
    }
}

