/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;

public class SkipFirstLimitHandler
extends AbstractLimitHandler {
    public static final SkipFirstLimitHandler INSTANCE = new SkipFirstLimitHandler(true);
    private final boolean variableLimit;

    public SkipFirstLimitHandler(boolean variableLimit) {
        this.variableLimit = variableLimit;
    }

    public String processSql(String sql, Limit limit) {
        boolean hasFirstRow = SkipFirstLimitHandler.hasFirstRow((Limit)limit);
        boolean hasMaxRows = SkipFirstLimitHandler.hasMaxRows((Limit)limit);
        if (!hasFirstRow && !hasMaxRows) {
            return sql;
        }
        StringBuilder skipFirst = new StringBuilder();
        if (this.supportsVariableLimit()) {
            if (hasFirstRow) {
                skipFirst.append(" skip ?");
            }
            if (hasMaxRows) {
                skipFirst.append(" first ?");
            }
        } else {
            if (hasFirstRow) {
                skipFirst.append(" skip ").append(limit.getFirstRow());
            }
            if (hasMaxRows) {
                skipFirst.append(" first ").append(this.getMaxOrLimit(limit));
            }
        }
        return SkipFirstLimitHandler.insertAfterSelect((String)sql, (String)skipFirst.toString());
    }

    public final boolean supportsLimit() {
        return true;
    }

    public boolean supportsOffset() {
        return true;
    }

    public final boolean bindLimitParametersFirst() {
        return true;
    }

    public final boolean supportsVariableLimit() {
        return this.variableLimit;
    }
}

