/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.IngresSqlAstTranslator;
import org.hibernate.community.dialect.IngresSqmToSqlAstConverter;
import org.hibernate.community.dialect.identity.Ingres10IdentityColumnSupport;
import org.hibernate.community.dialect.identity.Ingres9IdentityColumnSupport;
import org.hibernate.community.dialect.pagination.FirstLimitHandler;
import org.hibernate.community.dialect.pagination.IngresLimitHandler;
import org.hibernate.community.dialect.sequence.IngresLegacySequenceSupport;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.ANSISequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceNameExtractorImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class IngresDialect
extends Dialect {
    private final LimitHandler limitHandler;
    private final SequenceSupport sequenceSupport;

    public IngresDialect() {
        this(DatabaseVersion.make((Integer)9, (Integer)2));
    }

    public IngresDialect(DialectResolutionInfo info) {
        this(info.makeCopy());
        this.registerKeywords(info);
    }

    public IngresDialect(DatabaseVersion version) {
        super(version);
        if (this.getVersion().isSameOrAfter(9, 3)) {
            this.limitHandler = IngresLimitHandler.INSTANCE;
            this.sequenceSupport = ANSISequenceSupport.INSTANCE;
        } else {
            this.limitHandler = FirstLimitHandler.INSTANCE;
            this.sequenceSupport = IngresLegacySequenceSupport.INSTANCE;
        }
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return this.getVersion().isBefore(10) ? "tinyint" : super.columnType(sqlTypeCode);
            }
            case 91: {
                return this.getVersion().isBefore(10) && this.getVersion().isSameOrAfter(9, 3) ? "ansidate" : super.columnType(sqlTypeCode);
            }
            case 2: {
                return this.castType(3);
            }
            case -2: {
                return "byte($l)";
            }
            case -3: {
                return "varbyte($l)";
            }
            case 2004: {
                return "long byte($l)";
            }
            case 2005: {
                return "long varchar($l)";
            }
            case 2011: {
                return "long nvarchar($l)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    public boolean getDefaultUseGetGeneratedKeys() {
        return false;
    }

    public int getMaxVarcharLength() {
        return 32000;
    }

    public int getMaxNVarcharLength() {
        return 16000;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return this.getVersion().isBefore(10) ? -7 : 16;
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        if (this.getVersion().isBefore(10)) {
            appender.appendSql(bool ? (char)'1' : '0');
        } else {
            appender.appendSql(bool);
        }
    }

    public int getDefaultDecimalPrecision() {
        return 39;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        BasicType stringType = basicTypeRegistry.resolve(StandardBasicTypes.STRING);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.log();
        functionFactory.rand();
        functionFactory.soundex();
        functionFactory.octetLength();
        functionFactory.repeat();
        functionFactory.trim2();
        functionFactory.dateTrunc();
        functionFactory.trunc_dateTrunc();
        functionFactory.initcap();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.lastDay();
        functionFactory.concat_pipeOperator();
        functionFactory.substr();
        functionFactory.monthsBetween();
        functionFactory.substring_substr();
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.sysdate();
        functionFactory.position();
        functionFactory.format_dateFormat();
        functionFactory.bitLength_pattern("octet_length(hex(?1))*4");
        BasicType integerType = functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("locate", integerType, "position(?1 in ?2)", "(position(?1 in substring(?2 from ?3))+(?3)-1)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, functionContributions.getTypeConfiguration()).setArgumentListSignature("(pattern, string[, start])");
        functionContributions.getFunctionRegistry().registerPattern("extract", "date_part('?1',?2)", integerType);
        functionFactory.bitandorxornot_bitAndOrXorNot();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("squeeze").setExactArgumentCount(1).setInvariantType(stringType).register();
        functionFactory.windowFunctions();
        functionFactory.listagg(null);
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory(){

            public SqmTranslator<SelectStatement> createSelectTranslator(SqmSelectStatement<?> sqmSelectStatement, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationContext creationContext, boolean deduplicateSelectionItems) {
                return new IngresSqmToSqlAstConverter((SqmStatement<?>)sqmSelectStatement, queryOptions, domainParameterXref, domainParameterBindings, loadQueryInfluencers, creationContext, deduplicateSelectionItems);
            }
        };
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new IngresSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return "timestampadd(?1,?2,?3)";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return "timestampdiff(?1,?2,?3)";
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NATIVE;
    }

    public String getSelectGUIDString() {
        return "select uuid_to_char(uuid_create())";
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getNullColumnString() {
        return " with null";
    }

    public SequenceSupport getSequenceSupport() {
        return this.sequenceSupport;
    }

    public String getQuerySequencesString() {
        return this.getVersion().isBefore(9, 3) ? "select seq_name from iisequence" : "select seq_name from iisequences";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceNameExtractorImpl.INSTANCE;
    }

    public String getLowercaseFunction() {
        return "lowercase";
    }

    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        if (this.getVersion().isSameOrAfter(10)) {
            return new Ingres10IdentityColumnSupport();
        }
        if (this.getVersion().isSameOrAfter(9, 3)) {
            return new Ingres9IdentityColumnSupport();
        }
        return super.getIdentityColumnSupport();
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return this.getVersion().isSameOrAfter(9, 3);
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)rootEntityDescriptor, name -> "session.HT_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)rootEntityDescriptor, name -> "session.HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    public String getTemporaryTableCreateOptions() {
        return "on commit preserve rows with norecovery";
    }

    public String getTemporaryTableCreateCommand() {
        return "declare global temporary table";
    }

    public boolean supportsUnionAll() {
        return this.getVersion().isSameOrAfter(9, 3);
    }

    public boolean supportsUnionInSubquery() {
        return false;
    }

    public boolean supportsSubqueryInSelect() {
        return this.getVersion().isSameOrAfter(10);
    }

    public boolean supportsOrderByInSubquery() {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return this.getVersion().isSameOrAfter(10, 2);
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return this.getVersion().isSameOrAfter(9, 3);
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return this.getVersion().isSameOrAfter(9, 3);
    }

    public boolean supportsSubselectAsInPredicateLHS() {
        return false;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return false;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(MySQLDialect.datetimeFormat((String)format).result());
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "doy";
            }
            case DAY_OF_WEEK: {
                return "dow";
            }
            case WEEK: {
                return "iso_week";
            }
        }
        return super.translateExtractField(unit);
    }

    public boolean supportsFetchClause(FetchClauseType type) {
        return this.getVersion().isSameOrAfter(9, 3);
    }
}

