/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableGroup;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class OracleLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public OracleLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean needsRecursiveKeywordInWithClause() {
        return false;
    }

    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    protected boolean supportsRecursiveSearchClause() {
        return true;
    }

    protected boolean supportsRecursiveCycleClause() {
        return true;
    }

    public void visitSqlSelection(SqlSelection sqlSelection) {
        if (this.getCurrentCteStatement() != null && this.getCurrentCteStatement().getMaterialization() == CteMaterialization.MATERIALIZED) {
            this.appendSql("/*+ materialize */ ");
        }
        super.visitSqlSelection(sqlSelection);
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        AbstractSqlAstTranslator.LockStrategy strategy = super.determineLockingStrategy(querySpec, forUpdateClause, followOnLocking);
        boolean followOnLockingDisabled = Boolean.FALSE.equals(followOnLocking);
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.isPartOfQueryGroup()) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.hasSetOperations(querySpec)) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.needsLockingWrapper(querySpec) && !this.canApplyLockingWrapper(querySpec)) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with OFFSET/FETCH is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        return strategy;
    }

    private boolean hasSetOperations(QuerySpec querySpec) {
        return querySpec.getFromClause().queryTableGroups(group -> group instanceof UnionTableGroup ? group : null) != null;
    }

    private boolean isPartOfQueryGroup() {
        return this.getQueryPartStack().findCurrentFirst(part -> part instanceof QueryGroup ? part : null) != null;
    }

    protected boolean shouldEmulateLateralWithIntersect(QueryPart queryPart) {
        return !queryPart.hasOffsetOrFetchClause();
    }

    protected boolean supportsNestedSubqueryCorrelation() {
        return false;
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        boolean hasLimit;
        if (this.getQueryPartForRowNumbering() == queryPart) {
            return false;
        }
        boolean bl = hasLimit = queryPart.isRoot() && this.hasLimit() || queryPart.getFetchClauseExpression() != null || queryPart.getOffsetClauseExpression() != null;
        if (!hasLimit) {
            return false;
        }
        if (this.supportsOffsetFetchClause()) {
            return queryPart instanceof QueryGroup && this.getClauseStack().isEmpty() && this.getStatement() instanceof InsertSelectStatement;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitOrderBy(List<SortSpecification> sortSpecifications) {
        QuerySpec querySpec;
        QueryPart queryPartForRowNumbering = this.getQueryPartForRowNumbering();
        if (queryPartForRowNumbering == null) {
            this.renderOrderBy(true, sortSpecifications);
        } else if (!(this.getFetchClauseTypeForRowNumbering(queryPartForRowNumbering) != null || (querySpec = (QuerySpec)queryPartForRowNumbering).getOffsetClauseExpression() != null || querySpec.isRoot() && this.getOffsetParameter() != null)) {
            if (this.hasGroupingOrDistinct(querySpec) || querySpec.getFromClause().hasJoins()) {
                this.renderOrderBy(true, sortSpecifications);
            } else {
                Predicate whereClauseRestrictions = querySpec.getWhereClauseRestrictions();
                if (whereClauseRestrictions != null && !whereClauseRestrictions.isEmpty()) {
                    this.appendSql(" and ");
                } else {
                    this.appendSql(" where ");
                }
                this.appendSql("rownum<=");
                Stack clauseStack = this.getClauseStack();
                clauseStack.push((Object)Clause.WHERE);
                try {
                    if (querySpec.isRoot() && this.hasLimit()) {
                        this.getLimitParameter().accept((SqlAstWalker)this);
                    } else {
                        querySpec.getFetchClauseExpression().accept((SqlAstWalker)this);
                    }
                }
                finally {
                    clauseStack.pop();
                }
                this.renderOrderBy(true, sortSpecifications);
                this.visitForUpdateClause(querySpec);
            }
        }
    }

    private boolean hasGroupingOrDistinct(QuerySpec querySpec) {
        return querySpec.getSelectClause().isDistinct() || !querySpec.getGroupByClauseExpressions().isEmpty() || querySpec.getHavingClauseRestrictions() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitValuesList(List<Values> valuesList) {
        if (valuesList.size() < 2) {
            super.visitValuesList(valuesList);
        } else {
            String separator = "";
            Stack clauseStack = this.getClauseStack();
            try {
                clauseStack.push((Object)Clause.VALUES);
                for (Values values : valuesList) {
                    this.appendSql(separator);
                    this.renderExpressionsAsSubquery(values.getExpressions());
                    separator = " union all ";
                }
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    public void visitFunctionTableReference(FunctionTableReference tableReference) {
        this.append("table(");
        tableReference.getFunctionExpression().accept((SqlAstWalker)this);
        this.append(')');
        this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        FetchClauseType fetchClauseType;
        Expression fetchExpression;
        Expression offsetExpression;
        EntityIdentifierMapping identifierMappingForLockingWrapper = this.identifierMappingForLockingWrapper(querySpec);
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            offsetExpression = this.getOffsetParameter();
            fetchExpression = this.getLimitParameter();
            fetchClauseType = FetchClauseType.ROWS_ONLY;
        } else {
            offsetExpression = querySpec.getOffsetClauseExpression();
            fetchExpression = querySpec.getFetchClauseExpression();
            fetchClauseType = querySpec.getFetchClauseType();
        }
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            if (identifierMappingForLockingWrapper == null) {
                this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, offsetExpression, fetchExpression, fetchClauseType, true);
            } else {
                super.visitQuerySpec(this.createLockingWrapper(querySpec, offsetExpression, fetchExpression, fetchClauseType, identifierMappingForLockingWrapper));
                this.visitForUpdateClause(querySpec);
            }
        } else if (identifierMappingForLockingWrapper == null) {
            super.visitQuerySpec(querySpec);
        } else {
            super.visitQuerySpec(this.createLockingWrapper(querySpec, offsetExpression, fetchExpression, fetchClauseType, identifierMappingForLockingWrapper));
            this.visitForUpdateClause(querySpec);
        }
    }

    private QuerySpec createLockingWrapper(QuerySpec querySpec, Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, EntityIdentifierMapping identifierMappingForLockingWrapper) {
        TableGroup rootTableGroup = (TableGroup)querySpec.getFromClause().getRoots().get(0);
        ArrayList idColumnReferences = new ArrayList(identifierMappingForLockingWrapper.getJdbcTypeCount());
        identifierMappingForLockingWrapper.forEachSelectable(0, (selectionIndex, selectableMapping) -> idColumnReferences.add(new ColumnReference(rootTableGroup.getPrimaryTableReference(), selectableMapping)));
        Object idExpression = identifierMappingForLockingWrapper instanceof EmbeddableValuedModelPart ? new SqlTuple(idColumnReferences, (MappingModelExpressible)identifierMappingForLockingWrapper) : (Expression)idColumnReferences.get(0);
        QuerySpec subquery = new QuerySpec(false, 1);
        for (ColumnReference idColumnReference : idColumnReferences) {
            subquery.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl((Expression)idColumnReference));
        }
        subquery.getFromClause().addRoot(rootTableGroup);
        subquery.applyPredicate(querySpec.getWhereClauseRestrictions());
        if (querySpec.hasSortSpecifications()) {
            for (SortSpecification sortSpecification : querySpec.getSortSpecifications()) {
                subquery.addSortSpecification(sortSpecification);
            }
        }
        subquery.setOffsetClauseExpression(offsetExpression);
        subquery.setFetchClauseExpression(fetchExpression, fetchClauseType);
        QuerySpec lockingWrapper = new QuerySpec(false, 1);
        lockingWrapper.getFromClause().addRoot(rootTableGroup);
        for (SqlSelection sqlSelection : querySpec.getSelectClause().getSqlSelections()) {
            lockingWrapper.getSelectClause().addSqlSelection(sqlSelection);
        }
        lockingWrapper.applyPredicate((Predicate)new InSubQueryPredicate(idExpression, (QueryPart)subquery, false));
        return lockingWrapper;
    }

    private EntityIdentifierMapping identifierMappingForLockingWrapper(QuerySpec querySpec) {
        if (this.canApplyLockingWrapper(querySpec) && this.needsLocking(querySpec) && this.needsLockingWrapper(querySpec) && querySpec.getGroupByClauseExpressions().isEmpty() && querySpec.getHavingClauseRestrictions() == null && !querySpec.getSelectClause().isDistinct() && !this.hasAggregateFunctions(querySpec)) {
            return ((EntityMappingType)((TableGroup)querySpec.getFromClause().getRoots().get(0)).getModelPart()).getIdentifierMapping();
        }
        return null;
    }

    private boolean canApplyLockingWrapper(QuerySpec querySpec) {
        FromClause fromClause;
        return querySpec.isRoot() && (fromClause = querySpec.getFromClause()).getRoots().size() == 1 && !fromClause.hasJoins() && ((TableGroup)fromClause.getRoots().get(0)).getModelPart() instanceof EntityMappingType;
    }

    private boolean needsLockingWrapper(QuerySpec querySpec) {
        return querySpec.getFetchClauseType() != FetchClauseType.ROWS_ONLY || this.hasOffset((QueryPart)querySpec) || this.hasLimit((QueryPart)querySpec);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.supportsOffsetFetchClause()) {
                if (this.getQueryPartStack().depth() > 1 && queryPart.hasSortSpecifications() && this.getQueryPartStack().peek(1) instanceof QueryGroup && (queryPart.isRoot() && !this.hasLimit() || !queryPart.hasOffsetOrFetchClause())) {
                    this.appendSql(" offset 0 rows");
                } else {
                    this.renderOffsetFetchClause(queryPart, true);
                }
            } else {
                this.assertRowsOnlyFetchClauseType(queryPart);
            }
        }
    }

    protected void renderRowNumber(SelectClause selectClause, QueryPart queryPart) {
        if (!queryPart.hasSortSpecifications()) {
            this.appendSql("rownum");
        } else {
            super.renderRowNumber(selectClause, queryPart);
        }
    }

    public void visitOver(Over<?> over) {
        Expression expression = over.getExpression();
        if (expression instanceof FunctionExpression && "row_number".equals(((FunctionExpression)expression).getFunctionName()) && over.getPartitions().isEmpty() && over.getOrderList().isEmpty() && over.getStartKind() == FrameKind.UNBOUNDED_PRECEDING && over.getEndKind() == FrameKind.CURRENT_ROW && over.getExclusion() == FrameExclusion.NO_OTHERS) {
            this.append("row_number() over(order by 1)");
            return;
        }
        super.visitOver(over);
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType == null || lhsExpressionType.getJdbcTypeCount() != 1) {
            this.renderComparisonEmulateDecode(lhs, operator, rhs);
            return;
        }
        switch (lhsExpressionType.getSingleJdbcMapping().getJdbcType().getDdlTypeCode()) {
            case 2009: {
                switch (operator) {
                    case EQUAL: 
                    case NOT_DISTINCT_FROM: {
                        this.appendSql("0=");
                        break;
                    }
                    case NOT_EQUAL: 
                    case DISTINCT_FROM: {
                        this.appendSql("1=");
                        break;
                    }
                    default: {
                        this.renderComparisonEmulateDecode(lhs, operator, rhs);
                        return;
                    }
                }
                this.appendSql("existsnode(xmldiff(");
                lhs.accept((SqlAstWalker)this);
                this.appendSql(',');
                rhs.accept((SqlAstWalker)this);
                this.appendSql("),'/*[local-name()=''xdiff'']/*')");
                break;
            }
            case 2004: 
            case 2005: 
            case 2011: {
                switch (operator) {
                    case EQUAL: {
                        this.appendSql("0=");
                        break;
                    }
                    case NOT_EQUAL: {
                        this.appendSql("-1=");
                        break;
                    }
                    default: {
                        this.renderComparisonEmulateDecode(lhs, operator, rhs);
                        return;
                    }
                }
                this.appendSql("dbms_lob.compare(");
                lhs.accept((SqlAstWalker)this);
                this.appendSql(',');
                rhs.accept((SqlAstWalker)this);
                this.appendSql(')');
                break;
            }
            default: {
                this.renderComparisonEmulateDecode(lhs, operator, rhs);
            }
        }
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, boolean inSelect) {
        if (this.getDialect().getVersion().isBefore(9)) {
            this.visitDecodeCaseSearchedExpression(caseSearchedExpression);
        } else {
            super.visitCaseSearchedExpression(caseSearchedExpression, inSelect);
        }
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept((SqlAstWalker)this);
        }
    }

    protected boolean supportsDuplicateSelectItemsInQueryGroup() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return this.getDialect().getVersion().isSameOrAfter(8, 2);
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInSubQuery() {
        return this.getDialect().getVersion().isSameOrAfter(9);
    }

    protected String getFromDual() {
        return " from dual";
    }

    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().supportsFetchClause(FetchClauseType.ROWS_ONLY);
    }

    protected void visitSetAssignment(Assignment assignment) {
        List columnReferences = assignment.getAssignable().getColumnReferences();
        if (columnReferences.size() == 1) {
            ((ColumnReference)columnReferences.get(0)).appendColumnForWrite((SqlAppender)this);
            this.appendSql('=');
            Expression assignedValue = assignment.getAssignedValue();
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple((SqlAstNode)assignedValue);
            if (sqlTuple != null) {
                assert (sqlTuple.getExpressions().size() == 1);
                ((Expression)sqlTuple.getExpressions().get(0)).accept((SqlAstWalker)this);
            } else {
                assignedValue.accept((SqlAstWalker)this);
            }
        } else {
            int separator = 40;
            for (ColumnReference columnReference : columnReferences) {
                this.appendSql((char)separator);
                columnReference.appendColumnForWrite((SqlAppender)this);
                separator = 44;
            }
            this.appendSql(")=");
            assignment.getAssignedValue().accept((SqlAstWalker)this);
        }
    }
}

