/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DerbyLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public DerbyLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean supportsWithClause() {
        return false;
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept((SqlAstWalker)this);
    }

    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept((SqlAstWalker)this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = ((CaseSearchedExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = ((CaseSimpleExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    protected String getForUpdate() {
        return " for update";
    }

    protected String getForShare(int timeoutMillis) {
        return " for read only";
    }

    protected String getForUpdateWithClause() {
        return " with rs";
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        this.assertRowsOnlyFetchClauseType(queryPart);
        if (this.supportsOffsetFetchClause()) {
            this.renderOffsetFetchClause(queryPart, true);
        } else if (!this.getClauseStack().isEmpty()) {
            throw new IllegalArgumentException("Can't render offset and fetch clause for subquery");
        }
    }

    protected void renderFetchExpression(Expression fetchExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderFetchExpression(fetchExpression);
        } else {
            this.renderExpressionAsLiteral(fetchExpression, this.getJdbcParameterBindings());
        }
    }

    protected void renderOffsetExpression(Expression offsetExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderOffsetExpression(offsetExpression);
        } else {
            this.renderExpressionAsLiteral(offsetExpression, this.getJdbcParameterBindings());
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    protected void renderSelectExpression(Expression expression) {
        this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0'");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitInListPredicate(InListPredicate inListPredicate) {
        List listExpressions = inListPredicate.getListExpressions();
        if (listExpressions.isEmpty()) {
            this.appendSql("1=0");
            return;
        }
        Expression testExpression = inListPredicate.getTestExpression();
        if (this.isParameter(testExpression)) {
            this.renderCasted(testExpression);
            if (inListPredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" in (");
            this.renderCommaSeparated(listExpressions);
            this.appendSql(')');
        } else {
            super.visitInListPredicate(inListPredicate);
        }
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    protected String getFromDual() {
        return " from (values 0) dual";
    }

    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    protected boolean needsRowsToSkip() {
        return !this.supportsOffsetFetchClause();
    }

    protected boolean needsMaxRows() {
        return !this.supportsOffsetFetchClause();
    }

    private boolean supportsParameterOffsetFetchExpression() {
        return this.getDialect().getVersion().isSameOrAfter(10, 6);
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion().isSameOrAfter(10, 5);
    }

    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        BinaryArithmeticOperator operator = arithmeticExpression.getOperator();
        if (operator == BinaryArithmeticOperator.MODULO) {
            this.append("mod");
            this.appendSql('(');
            arithmeticExpression.getLeftHandOperand().accept((SqlAstWalker)this);
            this.appendSql(',');
            arithmeticExpression.getRightHandOperand().accept((SqlAstWalker)this);
            this.appendSql(')');
        } else {
            this.appendSql('(');
            this.render((SqlAstNode)arithmeticExpression.getLeftHandOperand(), SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
            this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
            this.render((SqlAstNode)arithmeticExpression.getRightHandOperand(), SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
            this.appendSql(')');
        }
    }
}

