/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.OracleLegacySqlAstTranslator;
import org.hibernate.dialect.BooleanDecoder;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.OracleBooleanJdbcType;
import org.hibernate.dialect.OracleJdbcHelper;
import org.hibernate.dialect.OracleJsonJdbcType;
import org.hibernate.dialect.OracleReflectionStructJdbcType;
import org.hibernate.dialect.OracleXmlJdbcType;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.OracleAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.ModeStatsModeEmulation;
import org.hibernate.dialect.function.NvlCoalesceEmulation;
import org.hibernate.dialect.function.OracleTruncFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.Oracle12cIdentityColumnSupport;
import org.hibernate.dialect.pagination.LegacyOracleLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.Oracle12LimitHandler;
import org.hibernate.dialect.sequence.OracleSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.SemanticException;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorOracleDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.BasicType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.NullType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.NullJdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsNullTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.OracleJsonBlobJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleLegacyDialect
extends Dialect {
    private static final Pattern DISTINCT_KEYWORD_PATTERN = Pattern.compile("\\bdistinct\\b");
    private static final Pattern GROUP_BY_KEYWORD_PATTERN = Pattern.compile("\\bgroup\\sby\\b");
    private static final Pattern ORDER_BY_KEYWORD_PATTERN = Pattern.compile("\\border\\sby\\b");
    private static final Pattern UNION_KEYWORD_PATTERN = Pattern.compile("\\bunion\\b");
    private static final Pattern SQL_STATEMENT_TYPE_PATTERN = Pattern.compile("^(?:/\\*.*?\\*/)?\\s*(select|insert|update|delete)\\s+.*?", 2);
    private static final int PARAM_LIST_SIZE_LIMIT = 1000;
    public static final String PREFER_LONG_RAW = "hibernate.dialect.oracle.prefer_long_raw";
    private static final String yqmSelect = "( TRUNC(%2$s, 'MONTH') + NUMTOYMINTERVAL(%1$s, 'MONTH') + ( LEAST( EXTRACT( DAY FROM %2$s ), EXTRACT( DAY FROM LAST_DAY( TRUNC(%2$s, 'MONTH') + NUMTOYMINTERVAL(%1$s, 'MONTH') ) ) ) - 1 ) )";
    private static final String ADD_YEAR_EXPRESSION = String.format("( TRUNC(%2$s, 'MONTH') + NUMTOYMINTERVAL(%1$s, 'MONTH') + ( LEAST( EXTRACT( DAY FROM %2$s ), EXTRACT( DAY FROM LAST_DAY( TRUNC(%2$s, 'MONTH') + NUMTOYMINTERVAL(%1$s, 'MONTH') ) ) ) - 1 ) )", "?2*12", "?3");
    private static final String ADD_QUARTER_EXPRESSION = String.format("( TRUNC(%2$s, 'MONTH') + NUMTOYMINTERVAL(%1$s, 'MONTH') + ( LEAST( EXTRACT( DAY FROM %2$s ), EXTRACT( DAY FROM LAST_DAY( TRUNC(%2$s, 'MONTH') + NUMTOYMINTERVAL(%1$s, 'MONTH') ) ) ) - 1 ) )", "?2*3", "?3");
    private static final String ADD_MONTH_EXPRESSION = String.format("( TRUNC(%2$s, 'MONTH') + NUMTOYMINTERVAL(%1$s, 'MONTH') + ( LEAST( EXTRACT( DAY FROM %2$s ), EXTRACT( DAY FROM LAST_DAY( TRUNC(%2$s, 'MONTH') + NUMTOYMINTERVAL(%1$s, 'MONTH') ) ) ) - 1 ) )", "?2", "?3");
    private final LimitHandler limitHandler = this.supportsFetchClause(FetchClauseType.ROWS_ONLY) ? Oracle12LimitHandler.INSTANCE : new LegacyOracleLimitHandler(this.getVersion());
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate((Dialect)this);
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        switch (JdbcExceptionHelper.extractErrorCode((SQLException)sqle)) {
            case 1: 
            case 2291: 
            case 2292: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"(", (String)")", (String)sqle.getMessage());
            }
            case 1400: {
                return null;
            }
        }
        return null;
    });

    public OracleLegacyDialect() {
        this(DatabaseVersion.make((Integer)8, (Integer)0));
    }

    public OracleLegacyDialect(DatabaseVersion version) {
        super(version);
    }

    public OracleLegacyDialect(DialectResolutionInfo info) {
        super(info);
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.log();
        functionFactory.log10_log();
        functionFactory.soundex();
        functionFactory.trim2();
        functionFactory.initcap();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.leftRight_substr();
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.lastDay();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.ceiling_ceil();
        functionFactory.concat_pipeOperator();
        functionFactory.rownumRowid();
        functionFactory.sysdate();
        functionFactory.systimestamp();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
        functionFactory.everyAny_minMaxCase();
        functionFactory.radians_acos();
        functionFactory.degrees_acos();
        functionFactory.median();
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.covarPopSamp();
        functionFactory.corr();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.characterLength_length("dbms_lob.getlength(?1)");
        functionFactory.octetLength_pattern("lengthb(?1)", "dbms_lob.getlength(?1)*2");
        functionFactory.bitLength_pattern("lengthb(?1)*8", "dbms_lob.getlength(?1)*16");
        if (this.getVersion().isBefore(9)) {
            functionContributions.getFunctionRegistry().register("coalesce", (SqmFunctionDescriptor)new NvlCoalesceEmulation());
        } else {
            functionFactory.coalesce();
        }
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("locate", typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER), "instr(?2,?1)", "instr(?2,?1,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, typeConfiguration).setArgumentListSignature("(pattern, string[, start])");
        if (this.getVersion().isSameOrAfter(18)) {
            functionFactory.listagg(null);
        } else {
            functionFactory.listagg("within group (order by rownum)");
        }
        functionFactory.windowFunctions();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionContributions.getFunctionRegistry().register("mode", (SqmFunctionDescriptor)new ModeStatsModeEmulation(typeConfiguration));
        functionContributions.getFunctionRegistry().register("trunc", (SqmFunctionDescriptor)new OracleTruncFunction(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
    }

    public int getMaxVarcharLength() {
        return 4000;
    }

    public int getMaxVarbinaryLength() {
        return 2000;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new OracleLegacySqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public String currentDate() {
        return this.getVersion().isBefore(9) ? this.currentTimestamp() : "current_date";
    }

    public String currentTime() {
        return this.currentTimestamp();
    }

    public String currentTimestamp() {
        return this.getVersion().isBefore(9) ? "sysdate" : this.currentTimestampWithTimeZone();
    }

    public String currentLocalTime() {
        return this.currentLocalTimestamp();
    }

    public String currentLocalTimestamp() {
        return this.getVersion().isBefore(9) ? this.currentTimestamp() : "localtimestamp";
    }

    public String currentTimestampWithTimeZone() {
        return this.getVersion().isBefore(9) ? this.currentTimestamp() : "current_timestamp";
    }

    public boolean supportsInsertReturningGeneratedKeys() {
        return this.getVersion().isSameOrAfter(12);
    }

    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case INTEGER: 
            case LONG: {
                String result = BooleanDecoder.toInteger((CastType)from);
                if (result == null) break;
                return result;
            }
            case INTEGER_BOOLEAN: {
                String result = BooleanDecoder.toIntegerBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case YN_BOOLEAN: {
                String result = BooleanDecoder.toYesNoBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case TF_BOOLEAN: 
            case BOOLEAN: {
                String result = BooleanDecoder.toTrueFalseBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case STRING: {
                switch (from) {
                    case INTEGER_BOOLEAN: 
                    case TF_BOOLEAN: 
                    case YN_BOOLEAN: {
                        return BooleanDecoder.toString((CastType)from);
                    }
                    case DATE: {
                        return "to_char(?1,'YYYY-MM-DD')";
                    }
                    case TIME: {
                        return "to_char(?1,'HH24:MI:SS')";
                    }
                    case TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
                    }
                    case OFFSET_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
                    }
                    case ZONE_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
                    }
                }
                break;
            }
            case CLOB: {
                return "to_clob(?1)";
            }
            case DATE: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'YYYY-MM-DD')";
            }
            case TIME: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'HH24:MI:SS')";
            }
            case TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
            }
            case OFFSET_TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp_tz(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
            }
            case ZONE_TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp_tz(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
            }
        }
        return super.castPattern(from, to);
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "to_number(to_char(?2,'D'))";
            }
            case DAY_OF_MONTH: {
                return "to_number(to_char(?2,'DD'))";
            }
            case DAY_OF_YEAR: {
                return "to_number(to_char(?2,'DDD'))";
            }
            case WEEK: {
                return "to_number(to_char(?2,'IW'))";
            }
            case WEEK_OF_YEAR: {
                return "to_number(to_char(?2,'WW'))";
            }
            case QUARTER: {
                return "to_number(to_char(?2,'Q'))";
            }
            case HOUR: {
                return "to_number(to_char(?2,'HH24'))";
            }
            case MINUTE: {
                return "to_number(to_char(?2,'MI'))";
            }
            case SECOND: {
                return "to_number(to_char(?2,'SS'))";
            }
            case EPOCH: {
                return "trunc((cast(?2 at time zone 'UTC' as date) - date '1970-1-1')*86400)";
            }
        }
        return super.extractPattern(unit);
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        StringBuilder pattern = new StringBuilder();
        switch (unit) {
            case YEAR: {
                pattern.append(ADD_YEAR_EXPRESSION);
                break;
            }
            case QUARTER: {
                pattern.append(ADD_QUARTER_EXPRESSION);
                break;
            }
            case MONTH: {
                pattern.append(ADD_MONTH_EXPRESSION);
                break;
            }
            case WEEK: {
                pattern.append("(?3+numtodsinterval((?2)*7,'day'))");
                break;
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case DAY: {
                pattern.append("(?3+numtodsinterval(?2,'?1'))");
                break;
            }
            case NANOSECOND: {
                pattern.append("(?3+numtodsinterval((?2)/1e9,'second'))");
                break;
            }
            case NATIVE: {
                pattern.append("(?3+numtodsinterval(?2,'second'))");
                break;
            }
            default: {
                throw new SemanticException(unit + " is not a legal field");
            }
        }
        return pattern.toString();
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        boolean hasTimePart = toTemporalType != TemporalType.DATE || fromTemporalType != TemporalType.DATE;
        switch (unit) {
            case YEAR: {
                this.extractField(pattern, TemporalUnit.YEAR, unit);
                break;
            }
            case QUARTER: 
            case MONTH: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.YEAR, unit);
                pattern.append("+");
                this.extractField(pattern, TemporalUnit.MONTH, unit);
                pattern.append(")");
                break;
            }
            case WEEK: 
            case DAY: {
                this.extractField(pattern, TemporalUnit.DAY, unit);
                break;
            }
            case HOUR: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.DAY, unit);
                if (hasTimePart) {
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.HOUR, unit);
                }
                pattern.append(")");
                break;
            }
            case MINUTE: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.DAY, unit);
                if (hasTimePart) {
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.HOUR, unit);
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.MINUTE, unit);
                }
                pattern.append(")");
                break;
            }
            case SECOND: 
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.DAY, unit);
                if (hasTimePart) {
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.HOUR, unit);
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.MINUTE, unit);
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.SECOND, unit);
                }
                pattern.append(")");
                break;
            }
            default: {
                throw new SemanticException("unrecognized field: " + unit);
            }
        }
        return pattern.toString();
    }

    private void extractField(StringBuilder pattern, TemporalUnit unit, TemporalUnit toUnit) {
        pattern.append("extract(");
        pattern.append(this.translateExtractField(unit));
        pattern.append(" from (?3-?2) ");
        switch (unit) {
            case YEAR: 
            case MONTH: {
                pattern.append("year to month");
                break;
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case DAY: {
                pattern.append("day to second");
                break;
            }
            default: {
                throw new SemanticException(unit + " is not a legal field");
            }
        }
        pattern.append(")");
        pattern.append(unit.conversionFactor(toUnit, (Dialect)this));
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return "number(1,0)";
            }
            case -6: {
                return "number(3,0)";
            }
            case 5: {
                return "number(5,0)";
            }
            case 4: {
                return "number(10,0)";
            }
            case -5: {
                return "number(19,0)";
            }
            case 7: {
                return "float(24)";
            }
            case 2: 
            case 3: {
                return "number($p,$s)";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return this.getVersion().isBefore(9) ? "date" : super.columnType(sqlTypeCode);
            }
            case 93: 
            case 2014: {
                return this.getVersion().isBefore(9) ? "date" : super.columnType(sqlTypeCode);
            }
            case 2013: {
                return this.getVersion().isBefore(9) ? "date" : "timestamp($p) with time zone";
            }
            case 12: {
                return this.getVersion().isBefore(9) ? "varchar2($l)" : "varchar2($l char)";
            }
            case -9: {
                return "nvarchar2($l)";
            }
            case -3: 
            case -2: {
                return "raw($l)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2009, "SYS.XMLTYPE", (Dialect)this));
        if (this.getVersion().isSameOrAfter(10)) {
            ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3200, "MDSYS.SDO_GEOMETRY", (Dialect)this));
            if (this.getVersion().isSameOrAfter(21)) {
                ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3001, "json", (Dialect)this));
            } else if (this.getVersion().isSameOrAfter(12)) {
                ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3001, "blob", (Dialect)this));
            }
        }
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return this.getVersion().isSameOrAfter(9) ? TimeZoneSupport.NATIVE : TimeZoneSupport.NONE;
    }

    protected void initDefaultProperties() {
        super.initDefaultProperties();
        String newerVersion = Boolean.toString(this.getVersion().isSameOrAfter(12));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_versioned_data", newerVersion);
    }

    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public boolean getDefaultUseGetGeneratedKeys() {
        return this.getVersion().isSameOrAfter(12);
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 2016: {
                return jdbcTypeRegistry.getDescriptor(3001);
            }
            case 2002: {
                if ("MDSYS.SDO_GEOMETRY".equals(columnTypeName)) {
                    jdbcTypeCode = 3200;
                    break;
                }
                AggregateJdbcType aggregateDescriptor = jdbcTypeRegistry.findAggregateDescriptor(columnTypeName.substring(columnTypeName.indexOf(46) + 1));
                if (aggregateDescriptor == null) break;
                return aggregateDescriptor;
            }
            case 2: {
                if (scale == -127) {
                    if (precision <= this.getFloatPrecision()) {
                        return jdbcTypeRegistry.getDescriptor(6);
                    }
                    return jdbcTypeRegistry.getDescriptor(8);
                }
            }
            case 3: {
                if (scale != 0 || precision == 0) break;
                if (precision <= 10) {
                    return jdbcTypeRegistry.getDescriptor(4);
                }
                if (precision > 19) break;
                return jdbcTypeRegistry.getDescriptor(-5);
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public boolean supportsBitType() {
        return false;
    }

    public String getArrayTypeName(String javaElementTypeName, String elementTypeName, Integer maxLength) {
        return javaElementTypeName + "Array";
    }

    public int getPreferredSqlTypeCodeForArray() {
        return 2003;
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        typeContributions.contributeJdbcType((JdbcType)OracleBooleanJdbcType.INSTANCE);
        typeContributions.contributeJdbcType((JdbcType)OracleXmlJdbcType.INSTANCE);
        if (OracleJdbcHelper.isUsable((ServiceRegistry)serviceRegistry)) {
            typeContributions.contributeJdbcType(OracleJdbcHelper.getStructJdbcType((ServiceRegistry)serviceRegistry));
        } else {
            typeContributions.contributeJdbcType((JdbcType)OracleReflectionStructJdbcType.INSTANCE);
        }
        if (this.getVersion().isSameOrAfter(12)) {
            boolean preferLong = (Boolean)((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSetting(PREFER_LONG_RAW, StandardConverters.BOOLEAN, (Object)false);
            BlobJdbcType descriptor = preferLong ? BlobJdbcType.PRIMITIVE_ARRAY_BINDING : BlobJdbcType.DEFAULT;
            typeContributions.contributeJdbcType((JdbcType)descriptor);
            if (this.getVersion().isSameOrAfter(21)) {
                typeContributions.contributeJdbcType((JdbcType)OracleJsonJdbcType.INSTANCE);
            } else {
                typeContributions.contributeJdbcType((JdbcType)OracleJsonBlobJdbcType.INSTANCE);
            }
        }
        if (OracleJdbcHelper.isUsable((ServiceRegistry)serviceRegistry)) {
            typeContributions.contributeJdbcTypeConstructor(OracleJdbcHelper.getArrayJdbcTypeConstructor((ServiceRegistry)serviceRegistry));
        } else {
            typeContributions.contributeJdbcType((JdbcType)OracleReflectionStructJdbcType.INSTANCE);
        }
        typeContributions.contributeJdbcType((JdbcType)NullJdbcType.INSTANCE);
        typeContributions.contributeJdbcType((JdbcType)ObjectNullAsNullTypeJdbcType.INSTANCE);
        typeContributions.contributeType((BasicType)new NullType((JdbcType)NullJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(Object.class)));
        typeContributions.contributeType((BasicType)new JavaObjectType((JdbcType)ObjectNullAsNullTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(Object.class)));
    }

    public AggregateSupport getAggregateSupport() {
        return OracleAggregateSupport.valueOf((Dialect)this);
    }

    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion().isBefore(12) ? super.getIdentityColumnSupport() : Oracle12cIdentityColumnSupport.INSTANCE;
    }

    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        if (this.getVersion().isSameOrAfter(9)) {
            return super.getSelectClauseNullString(sqlType, typeConfiguration);
        }
        switch (sqlType) {
            case 1: 
            case 12: {
                return "to_char(null)";
            }
            case 91: 
            case 92: 
            case 93: 
            case 2014: {
                return "to_date(null)";
            }
        }
        return "to_number(null)";
    }

    public String getCurrentTimestampSelectString() {
        return this.getVersion().isBefore(9) ? "select sysdate from dual" : "select systimestamp from dual";
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    public boolean dropConstraints() {
        return false;
    }

    public SequenceSupport getSequenceSupport() {
        return OracleSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return "select * from all_sequences";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorOracleDatabaseImpl.INSTANCE;
    }

    public String getSelectGUIDString() {
        return "select rawtohex(sys_guid()) from dual";
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (JdbcExceptionHelper.extractErrorCode((SQLException)sqlException)) {
                case 30006: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case 54: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case 4021: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case 60: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 4020: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 1013: {
                    throw new QueryTimeoutException(message, sqlException, sql);
                }
                case 1407: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            return null;
        };
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, -10);
        return ++col;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return 1000;
    }

    public boolean forceLobAsLastValue() {
        return true;
    }

    public boolean isEmptyStringTreatedAsNull() {
        return true;
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)rootEntityDescriptor, basename -> "HT_" + basename, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)rootEntityDescriptor, name -> "HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    public String getTemporaryTableCreateOptions() {
        return "on commit delete rows";
    }

    public boolean useFollowOnLocking(String sql, QueryOptions queryOptions) {
        if (StringHelper.isEmpty((String)sql) || queryOptions == null) {
            return true;
        }
        return DISTINCT_KEYWORD_PATTERN.matcher(sql = sql.toLowerCase(Locale.ROOT)).find() || GROUP_BY_KEYWORD_PATTERN.matcher(sql).find() || UNION_KEYWORD_PATTERN.matcher(sql).find() || queryOptions.hasLimit() && (ORDER_BY_KEYWORD_PATTERN.matcher(sql).find() || queryOptions.getLimit().getFirstRow() != null);
    }

    public String getQueryHintString(String sql, String hints) {
        String statementType = this.statementType(sql);
        int start = sql.indexOf(statementType);
        if (start < 0) {
            return sql;
        }
        int end = start + statementType.length();
        return sql.substring(0, end) + " /*+ " + hints + " */" + sql.substring(end);
    }

    public int getMaxAliasLength() {
        return this.getVersion().isSameOrAfter(12, 2) ? 118 : 20;
    }

    public int getMaxIdentifierLength() {
        return this.getVersion().isSameOrAfter(12, 2) ? 128 : 30;
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.REF_CURSOR_INSTANCE;
    }

    public boolean canCreateSchema() {
        return false;
    }

    public String getCurrentSchemaCommand() {
        return "SELECT SYS_CONTEXT('USERENV','CURRENT_SCHEMA') FROM DUAL";
    }

    public boolean supportsPartitionBy() {
        return true;
    }

    private String statementType(String sql) {
        Matcher matcher = SQL_STATEMENT_TYPE_PATTERN.matcher(sql);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Can't determine SQL statement type for statement: " + sql);
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public boolean supportsFetchClause(FetchClauseType type) {
        return this.getVersion().isSameOrAfter(12, 2);
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public boolean supportsRecursiveCTE() {
        return this.getVersion().isSameOrAfter(11, 2);
    }

    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(12, 1);
    }

    public boolean supportsNoWait() {
        return this.getVersion().isSameOrAfter(9);
    }

    public boolean supportsSkipLocked() {
        return this.getVersion().isSameOrAfter(10);
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.COLUMN;
    }

    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    public String getForUpdateString(String aliases) {
        return " for update of " + aliases;
    }

    public String getForUpdateNowaitString(String aliases) {
        return " for update of " + aliases + " nowait";
    }

    public String getForUpdateSkipLockedString() {
        return " for update skip locked";
    }

    public String getForUpdateSkipLockedString(String aliases) {
        return " for update of " + aliases + " skip locked";
    }

    private String withTimeout(String lockString, int timeout) {
        switch (timeout) {
            case 0: {
                return this.supportsNoWait() ? lockString + " nowait" : lockString;
            }
            case -2: {
                return this.supportsSkipLocked() ? lockString + " skip locked" : lockString;
            }
            case -1: {
                return lockString;
            }
        }
        return this.supportsWait() ? lockString + " wait " + Math.round((float)timeout / 1000.0f) : lockString;
    }

    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    public String getReadLockString(int timeout) {
        return this.getWriteLockString(timeout);
    }

    public String getReadLockString(String aliases, int timeout) {
        return this.getWriteLockString(aliases, timeout);
    }

    public boolean supportsTemporalLiteralOffset() {
        return false;
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        if (precision == TemporalType.TIMESTAMP && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            appender.appendSql("timestamp '");
            DateTimeUtils.appendAsTimestampWithNanos((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)true, (TimeZone)jdbcTimeZone, (boolean)false);
            appender.appendSql('\'');
        } else {
            super.appendDateTimeLiteral(appender, temporalAccessor, precision, jdbcTimeZone);
        }
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleLegacyDialect.datetimeFormat(format, true, true).result());
    }

    public static Replacer datetimeFormat(String format, boolean useFm, boolean resetFm) {
        String fm = useFm ? "fm" : "";
        String fmReset = resetFm ? fm : "";
        return new Replacer(format, "'", "\"").replace("GG", "AD").replace("G", "AD").replace("yyyy", "YYYY").replace("yyy", fm + "YYYY" + fmReset).replace("yy", "YY").replace("y", fm + "YYYY" + fmReset).replace("MMMM", fm + "Month" + fmReset).replace("MMM", "Mon").replace("MM", "MM").replace("M", fm + "MM" + fmReset).replace("ww", "IW").replace("w", fm + "IW" + fmReset).replace("YYYY", "IYYY").replace("YYY", fm + "IYYY" + fmReset).replace("YY", "IY").replace("Y", fm + "IYYY" + fmReset).replace("W", "W").replace("EEEE", fm + "Day" + fmReset).replace("EEE", "Dy").replace("ee", "D").replace("e", fm + "D" + fmReset).replace("dd", "DD").replace("d", fm + "DD" + fmReset).replace("DDD", "DDD").replace("DD", fm + "DDD" + fmReset).replace("D", fm + "DDD" + fmReset).replace("a", "AM").replace("hh", "HH12").replace("HH", "HH24").replace("h", fm + "HH12" + fmReset).replace("H", fm + "HH24" + fmReset).replace("mm", "MI").replace("m", fm + "MI" + fmReset).replace("ss", "SS").replace("s", fm + "SS" + fmReset).replace("SSSSSS", "FF6").replace("SSSSS", "FF5").replace("SSSS", "FF4").replace("SSS", "FF3").replace("SS", "FF2").replace("S", "FF1").replace("zzz", "TZR").replace("zz", "TZR").replace("z", "TZR").replace("ZZZ", "TZHTZM").replace("ZZ", "TZHTZM").replace("Z", "TZHTZM").replace("xxx", "TZH:TZM").replace("xx", "TZHTZM").replace("x", "TZH");
    }

    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("hextoraw('");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql("')");
    }

    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        return (ResultSet)statement.getObject(position);
    }

    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        statement.registerOutParameter(name, -10);
        return 1;
    }

    public boolean supportsNamedParameters(DatabaseMetaData databaseMetaData) {
        return false;
    }

    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        return (ResultSet)statement.getObject(name);
    }

    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteInitialUnderscore(true);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    public boolean canDisableConstraints() {
        return true;
    }

    public String getDisableConstraintStatement(String tableName, String name) {
        return "alter table " + tableName + " disable constraint " + name;
    }

    public String getEnableConstraintStatement(String tableName, String name) {
        return "alter table " + tableName + " enable constraint " + name;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public String getCreateUserDefinedTypeKindString() {
        return "object";
    }

    public String rowId(String rowId) {
        return "rowid";
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }
}

