/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.AltibaseSqlAstTranslator;
import org.hibernate.community.dialect.pagination.AltibaseLimitHandler;
import org.hibernate.community.dialect.sequence.AltibaseSequenceSupport;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorAltibaseDatabaseImpl;
import org.hibernate.dialect.BooleanDecoder;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.OracleTruncFunction;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class AltibaseDialect
extends Dialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make((Integer)7, (Integer)1);

    public AltibaseDialect() {
        this(MINIMUM_VERSION);
    }

    public AltibaseDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(MINIMUM_VERSION));
        this.registerKeywords(info);
    }

    public AltibaseDialect(DatabaseVersion version) {
        super(version);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return "char(1)";
            }
            case 6: 
            case 8: {
                return "double";
            }
            case -6: {
                return "smallint";
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return "date";
            }
            case -2: {
                return "byte($l)";
            }
            case -3: {
                return "varbyte($l)";
            }
            case -4: {
                return "blob";
            }
            case -7: {
                return "varbit($l)";
            }
            case -1: 
            case 2011: {
                return "clob";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)-2, (String)this.columnType(-4), (Dialect)this).withTypeCapacity((long)this.getMaxVarbinaryLength(), this.columnType(-2)).build());
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)-7, (String)this.columnType(-4), (Dialect)this).withTypeCapacity(64000L, this.columnType(-7)).build());
    }

    public int getMaxVarcharLength() {
        return 32000;
    }

    public int getMaxVarbinaryLength() {
        return 32000;
    }

    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public String trimPattern(TrimSpec specification, boolean isWhitespace) {
        switch (specification) {
            case BOTH: {
                return isWhitespace ? "trim(?1)" : "trim(?1,?2)";
            }
            case LEADING: {
                return isWhitespace ? "ltrim(?1)" : "ltrim(?1,?2)";
            }
            case TRAILING: {
                return isWhitespace ? "rtrim(?1)" : "rtrim(?1,?2)";
            }
        }
        return super.trimPattern(specification, isWhitespace);
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("locate", typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER), "instr(?2,?1)", "instr(?2,?1,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, typeConfiguration).setArgumentListSignature("(pattern, string[, start])");
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.ceiling_ceil();
        functionFactory.trim2();
        functionFactory.stddev();
        functionFactory.variance();
        functionFactory.char_chr();
        functionFactory.concat_pipeOperator();
        functionFactory.coalesce();
        functionFactory.initcap();
        functionFactory.repeat_rpad();
        functionFactory.radians_acos();
        functionFactory.degrees_acos();
        functionFactory.ascii();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.lastDay();
        functionFactory.sysdate();
        functionFactory.rownum();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.log();
        functionFactory.log10_log();
        functionFactory.substring_substr();
        functionFactory.leftRight_substr();
        functionFactory.translate();
        functionFactory.addMonths();
        functionFactory.listagg(null);
        functionFactory.monthsBetween();
        functionFactory.windowFunctions();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.bitLength_pattern("bit_length(?1)", "lengthb(?1)*8");
        functionFactory.octetLength_pattern("octet_length(?1)", "lengthb(?1)");
        functionContributions.getFunctionRegistry().register("trunc", (SqmFunctionDescriptor)new OracleTruncFunction(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitand", "numand(?1,?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitor", "numor(?1,?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitxor", "numxor(?1,?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
    }

    public String currentDate() {
        return this.currentTimestamp();
    }

    public String currentTime() {
        return this.currentTimestamp();
    }

    public String currentTimestamp() {
        return "sysdate";
    }

    public String currentLocalTime() {
        return this.currentLocalTimestamp();
    }

    public String currentLocalTimestamp() {
        return "trunc(sysdate,'second')";
    }

    public String currentTimestampWithTimeZone() {
        return this.currentTimestamp();
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new AltibaseSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "extract(?2, 'DAYOFWEEK')";
            }
            case DAY_OF_MONTH: {
                return "extract(?2, 'DAY')";
            }
            case DAY_OF_YEAR: {
                return "extract(?2,'DAYOFYEAR')";
            }
            case WEEK: {
                return "to_number(to_char(?2,'IW'))";
            }
            case WEEK_OF_YEAR: {
                return "extract(?2, 'WEEK')";
            }
            case EPOCH: {
                return this.timestampdiffPattern(TemporalUnit.SECOND, TemporalType.TIMESTAMP, TemporalType.TIMESTAMP).replace("?2", "TO_DATE('1970-01-01 00:00:00','YYYY-MM-DD HH24:MI:SS')").replace("?3", "?2");
            }
            case QUARTER: {
                return "extract(?2, 'QUARTER')";
            }
        }
        return super.extractPattern(unit);
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: {
                return "timestampadd(MICROSECOND,(?2)/1e3,?3)";
            }
            case NATIVE: {
                return "timestampadd(SECOND, ?2, ?3)";
            }
        }
        return "timestampadd(?1, ?2, ?3)";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NATIVE: 
            case SECOND: {
                return "datediff(?2, ?3, 'SECOND')";
            }
            case NANOSECOND: {
                return "datediff(?2, ?3, 'MICROSECOND')*1e3";
            }
        }
        return "datediff(?2, ?3, '?1')";
    }

    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("VARBYTE'");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat((String)format, (boolean)false, (boolean)false).result());
    }

    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case INTEGER: 
            case LONG: {
                String result = BooleanDecoder.toInteger((CastType)from);
                if (result == null) break;
                return result;
            }
            case INTEGER_BOOLEAN: {
                String result = BooleanDecoder.toIntegerBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case YN_BOOLEAN: {
                String result = BooleanDecoder.toYesNoBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case TF_BOOLEAN: 
            case BOOLEAN: {
                String result = BooleanDecoder.toTrueFalseBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case STRING: {
                switch (from) {
                    case INTEGER_BOOLEAN: 
                    case TF_BOOLEAN: 
                    case YN_BOOLEAN: {
                        return BooleanDecoder.toString((CastType)from);
                    }
                    case DATE: {
                        return "to_char(?1,'YYYY-MM-DD')";
                    }
                    case TIME: {
                        return "to_char(?1,'HH24:MI:SS')";
                    }
                    case TIMESTAMP: 
                    case OFFSET_TIMESTAMP: 
                    case ZONE_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF6')";
                    }
                }
                break;
            }
            case CLOB: {
                return "cast(?1 as varchar(32000))";
            }
            case DATE: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'YYYY-MM-DD')";
            }
            case TIME: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'HH24:MI:SS')";
            }
            case TIMESTAMP: 
            case OFFSET_TIMESTAMP: 
            case ZONE_TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'YYYY-MM-DD HH24:MI:SS.FF6')";
            }
        }
        return super.castPattern(from, to);
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        if (precision == TemporalType.TIMESTAMP) {
            appender.appendSql("{ts '");
            DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone);
            appender.appendSql("'}");
            return;
        }
        super.appendDateTimeLiteral(appender, temporalAccessor, precision, jdbcTimeZone);
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        if (precision == TemporalType.TIMESTAMP) {
            appender.appendSql("{ts '");
            DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
            appender.appendSql("'}");
            return;
        }
        super.appendDateTimeLiteral(appender, date, precision, jdbcTimeZone);
    }

    public String translateDurationField(TemporalUnit unit) {
        if (unit == TemporalUnit.NATIVE) {
            return "microsecond";
        }
        return super.translateDurationField(unit);
    }

    public NullOrdering getNullOrdering() {
        return NullOrdering.LAST;
    }

    public String getAddColumnString() {
        return "add column (";
    }

    public String getAddColumnSuffixString() {
        return ")";
    }

    public int getMaxIdentifierLength() {
        return 40;
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteKeywords(true);
        builder.setAutoQuoteInitialUnderscore(false);
        builder.applyReservedWords(dbMetaData);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    public boolean canCreateSchema() {
        return false;
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No create schema syntax supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No drop schema syntax supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsTruncateWithCast() {
        return false;
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public boolean supportsPartitionBy() {
        return true;
    }

    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public SequenceSupport getSequenceSupport() {
        return AltibaseSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return "SELECT a.user_name USER_NAME, b.table_name SEQUENCE_NAME, c.current_seq CURRENT_VALUE, c.start_seq START_VALUE, c.min_seq MIN_VALUE, c.max_seq MAX_VALUE, c.increment_seq INCREMENT_BY, c.flag CYCLE_, c.sync_interval CACHE_SIZE FROM system_.sys_users_ a, system_.sys_tables_ b, x$seq c WHERE a.user_id = b.user_id AND b.table_oid = c.seq_oid AND a.user_name <> 'SYSTEM_' AND b.table_type = 'S' ORDER BY 1,2";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorAltibaseDatabaseImpl.INSTANCE;
    }

    public LimitHandler getLimitHandler() {
        return AltibaseLimitHandler.INSTANCE;
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select sysdate from dual";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    public boolean supportsOrderByInSubquery() {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    public boolean supportsTemporaryTables() {
        return false;
    }

    public boolean supportsTemporaryTablePrimaryKey() {
        return false;
    }

    protected boolean supportsPredicateAsExpression() {
        return false;
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "dayofyear";
            }
            case DAY_OF_WEEK: {
                return "dayofweek";
            }
        }
        return super.translateExtractField(unit);
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (JdbcExceptionHelper.extractErrorCode((SQLException)sqlException)) {
                case 4164: 
                case 334393: {
                    return new LockTimeoutException(message, sqlException, sql);
                }
                case 69720: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, constraintName);
                }
                case 200820: 
                case 200822: 
                case 200823: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            return null;
        };
    }
}

