/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class IngresSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public IngresSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        return AbstractSqlAstTranslator.LockStrategy.NONE;
    }

    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, offset);
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        if (!this.supportsOffsetFetchClause()) {
            this.renderFirstClause((QuerySpec)this.getQueryPartStack().getCurrent());
        }
        super.visitSqlSelections(selectClause);
    }

    protected void renderFetchExpression(Expression fetchExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderFetchExpression(fetchExpression);
        } else {
            this.renderExpressionAsLiteral(fetchExpression, this.getJdbcParameterBindings());
        }
    }

    protected void renderOffsetExpression(Expression offsetExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderOffsetExpression(offsetExpression);
        } else {
            this.renderExpressionAsLiteral(offsetExpression, this.getJdbcParameterBindings());
        }
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.supportsOffsetFetchClause()) {
            this.renderOffsetFetchClause(queryPart, false);
        } else if (!queryPart.isRoot() && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset clause in subquery");
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("dummy_.x");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    protected boolean needsRowsToSkip() {
        return !this.supportsOffsetFetchClause();
    }

    private boolean supportsParameterOffsetFetchExpression() {
        return this.getDialect().getVersion().isSameOrAfter(9, 3);
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion().isSameOrAfter(9, 3);
    }
}

