/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import net.sf.ehcache.hibernate.nonstop.HibernateNonstopCacheExceptionHandler;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.jboss.logging.Logger;

public class StorageAccessImpl
implements DomainDataStorageAccess {
    private static final Logger LOG = Logger.getLogger(StorageAccessImpl.class);
    private final Ehcache cache;

    public StorageAccessImpl(Ehcache cache) {
        this.cache = cache;
    }

    public Ehcache getCache() {
        return this.cache;
    }

    public boolean contains(Object key) {
        return this.getCache().isKeyInCache(key);
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        try {
            Element element = this.getCache().get(key);
            if (element == null) {
                return null;
            }
            return element.getObjectValue();
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
                return null;
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        try {
            Element element = new Element(key, value);
            this.getCache().put(element);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new CacheException((Throwable)e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void evictData(Object key) {
        try {
            this.getCache().remove(key);
        }
        catch (ClassCastException | IllegalStateException e) {
            throw new CacheException((Throwable)e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void evictData() {
        try {
            this.getCache().removeAll();
        }
        catch (IllegalStateException e) {
            throw new CacheException((Throwable)e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void release() {
        try {
            this.getCache().getCacheManager().removeCache(this.getCache().getName());
        }
        catch (IllegalStateException e) {
            LOG.debug((Object)"This can happen if multiple frameworks both try to shutdown ehcache", (Throwable)e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e instanceof NonStopCacheException) {
                HibernateNonstopCacheExceptionHandler.getInstance().handleNonstopCacheException((NonStopCacheException)e);
            }
            throw new CacheException((Throwable)e);
        }
    }
}

