/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import java.util.Collection;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.EntityInstantiator;
import org.hibernate.envers.query.criteria.AggregatedAuditExpression;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.MatchMode;
import org.hibernate.envers.query.criteria.internal.BetweenAuditExpression;
import org.hibernate.envers.query.criteria.internal.IlikeAuditExpression;
import org.hibernate.envers.query.criteria.internal.InAuditExpression;
import org.hibernate.envers.query.criteria.internal.NotNullAuditExpression;
import org.hibernate.envers.query.criteria.internal.NullAuditExpression;
import org.hibernate.envers.query.criteria.internal.PropertyAuditExpression;
import org.hibernate.envers.query.criteria.internal.SimpleAuditExpression;
import org.hibernate.envers.query.internal.property.ModifiedFlagPropertyName;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;
import org.hibernate.envers.query.order.AuditOrder;
import org.hibernate.envers.query.order.internal.PropertyAuditOrder;
import org.hibernate.envers.query.projection.AuditProjection;
import org.hibernate.envers.query.projection.internal.PropertyAuditProjection;

public class AuditProperty<T>
implements AuditProjection {
    private final String alias;
    private final PropertyNameGetter propertyNameGetter;

    public AuditProperty(String alias, PropertyNameGetter propertyNameGetter) {
        this.alias = alias;
        this.propertyNameGetter = propertyNameGetter;
    }

    public AuditCriterion hasChanged() {
        return new SimpleAuditExpression(this.alias, new ModifiedFlagPropertyName(this.propertyNameGetter), true, "=");
    }

    public AuditCriterion hasNotChanged() {
        return new SimpleAuditExpression(this.alias, new ModifiedFlagPropertyName(this.propertyNameGetter), false, "=");
    }

    public AuditCriterion eq(T value) {
        return new SimpleAuditExpression(this.alias, this.propertyNameGetter, value, "=");
    }

    public AuditCriterion ne(T value) {
        return new SimpleAuditExpression(this.alias, this.propertyNameGetter, value, "<>");
    }

    public AuditCriterion like(T value) {
        return new SimpleAuditExpression(this.alias, this.propertyNameGetter, value, " like ");
    }

    public AuditCriterion like(String value, MatchMode matchMode) {
        return new SimpleAuditExpression(this.alias, this.propertyNameGetter, matchMode.toMatchString(value), " like ");
    }

    public AuditCriterion ilike(T value) {
        return new IlikeAuditExpression(this.alias, this.propertyNameGetter, value.toString());
    }

    public AuditCriterion ilike(String value, MatchMode matchMode) {
        return new IlikeAuditExpression(this.alias, this.propertyNameGetter, matchMode.toMatchString(value));
    }

    public AuditCriterion gt(T value) {
        return new SimpleAuditExpression(this.alias, this.propertyNameGetter, value, ">");
    }

    public AuditCriterion lt(T value) {
        return new SimpleAuditExpression(this.alias, this.propertyNameGetter, value, "<");
    }

    public AuditCriterion le(T value) {
        return new SimpleAuditExpression(this.alias, this.propertyNameGetter, value, "<=");
    }

    public AuditCriterion ge(T value) {
        return new SimpleAuditExpression(this.alias, this.propertyNameGetter, value, ">=");
    }

    public AuditCriterion between(T lo, T hi) {
        return new BetweenAuditExpression(this.alias, this.propertyNameGetter, lo, hi);
    }

    public AuditCriterion in(T[] values) {
        return new InAuditExpression(this.alias, this.propertyNameGetter, values);
    }

    public AuditCriterion in(Collection values) {
        return new InAuditExpression(this.alias, this.propertyNameGetter, values.toArray());
    }

    public AuditCriterion isNull() {
        return new NullAuditExpression(this.alias, this.propertyNameGetter);
    }

    public AuditCriterion eqProperty(String otherPropertyName) {
        return this.eqProperty(this.alias, otherPropertyName);
    }

    public AuditCriterion eqProperty(String otherAlias, String otherPropertyName) {
        return new PropertyAuditExpression(this.alias, this.propertyNameGetter, otherAlias, otherPropertyName, "=");
    }

    public AuditCriterion neProperty(String otherPropertyName) {
        return this.neProperty(this.alias, otherPropertyName);
    }

    public AuditCriterion neProperty(String otherAlias, String otherPropertyName) {
        return new PropertyAuditExpression(this.alias, this.propertyNameGetter, otherAlias, otherPropertyName, "<>");
    }

    public AuditCriterion ltProperty(String otherPropertyName) {
        return this.ltProperty(this.alias, otherPropertyName);
    }

    public AuditCriterion ltProperty(String otherAlias, String otherPropertyName) {
        return new PropertyAuditExpression(this.alias, this.propertyNameGetter, otherAlias, otherPropertyName, "<");
    }

    public AuditCriterion leProperty(String otherPropertyName) {
        return this.leProperty(this.alias, otherPropertyName);
    }

    public AuditCriterion leProperty(String otherAlias, String otherPropertyName) {
        return new PropertyAuditExpression(this.alias, this.propertyNameGetter, otherAlias, otherPropertyName, "<=");
    }

    public AuditCriterion gtProperty(String otherPropertyName) {
        return this.gtProperty(this.alias, otherPropertyName);
    }

    public AuditCriterion gtProperty(String otherAlias, String otherPropertyName) {
        return new PropertyAuditExpression(this.alias, this.propertyNameGetter, otherAlias, otherPropertyName, ">");
    }

    public AuditCriterion geProperty(String otherPropertyName) {
        return this.geProperty(this.alias, otherPropertyName);
    }

    public AuditCriterion geProperty(String otherAlias, String otherPropertyName) {
        return new PropertyAuditExpression(this.alias, this.propertyNameGetter, otherAlias, otherPropertyName, ">=");
    }

    public AuditCriterion isNotNull() {
        return new NotNullAuditExpression(this.alias, this.propertyNameGetter);
    }

    public AggregatedAuditExpression maximize() {
        return new AggregatedAuditExpression(this.alias, this.propertyNameGetter, AggregatedAuditExpression.AggregatedMode.MAX);
    }

    public AggregatedAuditExpression minimize() {
        return new AggregatedAuditExpression(this.alias, this.propertyNameGetter, AggregatedAuditExpression.AggregatedMode.MIN);
    }

    public AuditProjection max() {
        return new PropertyAuditProjection(this.alias, this.propertyNameGetter, "max", false);
    }

    public AuditProjection min() {
        return new PropertyAuditProjection(this.alias, this.propertyNameGetter, "min", false);
    }

    public AuditProjection count() {
        return new PropertyAuditProjection(this.alias, this.propertyNameGetter, "count", false);
    }

    public AuditProjection countDistinct() {
        return new PropertyAuditProjection(this.alias, this.propertyNameGetter, "count", true);
    }

    public AuditProjection distinct() {
        return new PropertyAuditProjection(this.alias, this.propertyNameGetter, null, true);
    }

    public AuditProjection function(String functionName) {
        return new PropertyAuditProjection(this.alias, this.propertyNameGetter, functionName, false);
    }

    @Override
    public AuditProjection.ProjectionData getData(EnversService enversService) {
        return new AuditProjection.ProjectionData(null, this.alias, this.propertyNameGetter.get(enversService), false);
    }

    public AuditOrder asc() {
        return new PropertyAuditOrder(this.alias, this.propertyNameGetter, true);
    }

    public AuditOrder desc() {
        return new PropertyAuditOrder(this.alias, this.propertyNameGetter, false);
    }

    @Override
    public Object convertQueryResult(EnversService enversService, EntityInstantiator entityInstantiator, String entityName, Number revision, Object value) {
        return value;
    }
}

