/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.HibernateException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.AdditionalJaxbMappingProducer;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.envers.boot.EnversBootLogger;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.internal.MappingCollector;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class AdditionalJaxbMappingProducerImpl
implements AdditionalJaxbMappingProducer {
    private static final Logger log = Logger.getLogger(AdditionalJaxbMappingProducerImpl.class);

    public Collection<MappingDocument> produceAdditionalMappings(MetadataImplementor metadata, IndexView jandexIndex, MappingBinder mappingBinder, MetadataBuildingContext buildingContext) {
        MetadataBuildingOptions metadataBuildingOptions = metadata.getMetadataBuildingOptions();
        StandardServiceRegistry serviceRegistry = metadataBuildingOptions.getServiceRegistry();
        EnversService enversService = (EnversService)serviceRegistry.getService(EnversService.class);
        if (!enversService.isEnabled()) {
            return Collections.emptyList();
        }
        if (!metadataBuildingOptions.isXmlMappingEnabled()) {
            throw new HibernateException("Hibernate Envers currently requires XML mapping to be enabled. Please don't disable setting `hibernate.xml_mapping_enabled`; alternatively disable Hibernate Envers.");
        }
        ArrayList<MappingDocument> additionalMappingDocuments = new ArrayList<MappingDocument>();
        Origin origin = new Origin(SourceType.OTHER, "envers");
        MappingCollector mappingCollector = document -> {
            AdditionalJaxbMappingProducerImpl.logXml(document);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
                XMLWriter xw = new XMLWriter((Writer)w, new OutputFormat(" ", true));
                xw.write(document);
                ((Writer)w).flush();
            }
            catch (IOException e) {
                throw new HibernateException("Unable to bind Envers-generated XML", (Throwable)e);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
            Binding jaxbBinding = mappingBinder.bind((InputStream)bufferedInputStream, origin);
            JaxbHbmHibernateMapping jaxbRoot = (JaxbHbmHibernateMapping)jaxbBinding.getRoot();
            additionalMappingDocuments.add(new MappingDocument("envers", jaxbRoot, origin, buildingContext));
        };
        enversService.initialize(metadata, mappingCollector);
        return additionalMappingDocuments;
    }

    private static void logXml(Document document) {
        if (!EnversBootLogger.DEBUG_ENABLED) {
            return;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(outputStream);
        try {
            XMLWriter xw = new XMLWriter((Writer)w, new OutputFormat(" ", true));
            xw.write(document);
            ((Writer)w).flush();
        }
        catch (IOException e1) {
            throw new RuntimeException("Error dumping enhanced class", e1);
        }
        EnversBootLogger.BOOT_LOGGER.jaxbContribution(outputStream.toString());
        log.tracef("Envers-generate entity mapping -----------------------------\n%s", (Object)outputStream.toString());
        log.trace((Object)"------------------------------------------------------------");
    }
}

