/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeIdType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSimpleIdType;
import org.hibernate.envers.boot.model.Attribute;
import org.hibernate.envers.boot.model.DiscriminatorType;
import org.hibernate.envers.boot.model.Identifier;
import org.hibernate.envers.boot.model.Join;
import org.hibernate.envers.boot.model.JoinAwarePersistentEntity;
import org.hibernate.envers.boot.model.PersistentEntity;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.mapping.PersistentClass;

public class RootPersistentEntity
extends PersistentEntity
implements JoinAwarePersistentEntity {
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<Join> joins = new ArrayList<Join>();
    private Identifier identifier;
    private String className;
    private String tableName;
    private String whereClause;
    private DiscriminatorType discriminator;
    private String discriminatorValue;

    public RootPersistentEntity(AuditTableData auditTableData, PersistentClass persistentClass) {
        super(auditTableData, persistentClass);
    }

    public RootPersistentEntity(AuditTableData auditTableData, String className, String tableName) {
        super(auditTableData, null);
        this.className = className;
        this.tableName = tableName;
    }

    @Override
    public boolean isJoinAware() {
        return true;
    }

    @Override
    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public DiscriminatorType getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(DiscriminatorType discriminator) {
        this.discriminator = discriminator;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    @Override
    public List<Join> getJoins() {
        return Collections.unmodifiableList(this.joins);
    }

    @Override
    public void addJoin(Join join) {
        this.joins.add(join);
    }

    @Override
    public void build(JaxbHbmHibernateMapping mapping) {
        mapping.getClazz().add(this.buildJaxbMapping());
    }

    private JaxbHbmRootEntityType buildJaxbMapping() {
        Object id;
        JaxbHbmRootEntityType entity = new JaxbHbmRootEntityType();
        if (this.getPersistentClass() != null) {
            entity.setAbstract(this.getPersistentClass().isAbstract());
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getAuditEntityName())) {
            entity.setEntityName(this.getAuditTableData().getAuditEntityName());
        } else if (!StringTools.isEmpty(this.className)) {
            entity.setName(this.className);
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getAuditTableName())) {
            entity.setTable(this.getAuditTableData().getAuditTableName());
        } else if (!StringTools.isEmpty(this.tableName)) {
            entity.setTable(this.tableName);
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getSchema())) {
            entity.setSchema(this.getAuditTableData().getSchema());
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getCatalog())) {
            entity.setCatalog(this.getAuditTableData().getCatalog());
        }
        if ((id = this.identifier.build()) instanceof JaxbHbmSimpleIdType) {
            entity.setId((JaxbHbmSimpleIdType)id);
        } else if (id instanceof JaxbHbmCompositeIdType) {
            entity.setCompositeId((JaxbHbmCompositeIdType)id);
        } else {
            throw new HibernateException("Unknown identifier type: " + id.getClass().getName());
        }
        for (Attribute attribute : this.attributes) {
            entity.getAttributes().add((Serializable)attribute.build());
        }
        for (Join join : this.joins) {
            entity.getJoin().add(join.build());
        }
        if (!StringTools.isEmpty(this.whereClause)) {
            entity.setWhere(this.whereClause);
        }
        if (this.discriminator != null) {
            entity.setDiscriminator(this.discriminator.build());
        }
        if (!StringTools.isEmpty(this.discriminatorValue)) {
            entity.setDiscriminatorValue(this.discriminatorValue);
        }
        return entity;
    }
}

