/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.envers.boot.model.AttributeContainer;
import org.hibernate.envers.boot.registry.classloading.ClassLoaderAccessHelper;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.internal.metadata.AbstractMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.EntityMappingData;
import org.hibernate.envers.configuration.internal.metadata.ValueMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.internal.EmbeddableCompositeUserTypeInstantiator;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.usertype.CompositeUserType;

public final class ComponentMetadataGenerator
extends AbstractMetadataGenerator {
    private final ValueMetadataGenerator valueGenerator;

    ComponentMetadataGenerator(EnversMetadataBuildingContext metadataBuildingContext, ValueMetadataGenerator valueGenerator) {
        super(metadataBuildingContext);
        this.valueGenerator = valueGenerator;
    }

    public void addComponent(AttributeContainer attributeContainer, PropertyAuditingData propertyAuditingData, Value value, CompositeMapperBuilder mapper, String entityName, EntityMappingData mappingData, boolean firstPass) {
        EmbeddableInstantiator instantiator;
        Component propComponent = (Component)value;
        Class instantiatorClass = propComponent.getCustomInstantiator() != null ? propComponent.getCustomInstantiator() : null;
        if (propComponent.getCustomInstantiator() != null) {
            instantiator = (EmbeddableInstantiator)((ManagedBeanRegistry)this.getMetadataBuildingContext().getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class)).getBean(propComponent.getCustomInstantiator()).getBeanInstance();
        } else if (propComponent.getTypeName() != null) {
            CompositeUserType compositeUserType = (CompositeUserType)((ManagedBeanRegistry)this.getMetadataBuildingContext().getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class)).getBean(this.getMetadataBuildingContext().getBootstrapContext().getClassLoaderAccess().classForName(propComponent.getTypeName())).getBeanInstance();
            instantiator = new EmbeddableCompositeUserTypeInstantiator(compositeUserType);
        } else {
            instantiator = null;
        }
        CompositeMapperBuilder componentMapper = mapper.addComponent(propertyAuditingData.resolvePropertyData(), ClassLoaderAccessHelper.loadClass(this.getMetadataBuildingContext(), this.getClassNameForComponent(propComponent)), instantiator);
        ComponentAuditingData componentAuditingData = (ComponentAuditingData)propertyAuditingData;
        propComponent.sortProperties();
        Iterator properties = propComponent.getPropertyIterator();
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            PropertyAuditingData componentPropertyAuditingData = componentAuditingData.getPropertyAuditingData(property.getName());
            if (componentPropertyAuditingData == null) continue;
            this.valueGenerator.addValue(attributeContainer, property.getValue(), property.getPropertyAccessStrategy(), componentMapper, entityName, mappingData, componentPropertyAuditingData, property.isInsertable(), firstPass, false);
        }
        if (!firstPass) {
            EntityConfiguration owningEntityConfiguration = this.getAuditedEntityConfigurations().get(entityName);
            owningEntityConfiguration.addToOneComponent(propertyAuditingData.getName(), componentAuditingData);
        }
    }

    private String getClassNameForComponent(Component component) {
        return component.isDynamic() ? Map.class.getCanonicalName() : component.getComponentClassName();
    }
}

