/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.EffectiveMappingDefaults;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.envers.boot.internal.EnversMetadataBuildingContextImpl;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.configuration.internal.EntitiesConfigurator;
import org.hibernate.envers.configuration.internal.MappingCollector;
import org.hibernate.envers.internal.entities.EntitiesConfigurations;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.revisioninfo.ModifiedEntityNamesReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoQueryCreator;
import org.hibernate.envers.internal.synchronization.AuditProcessManager;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.strategy.spi.AuditStrategyContext;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.jboss.logging.Logger;

public class EnversServiceImpl
implements EnversService,
Configurable,
Stoppable {
    private static final Logger log = Logger.getLogger(EnversServiceImpl.class);
    private static final String LEGACY_AUTO_REGISTER = "hibernate.listeners.envers.autoRegister";
    private boolean integrationEnabled;
    private boolean initialized;
    private ServiceRegistry serviceRegistry;
    private ClassLoaderService classLoaderService;
    private Configuration configuration;
    private AuditProcessManager auditProcessManager;
    private EntitiesConfigurations entitiesConfigurations;

    public void configure(Map<String, Object> configurationValues) {
        if (configurationValues.containsKey(LEGACY_AUTO_REGISTER)) {
            log.debugf("Encountered deprecated Envers setting [%s]; use [%s] or [%s] instead", (Object)LEGACY_AUTO_REGISTER, (Object)"hibernate.integration.envers.enabled", (Object)"hibernate.envers.autoRegisterListeners");
        }
        this.integrationEnabled = ConfigurationHelper.getBoolean((String)"hibernate.integration.envers.enabled", configurationValues, (boolean)true);
        log.infof("Envers integration enabled? : %s", (Object)this.integrationEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.integrationEnabled;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void initialize(MetadataImplementor metadata, MappingCollector mappingCollector, EffectiveMappingDefaults effectiveMappingDefaults) {
        if (this.initialized) {
            throw new UnsupportedOperationException("EnversService#initialize should be called only once");
        }
        this.initialized = true;
        this.serviceRegistry = metadata.getMetadataBuildingOptions().getServiceRegistry();
        this.classLoaderService = (ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class);
        ConfigurationService cfgService = (ConfigurationService)this.serviceRegistry.getService(ConfigurationService.class);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)cfgService.getSettings());
        this.configuration = new Configuration(properties, this, metadata);
        this.auditProcessManager = new AuditProcessManager(this.configuration.getRevisionInfo().getRevisionInfoGenerator());
        EnversMetadataBuildingContextImpl metadataBuildingContext = new EnversMetadataBuildingContextImpl(this.configuration, (InFlightMetadataCollector)metadata, effectiveMappingDefaults, mappingCollector);
        this.configuration.getAuditStrategy().postInitialize(new AuditStrategyContext(){

            @Override
            public Class<?> getRevisionInfoClass() {
                return EnversServiceImpl.this.configuration.getRevisionInfo().getRevisionInfoClass();
            }

            @Override
            public Getter getRevisionInfoTimestampAccessor() {
                PropertyData pd = EnversServiceImpl.this.configuration.getRevisionInfo().getRevisionInfoTimestampData();
                return ReflectionTools.getGetter(this.getRevisionInfoClass(), pd, EnversServiceImpl.this.serviceRegistry);
            }
        });
        this.entitiesConfigurations = new EntitiesConfigurator().configure(metadataBuildingContext);
    }

    @Override
    public Configuration getConfig() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.configuration;
    }

    @Override
    public AuditProcessManager getAuditProcessManager() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.auditProcessManager;
    }

    @Override
    @Deprecated
    public AuditStrategy getAuditStrategy() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.configuration.getAuditStrategy();
    }

    @Override
    public EntitiesConfigurations getEntitiesConfigurations() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.entitiesConfigurations;
    }

    @Override
    public RevisionInfoQueryCreator getRevisionInfoQueryCreator() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.configuration.getRevisionInfo().getRevisionInfoQueryCreator();
    }

    @Override
    public RevisionInfoNumberReader getRevisionInfoNumberReader() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.configuration.getRevisionInfo().getRevisionInfoNumberReader();
    }

    @Override
    public ModifiedEntityNamesReader getModifiedEntityNamesReader() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.configuration.getRevisionInfo().getModifiedEntityNamesReader();
    }

    @Override
    public ClassLoaderService getClassLoaderService() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.classLoaderService;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.serviceRegistry;
    }

    public void stop() {
    }
}

