/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.id;

import java.util.Map;
import org.hibernate.Session;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.EntitiesConfigurations;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.EntityType;

public class VirtualEntitySingleIdMapper
extends SingleIdMapper {
    private final PropertyData propertyData;
    private final String entityName;
    private IdMapper entityIdMapper;

    public VirtualEntitySingleIdMapper(ServiceRegistry serviceRegistry, PropertyData propertyData) {
        super(serviceRegistry, propertyData);
        this.propertyData = propertyData;
        this.entityName = VirtualEntitySingleIdMapper.resolveEntityName(this.propertyData);
    }

    @Override
    public void mapToMapFromId(Session session, Map<String, Object> data, Object obj) {
        Object value = this.getValueFromObject(this.propertyData, obj);
        Object entity = session.getReference(this.entityName, value);
        data.put(this.propertyData.getName(), entity);
    }

    @Override
    public void mapToEntityFromEntity(Object objTo, Object objFrom) {
        if (objTo == null || objFrom == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(objFrom.getClass(), this.propertyData, this.getServiceRegistry());
        Setter setter = ReflectionTools.getSetter(objTo.getClass(), this.propertyData, this.getServiceRegistry());
        Object value = getter.get(objFrom);
        if (value == null) {
            return;
        }
        if (!value.getClass().equals(this.propertyData.getVirtualReturnClass())) {
            setter.set(objTo, this.getAssociatedEntityIdMapper().mapToIdFromEntity(value));
        } else {
            setter.set(objTo, value);
        }
    }

    @Override
    public boolean mapToEntityFromMap(Object obj, Map data) {
        if (data == null || obj == null) {
            return false;
        }
        Object value = data.get(this.propertyData.getName());
        if (value == null) {
            return false;
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyData, this.getServiceRegistry());
        Class<?> paramClass = ReflectionTools.getType(obj.getClass(), this.propertyData, this.getServiceRegistry());
        if (paramClass != null && paramClass.equals(this.propertyData.getVirtualReturnClass())) {
            setter.set(obj, this.getAssociatedEntityIdMapper().mapToIdFromEntity(value));
        } else {
            setter.set(obj, value);
        }
        return true;
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, Object obj) {
        if (obj == null) {
            data.put(this.propertyData.getName(), null);
        } else {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)obj);
            if (lazyInitializer != null) {
                data.put(this.propertyData.getName(), lazyInitializer.getInternalIdentifier());
            } else {
                Object value = this.getValueFromObject(this.propertyData, obj);
                if (this.propertyData.getVirtualReturnClass().isInstance(value)) {
                    this.getPrefixedAssociatedEntityIdMapper(this.propertyData).mapToMapFromId(data, value);
                } else {
                    data.put(this.propertyData.getName(), value);
                }
            }
        }
    }

    private IdMapper getAssociatedEntityIdMapper() {
        if (this.entityIdMapper == null) {
            this.entityIdMapper = VirtualEntitySingleIdMapper.resolveEntityIdMapper(this.getServiceRegistry(), this.entityName);
        }
        return this.entityIdMapper;
    }

    private IdMapper getPrefixedAssociatedEntityIdMapper(PropertyData propertyData) {
        return this.getAssociatedEntityIdMapper().prefixMappedProperties(propertyData.getName() + ".");
    }

    private static String resolveEntityName(PropertyData propertyData) {
        if (EntityType.class.isInstance(propertyData.getType())) {
            EntityType entityType = (EntityType)propertyData.getType();
            return entityType.getAssociatedEntityName();
        }
        return null;
    }

    private static IdMapper resolveEntityIdMapper(ServiceRegistry serviceRegistry, String entityName) {
        EntitiesConfigurations entitiesConfigurations = ((EnversService)serviceRegistry.getService(EnversService.class)).getEntitiesConfigurations();
        EntityConfiguration auditedEntityConfiguration = entitiesConfigurations.get(entityName);
        if (auditedEntityConfiguration != null) {
            return auditedEntityConfiguration.getIdMapper();
        }
        return entitiesConfigurations.getNotVersionEntityConfiguration(entityName).getIdMapper();
    }
}

