/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.TypeUtils;

class BasicAttributeVisitor
extends SimpleTypeVisitor6<Boolean, Element> {
    private final @UnknownKeyFor @NonNull @Initialized Context context;

    public BasicAttributeVisitor(@UnknownKeyFor @NonNull @Initialized Context context) {
        super(Boolean.FALSE);
        this.context = context;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean visitPrimitive(@UnknownKeyFor @NonNull @Initialized PrimitiveType t, @UnknownKeyFor @NonNull @Initialized Element element) {
        return Boolean.TRUE;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean visitArray(@UnknownKeyFor @NonNull @Initialized ArrayType t, @UnknownKeyFor @NonNull @Initialized Element element) {
        TypeMirror componentMirror = t.getComponentType();
        TypeElement componentElement = (TypeElement)this.context.getTypeUtils().asElement(componentMirror);
        return Constants.BASIC_ARRAY_TYPES.contains(componentElement.getQualifiedName().toString());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean visitDeclared(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element) {
        if (ElementKind.ENUM.equals((Object)element.getKind())) {
            return Boolean.TRUE;
        }
        if (ElementKind.CLASS.equals((Object)element.getKind()) || ElementKind.INTERFACE.equals((Object)element.getKind())) {
            TypeElement typeElement = (TypeElement)element;
            String typeName = typeElement.getQualifiedName().toString();
            if (Constants.BASIC_TYPES.contains(typeName)) {
                return Boolean.TRUE;
            }
            if (TypeUtils.containsAnnotation(element, "jakarta.persistence.Embeddable")) {
                return Boolean.TRUE;
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                TypeElement interfaceElement = (TypeElement)this.context.getTypeUtils().asElement(typeMirror);
                if (!"java.io.Serializable".equals(interfaceElement.getQualifiedName().toString())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

