/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.model.ImportContext;

public class ImportContextImpl
implements ImportContext {
    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> imports = new TreeSet<String>();
    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> staticImports = new TreeSet<String>();
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> simpleNames = new HashMap<String, String>();
    private @UnknownKeyFor @NonNull @Initialized String basePackage = "";
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> PRIMITIVES = new HashMap<String, String>();

    public ImportContextImpl(@UnknownKeyFor @NonNull @Initialized String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String importType(@UnknownKeyFor @NonNull @Initialized String fqcn) {
        boolean canBeSimple;
        Object result = fqcn;
        String additionalTypePart = null;
        if (fqcn.indexOf(60) >= 0) {
            additionalTypePart = ((String)result).substring(fqcn.indexOf(60));
            result = ((String)result).substring(0, fqcn.indexOf(60));
            fqcn = result;
        } else if (fqcn.indexOf(91) >= 0) {
            additionalTypePart = ((String)result).substring(fqcn.indexOf(91));
            result = ((String)result).substring(0, fqcn.indexOf(91));
            fqcn = result;
        }
        String pureFqcn = fqcn.replace('$', '.');
        String simpleName = ImportContextImpl.unqualify(fqcn);
        if (this.simpleNames.containsKey(simpleName)) {
            String existingFqcn = this.simpleNames.get(simpleName);
            canBeSimple = existingFqcn.equals(pureFqcn);
        } else {
            canBeSimple = true;
            this.simpleNames.put(simpleName, pureFqcn);
            this.imports.add(pureFqcn);
        }
        if (this.inSamePackage(fqcn) || this.imports.contains(pureFqcn) && canBeSimple) {
            result = ImportContextImpl.unqualify((String)result);
        } else if (this.inJavaLang(fqcn)) {
            result = ((String)result).substring("java.lang.".length());
        }
        if (additionalTypePart != null) {
            result = (String)result + additionalTypePart;
        }
        result = ((String)result).replace('$', '.');
        return result;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String staticImport(@UnknownKeyFor @NonNull @Initialized String fqcn, @UnknownKeyFor @NonNull @Initialized String member) {
        String local = fqcn + "." + member;
        this.imports.add(local);
        this.staticImports.add(local);
        if (member.equals("*")) {
            return "";
        }
        return member;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean inDefaultPackage(@UnknownKeyFor @NonNull @Initialized String className) {
        return className.indexOf(".") < 0;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPrimitive(@UnknownKeyFor @NonNull @Initialized String className) {
        return PRIMITIVES.containsKey(className);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean inSamePackage(@UnknownKeyFor @NonNull @Initialized String className) {
        String other = ImportContextImpl.qualifier(className);
        return other == this.basePackage || other != null && other.equals(this.basePackage);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean inJavaLang(@UnknownKeyFor @NonNull @Initialized String className) {
        return "java.lang".equals(ImportContextImpl.qualifier(className));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String generateImports() {
        StringBuilder builder = new StringBuilder();
        for (String next : this.imports) {
            if (this.isAutoImported(next)) continue;
            if (this.staticImports.contains(next)) {
                builder.append("import static ").append(next).append(";").append(System.lineSeparator());
                continue;
            }
            builder.append("import ").append(next).append(";").append(System.lineSeparator());
        }
        if (builder.indexOf("$") >= 0) {
            return builder.toString();
        }
        return builder.toString();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isAutoImported(@UnknownKeyFor @NonNull @Initialized String next) {
        return this.isPrimitive(next) || this.inDefaultPackage(next) || this.inJavaLang(next) || this.inSamePackage(next);
    }

    public static @UnknownKeyFor @NonNull @Initialized String unqualify(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        return loc < 0 ? qualifiedName : qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
    }

    public static @UnknownKeyFor @NonNull @Initialized String qualifier(@UnknownKeyFor @NonNull @Initialized String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(".");
        return loc < 0 ? "" : qualifiedName.substring(0, loc);
    }

    static {
        PRIMITIVES.put("char", "Character");
        PRIMITIVES.put("byte", "Byte");
        PRIMITIVES.put("short", "Short");
        PRIMITIVES.put("int", "Integer");
        PRIMITIVES.put("long", "Long");
        PRIMITIVES.put("boolean", "Boolean");
        PRIMITIVES.put("float", "Float");
        PRIMITIVES.put("double", "Double");
    }
}

