/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.beans.Introspector;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.util.Elements;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.Metamodel;
import org.hibernate.jpamodelgen.util.StringUtil;

public abstract class AnnotationMetaAttribute
implements MetaAttribute {
    final @UnknownKeyFor @NonNull @Initialized Element element;
    final @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity parent;
    private final @UnknownKeyFor @NonNull @Initialized String type;

    public AnnotationMetaAttribute(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity parent, @UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized String type) {
        this.element = element;
        this.parent = parent;
        this.type = type;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        return "\n/**\n * @see " + this.parent.getQualifiedName() + "#" + this.element.getSimpleName() + "\n **/\n" + "public static volatile " + this.parent.importType(this.getMetaType()) + "<" + this.parent.importType(this.parent.getQualifiedName()) + ", " + this.parent.importType(this.getTypeDeclaration()) + "> " + this.getPropertyName() + ";";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        return "public static final " + this.parent.importType(String.class.getName()) + " " + StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(this.getPropertyName()) + " = " + "\"" + this.getPropertyName() + "\"" + ";";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        Elements elementsUtil = this.parent.getContext().getElementUtils();
        if (this.element.getKind() == ElementKind.FIELD) {
            return this.element.getSimpleName().toString();
        }
        if (this.element.getKind() == ElementKind.METHOD) {
            String name = this.element.getSimpleName().toString();
            if (name.startsWith("get")) {
                return elementsUtil.getName(Introspector.decapitalize(name.substring("get".length()))).toString();
            }
            if (name.startsWith("is")) {
                return elementsUtil.getName(Introspector.decapitalize(name.substring("is".length()))).toString();
            }
            return elementsUtil.getName(Introspector.decapitalize(name)).toString();
        }
        return elementsUtil.getName(this.element.getSimpleName() + "/* " + this.element.getKind() + " */").toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.parent;
    }

    @Override
    public abstract @UnknownKeyFor @NonNull @Initialized String getMetaType();

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return this.type;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "AnnotationMetaAttribute" + "{element=" + this.element + ", type='" + this.type + '\'' + '}';
    }
}

